/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.helper.ReceredWayHelper;
import kd.fi.cas.business.opservice.helper.LoadCalResultDataHelper;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.MatchStatusEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.ResultSaveAutoMatchStatus;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EnterConfirmPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BillList list = (BillList)this.getControl("billlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("id,number,rulename,entryentity.record asc");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        list.setFilter(numberFilter);
        list.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listColumns = args.getListColumns();
                FormShowParameter formShowParameter = EnterConfirmPlugin.this.getView().getFormShowParameter();
                String type = (String)formShowParameter.getCustomParam("type");
                for (IListColumn column : listColumns) {
                    String key = column.getListFieldKey();
                    if (("amount".equals(key) || key.startsWith("rectype")) && "pay".equals(type)) {
                        column.setVisible(0);
                        continue;
                    }
                    if (!"payamount".equals(key) && !key.startsWith("paytype") || "pay".equals(type)) continue;
                    column.setVisible(0);
                }
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("num".equals(fieldName)) {
            BillList list = (BillList)this.getControl("billlistap");
            int rowIndex = arg0.getRowIndex();
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cas_autocalresult");
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
            DynamicObject bizDO = (DynamicObject)col.get(rowIndex % 2);
            String str = bizDO.getString("billid");
            String billFlag = LoadCalResultDataHelper.getBizBillType((DynamicObject)bizDO);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(billFlag);
            showParameter.setPkId((Object)str);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String type = (String)formShowParameter.getCustomParam("type");
        if ("pay".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok", "noticebtnok"});
        } else if ("notice".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok", "paybtnok"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"paybtnok", "noticebtnok"});
        }
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        LoadCalResultDataHelper.loadCalResultData((String)thisOpnumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeTitle();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        if (!CasHelper.isEmpty((Object)thisOpnumber)) {
            this.asynDelThisOpData(thisOpnumber);
        }
    }

    public void asynDelThisOpData(Object thisOpnumber) {
        ThreadPools.executeOnceIncludeRequestContext((String)"delThisOpNumber", () -> {
            QFilter thisOpnumberFilter = new QFilter("number", "=", thisOpnumber);
            DeleteServiceHelper.delete((String)"cas_autocalresult", (QFilter[])new QFilter[]{thisOpnumberFilter});
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap returnData = new HashMap();
        switch (key) {
            case "btnok": {
                this.ruleORHandOp();
                break;
            }
            case "btncancel": {
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        switch (operateKey = op.getOperateKey()) {
            case "confirmmatch": 
            case "cancelmatch": {
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = list.getSelectedRows();
                op.getOption().setVariableValue("selectedRowsData", StringUtils.join((Object[])rows.getPrimaryKeyValues(), (String)","));
                break;
            }
            case "paybtnok": {
                this.ruleORHandOp();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        BillList list = (BillList)this.getControl("billlistap");
        String key = evt.getOperateKey();
        if ("confirmmatch".equals(key) && evt.getOperationResult().isSuccess()) {
            list.clearSelection();
            list.refresh();
            this.changeTitle();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f\u3002", (String)"EnterConfirmPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("cancelmatch".equals(key) && evt.getOperationResult().isSuccess()) {
            list.clearSelection();
            list.refresh();
            this.changeTitle();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u6210\u529f\u3002", (String)"EnterConfirmPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("noticebtnok".equals(key) && evt.getOperationResult().isSuccess()) {
            Pair<DynamicObjectCollection, Set<Long>> pair;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String noticeIdStr = (String)formShowParameter.getCustomParams().get("noticeId");
            HashSet returnNoticeId = new HashSet(16);
            if (EmptyUtil.isNoEmpty((String)noticeIdStr)) {
                Set noticeId = (Set)SerializationUtils.fromJsonString((String)noticeIdStr, Set.class);
                returnNoticeId.addAll(noticeId);
            }
            if ((pair = this.getDetailIdsAndResult()) != null) {
                Set detailIds = (Set)pair.getRight();
                returnNoticeId.addAll(detailIds);
            }
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("returnNoticeId", SerializationUtils.toJsonString(returnNoticeId));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void changeTitle() {
        Label label1 = (Label)this.getControl("labelap");
        Label label2 = (Label)this.getControl("labelap1");
        Label label3 = (Label)this.getControl("labelap3");
        Label label4 = (Label)this.getControl("labelap5");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String type = (String)formShowParameter.getCustomParam("type");
        String failIds = (String)formShowParameter.getCustomParam("failIds");
        DynamicObject[] objs = this.loadAutoCalResult();
        if (CasHelper.isEmpty((DynamicObject[])objs) || objs.length <= 0) {
            return;
        }
        long size = Arrays.stream(objs).map(item -> item.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(item -> "0".equals(item.getString("record"))).map(item -> item.getString("billid")).distinct().count();
        int count_matched = 0;
        int count_nomatch = 0;
        for (DynamicObject obj : objs) {
            String matchStatus = obj.getString("matchstatus");
            long entryDetailSize = obj.getDynamicObjectCollection("entryentity").stream().filter(item -> "0".equals(item.getString("record"))).map(item -> item.getString("billid")).distinct().count();
            if (ResultSaveAutoMatchStatus.AlMATCH.getValue().equals(matchStatus)) {
                count_matched = (int)((long)count_matched + entryDetailSize);
                continue;
            }
            if (!ResultSaveAutoMatchStatus.UNMATCH.getValue().equals(matchStatus)) continue;
            count_nomatch = (int)((long)count_nomatch + entryDetailSize);
        }
        String selectedSize = (String)formShowParameter.getCustomParam("selectedSize");
        String successIds = (String)formShowParameter.getCustomParam("successIds");
        String str1 = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684%1$s\u6761\u8bb0\u5f55\u4e2d\uff0c%2$s\u6761\u5df2\u751f\u5355\u6210\u529f\uff0c%3$s\u6761\u5931\u8d25", (String)"EnterConfirmPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "\uff0c", selectedSize, successIds, failIds);
        String str2 = String.format(ResManager.loadKDString((String)"\u53e6\u5916%s\u6761\u53ef\u8fdb\u884c\u81ea\u52a8\u5339\u914d", (String)"EnterConfirmPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "\uff0c", size);
        String str3 = count_matched + "";
        String str4 = count_nomatch + "";
        label1.setText(str1);
        label2.setText(str2);
        label3.setText(str3);
        label4.setText(str4);
        if ("pay".equals(type)) {
            Label label5 = (Label)this.getControl("labelap6");
            label5.setText(ResManager.loadKDString((String)"\u6761\u8bb0\u5f55\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"EnterConfirmPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("notice".equals(type)) {
            label1.setText(ResManager.loadKDString((String)"\u6240\u9009\u7684%s\u6761\u8bb0\u5f55\u4e2d\uff0c", (String)"EnterConfirmPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[]{selectedSize}));
            label2.setText(ResManager.loadKDString((String)"%s\u6761\u53ef\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c", (String)"EnterConfirmPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[]{successIds}));
            label4.setText((count_nomatch += Integer.parseInt(failIds)) + "");
            Label labelap6 = (Label)this.getControl("labelap6");
            labelap6.setText(ResManager.loadKDString((String)"\u6761\u8bb0\u5f55\u7ee7\u7eed\u901a\u77e5\u8ba4\u9886\u3002", (String)"EnterConfirmPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        this.getView().setEnable(Boolean.valueOf(count_nomatch > 0), new String[]{"btnok", "paybtnok", "noticebtnok"});
    }

    private void ruleORHandOp() {
        HashMap<String, Cloneable> returnData = new HashMap<String, Cloneable>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ArrayList successPkIds = new ArrayList();
        Pair<DynamicObjectCollection, Set<Long>> pair = this.getDetailIdsAndResult();
        if (pair == null) {
            return;
        }
        Set detailIds = (Set)pair.getRight();
        String opflag = (String)formShowParameter.getCustomParam("opflag");
        if ("rule".equals(opflag)) {
            DynamicObjectCollection col = (DynamicObjectCollection)pair.getLeft();
            String operateFlag = "pushandsave";
            String detailEntityName = "bei_transdetail_cas";
            String bizValue = col.stream().filter(v -> !"0".equals(v.getString("record"))).findFirst().get().getString("record");
            if (Arrays.asList(AutoMatchBillTypeEnum.RECBILL.getValue(), AutoMatchBillTypeEnum.TRANSUP.getValue()).contains(bizValue)) {
                detailEntityName = "bei_intelrec";
            } else if (Arrays.asList(AutoMatchBillTypeEnum.PAYBILL.getValue(), AutoMatchBillTypeEnum.AGENTPAYBILL.getValue(), AutoMatchBillTypeEnum.TRANSDOWN.getValue(), AutoMatchBillTypeEnum.TRANSHANDLEBILL.getValue()).contains(bizValue)) {
                detailEntityName = "bei_intelpay";
            }
            OperateOption create = OperateOption.create();
            create.setVariableValue("opnumber", (String)formShowParameter.getCustomParam("thisOpnumber"));
            Boolean errorFlag = Boolean.FALSE;
            ArrayList<Long> succIdList = new ArrayList<Long>();
            OperationResult result = new OperationResult();
            for (Long detailId : detailIds) {
                try {
                    OperateServiceHelper.execOperate((String)operateFlag, (String)detailEntityName, (Object[])new Object[]{detailId}, (OperateOption)create);
                    succIdList.add(detailId);
                    result.setSuccess(true);
                    result.setSuccessPkIds(succIdList);
                }
                catch (Exception ee) {
                    errorFlag = Boolean.TRUE;
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setPkValue((Object)detailId);
                    operateErrorInfo.setMessage(ee.getMessage());
                    result.addErrorInfo(operateErrorInfo);
                }
            }
            if (errorFlag.booleanValue()) {
                result.setBillCount(detailIds.size());
                HashMap<String, Serializable> returnDataMap = new HashMap<String, Serializable>();
                List allErrorInfo = result.getAllErrorInfo();
                ArrayList<String> allErrorInfoList = new ArrayList<String>(allErrorInfo.size());
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    allErrorInfoList.add(operateErrorInfo.getMessage());
                }
                returnDataMap.put("allErrorInfoList", allErrorInfoList);
                returnDataMap.put("totalCount", Integer.valueOf(result.getBillCount()));
                returnDataMap.put("successCount", Integer.valueOf(result.getSuccessPkIds().size()));
                returnData.put("operateResultMap", returnDataMap);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                ReceredWayHelper.setReceredWay((Object[])detailIds.toArray(), (String)ReceredWayEnum.RULE.getValue());
            }
            if (result != null && result.isSuccess()) {
                successPkIds.addAll(result.getSuccessPkIds());
                returnData.put("successPkIds", successPkIds);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        } else if ("hand".equals(opflag)) {
            DynamicObjectCollection col = (DynamicObjectCollection)pair.getLeft();
            String operateFlag = "pushandsave";
            String detailEntityName = "bei_transdetail_cas";
            String bizValue = col.stream().filter(v -> !"0".equals(v.getString("record"))).findFirst().get().getString("record");
            if (AutoMatchBillTypeEnum.RECBILL.getValue().equals(bizValue)) {
                detailEntityName = "bei_intelrec";
            } else if (AutoMatchBillTypeEnum.PAYBILL.getValue().equals(bizValue) || AutoMatchBillTypeEnum.AGENTPAYBILL.getValue().equals(bizValue)) {
                detailEntityName = "bei_intelpay";
            }
            String handparam = (String)formShowParameter.getCustomParam("handparam");
            OperateOption create = OperateOption.create();
            create.setVariableValue("returnDataByOpHand", handparam);
            create.setVariableValue("opnumber", (String)formShowParameter.getCustomParam("thisOpnumber"));
            Boolean errorFlag = Boolean.FALSE;
            ArrayList<Long> succIdList = new ArrayList<Long>();
            OperationResult result = new OperationResult();
            for (Long detailId : detailIds) {
                try {
                    OperateServiceHelper.execOperate((String)operateFlag, (String)detailEntityName, (Object[])new Object[]{detailId}, (OperateOption)create);
                    succIdList.add(detailId);
                    result.setSuccess(true);
                    result.setSuccessPkIds(succIdList);
                }
                catch (Exception ee) {
                    errorFlag = Boolean.TRUE;
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setPkValue((Object)detailId);
                    operateErrorInfo.setMessage(ee.getMessage());
                    result.addErrorInfo(operateErrorInfo);
                }
            }
            if (errorFlag.booleanValue()) {
                result.setBillCount(detailIds.size());
                HashMap<String, Serializable> returnDataMap = new HashMap<String, Serializable>();
                List allErrorInfo = result.getAllErrorInfo();
                ArrayList<String> allErrorInfoList = new ArrayList<String>(allErrorInfo.size());
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    allErrorInfoList.add(operateErrorInfo.getMessage());
                }
                returnDataMap.put("allErrorInfoList", allErrorInfoList);
                returnDataMap.put("totalCount", Integer.valueOf(result.getBillCount()));
                returnDataMap.put("successCount", Integer.valueOf(result.getSuccessPkIds().size()));
                returnData.put("operateResultMap", returnDataMap);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                ReceredWayHelper.setReceredWay((Object[])detailIds.toArray(), (String)ReceredWayEnum.HAND.getValue());
            }
            if (result.isSuccess()) {
                successPkIds.addAll(result.getSuccessPkIds());
                returnData.put("successPkIds", successPkIds);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private Pair<DynamicObjectCollection, Set<Long>> getDetailIdsAndResult() {
        DynamicObject[] resultArr = this.loadAutoCalResult();
        if (CasHelper.isEmpty((DynamicObject[])resultArr) || resultArr.length <= 0) {
            return null;
        }
        HashSet detailIds = new HashSet();
        for (DynamicObject obj : resultArr) {
            String matchStatus = obj.getString("matchstatus");
            if (!MatchStatusEnum.UNSMARTMATCH.getValue().equals(matchStatus)) continue;
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
            Set ids = col.stream().filter(item -> "0".equals(item.getString("record"))).map(item -> item.getLong("billid")).collect(Collectors.toSet());
            detailIds.addAll(ids);
        }
        return Pair.of((Object)resultArr[0].getDynamicObjectCollection("entryentity"), detailIds);
    }

    private DynamicObject[] loadAutoCalResult() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        return BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,matchstatus,entryentity,entryentity.billid,entryentity.record", (QFilter[])new QFilter[]{numberFilter});
    }
}

