/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.opservice.helper.LoadCalResultDataHelper;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.enums.ResultSaveAutoMatchStatus;
import kd.fi.cas.helper.CasHelper;
import org.apache.commons.lang.StringUtils;

public class OperationConfirmPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BillList list = (BillList)this.getControl("billlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("number,rulename");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        list.setFilter(numberFilter);
        list.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listColumns = args.getListColumns();
                FormShowParameter formShowParameter = OperationConfirmPlugin.this.getView().getFormShowParameter();
                String type = (String)formShowParameter.getCustomParam("type");
                for (IListColumn column : listColumns) {
                    String key = column.getListFieldKey();
                    if (("amount".equals(key) || key.startsWith("rectype")) && "pay".equals(type)) {
                        column.setVisible(0);
                        continue;
                    }
                    if (!"payamount".equals(key) && !key.startsWith("paytype") || "pay".equals(type)) continue;
                    column.setVisible(0);
                }
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("num".equals(fieldName)) {
            BillList list = (BillList)this.getControl("billlistap");
            int rowIndex = arg0.getRowIndex();
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cas_autocalresult");
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
            DynamicObject bizDO = (DynamicObject)col.get(rowIndex % 2);
            String str = bizDO.getString("billid");
            String billFlag = LoadCalResultDataHelper.getBizBillType((DynamicObject)bizDO);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(billFlag);
            showParameter.setPkId((Object)str);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        LoadCalResultDataHelper.loadCalResultData((String)thisOpnumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeTitle();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        if (!CasHelper.isEmpty((Object)thisOpnumber)) {
            this.asynDelThisOpData(thisOpnumber);
        }
    }

    public void asynDelThisOpData(Object thisOpnumber) {
        ThreadPools.executeOnceIncludeRequestContext((String)"delThisOpNumber", () -> {
            QFilter thisOpnumberFilter = new QFilter("number", "=", thisOpnumber);
            DeleteServiceHelper.delete((String)"cas_autocalresult", (QFilter[])new QFilter[]{thisOpnumberFilter});
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap<String, DynamicObject[]> returnData = new HashMap<String, DynamicObject[]>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        switch (key) {
            case "btnok": {
                String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
                QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,matchstatus,entryentity,entryentity.billid,entryentity.record", (QFilter[])new QFilter[]{numberFilter});
                if (CasHelper.isEmpty((DynamicObject[])objs) || objs.length <= 0) {
                    return;
                }
                ArrayList<String> detailIds = new ArrayList<String>();
                for (DynamicObject obj : objs) {
                    String opflag;
                    String matchStatus = obj.getString("matchstatus");
                    if (!ResultSaveAutoMatchStatus.UNMATCH.getValue().equals(matchStatus) || !"confirm".equals(opflag = (String)formShowParameter.getCustomParam("opflag"))) continue;
                    DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
                    DynamicObject detail = (DynamicObject)col.get(0);
                    String detailId = detail.getString("billid");
                    detailIds.add(detailId);
                }
                if (!CasHelper.isEmpty(detailIds) && detailIds.size() > 0) {
                    MainEntityType type1 = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
                    DynamicObject[] transbills = BusinessDataServiceHelper.load((Object[])detailIds.toArray(), (DynamicObjectType)type1);
                    this.receredOp("recered", transbills, (DynamicObjectType)type1);
                    returnData.put("successPkIds", transbills);
                }
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection rows;
        BillList list;
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        switch (operateKey = op.getOperateKey()) {
            case "confirmmatch": {
                list = (BillList)this.getControl("billlistap");
                rows = list.getSelectedRows();
                op.getOption().setVariableValue("selectedRowsData", StringUtils.join((Object[])rows.getPrimaryKeyValues(), (String)","));
            }
        }
        switch (operateKey) {
            case "cancelmatch": {
                list = (BillList)this.getControl("billlistap");
                rows = list.getSelectedRows();
                op.getOption().setVariableValue("selectedRowsData", StringUtils.join((Object[])rows.getPrimaryKeyValues(), (String)","));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        BillList list = (BillList)this.getControl("billlistap");
        String key = evt.getOperateKey();
        if ("confirmmatch".equals(key) && evt.getOperationResult().isSuccess()) {
            list.clearSelection();
            list.refresh();
            this.changeTitle();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f!", (String)"OperationConfirmPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if ("cancelmatch".equals(key) && evt.getOperationResult().isSuccess()) {
            list.clearSelection();
            list.refresh();
            this.changeTitle();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5339\u914d\u5df2\u53d6\u6d88\u3002", (String)"OperationConfirmPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void receredOp(String opName, DynamicObject[] transdetails, DynamicObjectType type) {
        if ("recered".equals(opName)) {
            for (DynamicObject transdetail : transdetails) {
                if (!ReceredtypeEnum.Pending.getValue().equals(transdetail.getString("receredtype"))) continue;
                transdetail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
                transdetail.set("receredway", (Object)ReceredWayEnum.CONFIRM.getValue());
                transdetail.set("rulename", null);
            }
        } else if ("cancelrecered".equals(opName)) {
            for (DynamicObject transdetail : transdetails) {
                if (!ReceredtypeEnum.ACCOUNTED.getValue().equals(transdetail.getString("receredtype"))) continue;
                transdetail.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
                transdetail.set("receredway", null);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])transdetails);
        }
    }

    private void changeTitle() {
        Label label1 = (Label)this.getControl("labelap");
        Label label2 = (Label)this.getControl("labelap1");
        Label label3 = (Label)this.getControl("labelap3");
        Label label4 = (Label)this.getControl("labelap5");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,matchstatus", (QFilter[])new QFilter[]{numberFilter});
        if (CasHelper.isEmpty((DynamicObject[])objs) || objs.length <= 0) {
            return;
        }
        int size = objs.length;
        int count_matched = 0;
        int count_nomatch = 0;
        for (DynamicObject obj : objs) {
            String matchStatus = obj.getString("matchstatus");
            if (ResultSaveAutoMatchStatus.AlMATCH.getValue().equals(matchStatus)) {
                ++count_matched;
                continue;
            }
            if (!ResultSaveAutoMatchStatus.UNMATCH.getValue().equals(matchStatus)) continue;
            ++count_nomatch;
        }
        String selectedSize = (String)formShowParameter.getCustomParam("selectedSize");
        String alreadyEntered = (String)formShowParameter.getCustomParam("alreadyEntered");
        String str1 = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684%1$s\u6761\u8bb0\u5f55\u4e2d\uff0c%2$s\u6761\u5df2\u5165\u8d26\u6210\u529f", (String)"OperationConfirmPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "\uff0c", selectedSize, alreadyEntered);
        String str2 = String.format(ResManager.loadKDString((String)"\u53e6\u5916%s\u6761\u53ef\u8fdb\u884c\u81ea\u52a8\u5339\u914d", (String)"OperationConfirmPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "\uff0c", size);
        String str3 = String.format(ResManager.loadKDString((String)"\u8bf7\u8fdb\u884c\u786e\u8ba4\u5339\u914d\uff0c\u5df2\u5339\u914d%s\u6761", (String)"OperationConfirmPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "\uff0c", count_matched);
        String str4 = String.format(ResManager.loadKDString((String)"\u5c06\u5bf9\u5269\u4f59%s\u6761\u8bb0\u5f55\u786e\u8ba4\u5df2\u5165\u8d26\u3002", (String)"OperationConfirmPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), count_nomatch);
        label1.setText(str1);
        label2.setText(str2);
        label3.setText(str3);
        label4.setText(str4);
        Boolean flag = !"0".equals(count_nomatch + "");
        this.getView().setEnable(flag, new String[]{"btnok"});
    }
}

