/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.transferapply;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.common.AbstractCasBillListPlugin;
import kd.fi.cas.helper.CasPluginHelper;

public class TransferApplyList
extends AbstractCasBillListPlugin {
    private boolean isUnTreated = false;
    private static final String[] hideBtnsField = new String[]{"tblnew", "tbldel", "tblsubmit", "tblprint", "tblcheck"};
    private static Log logger = LogFactory.getLog(TransferApplyList.class);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.isUnTreated = CasPluginHelper.isFromControlCenter((IFormView)this.getView());
        if (this.isUnTreated) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if (!"applyorg.name".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (Objects.equals(operateKey, "push")) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            DynamicObject[] selectedBills = BusinessDataServiceHelper.load((Object[])listSelectedData.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_transferapply"));
            ArrayList<String> billStatusList = new ArrayList<String>();
            ArrayList<Boolean> invalidFlagList = new ArrayList<Boolean>();
            for (DynamicObject selectedBill : selectedBills) {
                if (!Objects.equals(selectedBill.getString("billstatus"), BillStatusEnum.AUDIT.getValue())) {
                    billStatusList.add(selectedBill.getString("billstatus"));
                }
                if (!selectedBill.getBoolean("invalidflag")) continue;
                invalidFlagList.add(selectedBill.getBoolean("invalidflag"));
            }
            if (!billStatusList.isEmpty() || !invalidFlagList.isEmpty()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\uff0c\u4e14\u672a\u6807\u8bc6\u4f5c\u5e9f\u7684\u624d\u80fd\u4e0b\u63a8\u4ed8\u6b3e\u3002", (String)"TransferApplyList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.isUnTreated = CasPluginHelper.isFromControlCenter((IFormView)this.getView());
        if (this.isUnTreated) {
            ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
            ListUserOption listUserOption = showParameter.getListUserOption();
            listUserOption.setMergeRow(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.isUnTreated = CasPluginHelper.isFromControlCenter((IFormView)this.getView());
        logger.info("TransferApplyList.afterBindData():" + this.isUnTreated);
        if (this.isUnTreated) {
            this.getView().setVisible(Boolean.valueOf(false), hideBtnsField);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isUnTreated) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List qFilters = e.getQFilters();
            qFilters.add(new QFilter("billstatus", "=", formShowParameter.getCustomParam("billstatus")));
            qFilters.add(new QFilter("paidstatus", "=", formShowParameter.getCustomParam("paidstatus")));
            qFilters.add(new QFilter("applyorg", "in", formShowParameter.getCustomParam("authOrgIds")));
            e.setOrderBy("id desc");
        } else {
            e.setOrderBy("applydate desc,id desc");
        }
    }
}

