/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.transferapply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.enums.TransferTypeEnum;
import kd.fi.cas.formplugin.transferapply.TransferEntryEdit;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.util.EmptyUtil;

public class TransferBatchEdit
extends AbstractBasePlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        EntryGrid transferEntry = (EntryGrid)this.getControl("cas_transferapply_entry");
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "batchfillentry": {
                int[] selectRows = transferEntry.getSelectRows();
                if (selectRows.length <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u6279\u91cf\u64cd\u4f5c\u3002", (String)"TransferBatchEdit_0", (String)"tmc-fca-common", (Object[])new Object[0]));
                    return;
                }
                this.showForm();
                args.setCancel(true);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void showForm() {
        EntryGrid transferEntry = (EntryGrid)this.getControl("cas_transferapply_entry");
        int[] selectRows = transferEntry.getSelectRows();
        FormShowParameter fsp = new FormShowParameter();
        HashMap<String, int[]> selected = new HashMap<String, int[]>(8);
        selected.put("selected", selectRows);
        fsp.setCustomParams(selected);
        fsp.setFormId("transfer_batch_fill");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "transfer_batch_fill");
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        if ("transfer_batch_fill".equals(actionId) && returnData != null && (key = (String)returnData.get("key")) != null && "btnok".equals(key)) {
            String returnBatchFieId = (String)returnData.get("batchfield");
            String whichChoose = (String)returnData.get("whichchoose");
            this.batchFillEntry(whichChoose, returnBatchFieId, returnData.get("fillContent"));
        }
    }

    private void batchFillEntry(Object whichChoose, String returnBatchField, Object returnBatchContent) {
        switch (returnBatchField) {
            case "e_payorg": {
                this.fillByPayOrg(whichChoose, returnBatchContent);
                break;
            }
            case "e_remark": 
            case "e_usage": 
            case "e_expectdate": 
            case "e_paymentchannel": 
            case "e_settlementtype": {
                this.fillByDefault(returnBatchField, whichChoose, returnBatchContent);
                break;
            }
            case "e_payeraccbank": {
                this.fillByPayAcc(whichChoose, returnBatchContent);
                break;
            }
            case "e_payee": {
                this.fillByPayEe(whichChoose, returnBatchContent);
                break;
            }
            case "e_payeeaccbank": {
                this.fillByPayEeAcc(whichChoose, returnBatchContent);
                break;
            }
            default: {
                return;
            }
        }
        this.getView().updateView("cas_transferapply_entry");
    }

    private void fillByPayEeAcc(Object whichChoose, Object returnBatchContent) {
        EntryGrid entry = (EntryGrid)this.getControl("cas_transferapply_entry");
        DynamicObjectCollection chooseEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        if ("selectedrows".equals(whichChoose)) {
            int[] selectRows;
            for (int selectRow : selectRows = entry.getSelectRows()) {
                this.fillByPayEeAccSingle(returnBatchContent, selectRow, chooseEntry);
            }
        } else {
            for (int i = 0; i < chooseEntry.size(); ++i) {
                this.fillByPayEeAccSingle(returnBatchContent, i, chooseEntry);
            }
        }
    }

    private void fillByPayEeAccSingle(Object returnBatchContent, int selectRow, DynamicObjectCollection chooseEntry) {
        DynamicObject bank;
        DynamicObject payAcc = (DynamicObject)returnBatchContent;
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbankid", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbanknum", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_useraccbank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeebank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountname", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountacctname", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbank", returnBatchContent);
        this.getView().setEnable(Boolean.TRUE, selectRow, new String[]{"e_payeeaccbank"});
        this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_accountname"});
        this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_accountacctname"});
        String type = (String)this.getModel().getValue("transfertype");
        if (TransferTypeEnum.SAME_TRANSFER.getValue().equals(type)) {
            this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_payee"});
        }
        if ((bank = payAcc.getDynamicObject("bank")) != null) {
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeebank", (Object)bank);
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeebankname", bank.get("name"));
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountname", payAcc.get("name"));
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountacctname", payAcc.get("acctname"));
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbanknum", payAcc.get("number"));
        }
    }

    private void fillByPayEe(Object whichChoose, Object returnBatchContent) {
        EntryGrid entry = (EntryGrid)this.getControl("cas_transferapply_entry");
        DynamicObjectCollection chooseEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        if ("selectedrows".equals(whichChoose)) {
            int[] selectRows;
            for (int selectRow : selectRows = entry.getSelectRows()) {
                this.fillByPayEeSingle(returnBatchContent, selectRow, chooseEntry);
            }
        } else {
            for (int i = 0; i < chooseEntry.size(); ++i) {
                this.fillByPayEeSingle(returnBatchContent, i, chooseEntry);
            }
        }
    }

    private void fillByPayEeSingle(Object returnBatchContent, int selectRow, DynamicObjectCollection chooseEntry) {
        DynamicObject org = (DynamicObject)returnBatchContent;
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payee", (Object)org);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbankid", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbanknum", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_useraccbank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeebank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountname", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountacctname", null);
        DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
        if (defaultRecAccount != null) {
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbank", (Object)defaultRecAccount);
            this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_accountname"});
            this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_accountacctname"});
            DynamicObject bank = defaultRecAccount.getDynamicObject("bank");
            if (bank != null) {
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeebank", (Object)bank);
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountname", bank.get("name"));
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_accountacctname", defaultRecAccount.get("acctname"));
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeeaccbanknum", defaultRecAccount.get("number"));
            }
        }
    }

    private void fillByPayAcc(Object whichChoose, Object returnBatchContent) {
        EntryGrid entry = (EntryGrid)this.getControl("cas_transferapply_entry");
        DynamicObjectCollection chooseEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        if ("selectedrows".equals(whichChoose)) {
            int[] selectRows;
            for (int selectRow : selectRows = entry.getSelectRows()) {
                this.fillAccSingle(returnBatchContent, selectRow, chooseEntry);
            }
        } else {
            for (int i = 0; i < chooseEntry.size(); ++i) {
                this.fillAccSingle(returnBatchContent, i, chooseEntry);
            }
        }
    }

    private void fillAccSingle(Object returnBatchContent, int selectRow, DynamicObjectCollection chooseEntry) {
        DynamicObject bankAcc;
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeraccbank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeraccbanknum", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_balance", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_payerbank", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_paymentchannel", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_acctshort", null);
        ((DynamicObject)chooseEntry.get(selectRow)).set("e_lastmodifytime", null);
        String type = (String)this.getModel().getValue("transfertype");
        this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_accountname"});
        this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_accountacctname"});
        if (TransferTypeEnum.SAME_TRANSFER.getValue().equals(type)) {
            this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"e_payee"});
        }
        if ((bankAcc = (DynamicObject)returnBatchContent) != null) {
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeraccbank", (Object)bankAcc);
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_payeraccbanknum", (Object)bankAcc.getString("number"));
            DynamicObject bank = (DynamicObject)bankAcc.get("bank");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("paycurrency");
            DynamicObject org = (DynamicObject)this.getModel().getValue("e_payorg", selectRow);
            String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalance", (Object[])new Object[]{balanceType, bankAcc.getLong("id"), currency.getLong("id")});
            BizBalanceModelBean bizBalanceModelBean = (BizBalanceModelBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), BizBalanceModelBean.class);
            BigDecimal balance = bizBalanceModelBean.getAmount();
            if (EmptyUtil.isEmpty((BigDecimal)balance)) {
                balance = BigDecimal.ZERO;
            }
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_balance", (Object)balance);
            Date accountBankLastModifyTime = TransferEntryEdit.getAccountBankLastModifyTime(bankAcc.getLong("id"), currency.getLong("id"));
            ((DynamicObject)chooseEntry.get(selectRow)).set("e_lastmodifytime", (Object)accountBankLastModifyTime);
            if (bank != null) {
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_payerbank", (Object)bank);
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_acctshort", bankAcc.get("name"));
                String defChannel = TransferEntryEdit.getPaymentChannelValue(bankAcc, this.getModel(), selectRow);
                ((DynamicObject)chooseEntry.get(selectRow)).set("e_paymentchannel", (Object)defChannel);
            }
        }
    }

    private void fillByDefault(String fillName, Object whichChoose, Object returnBatchContent) {
        EntryGrid entry = (EntryGrid)this.getControl("cas_transferapply_entry");
        DynamicObjectCollection chooseEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        if ("selectedrows".equals(whichChoose)) {
            int[] selectRows;
            for (int selectRow : selectRows = entry.getSelectRows()) {
                ((DynamicObject)chooseEntry.get(selectRow)).set(fillName, returnBatchContent);
            }
        } else {
            for (DynamicObject dynamicObject : chooseEntry) {
                dynamicObject.set(fillName, returnBatchContent);
            }
        }
    }

    private void fillByPayOrg(Object whichChoose, Object returnBatchContent) {
        EntryGrid entry = (EntryGrid)this.getControl("cas_transferapply_entry");
        DynamicObjectCollection chooseEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        String type = (String)this.getModel().getValue("transfertype");
        if ("selectedrows".equals(whichChoose)) {
            int[] selectRows;
            for (int selectRow : selectRows = entry.getSelectRows()) {
                this.fillOrgSingle(returnBatchContent, selectRow, type, chooseEntry);
            }
        } else {
            for (int i = 0; i < chooseEntry.size(); ++i) {
                this.fillOrgSingle(returnBatchContent, i, type, chooseEntry);
            }
        }
    }

    private void fillOrgSingle(Object returnBatchContent, int i, String type, DynamicObjectCollection chooseEntry) {
        ((DynamicObject)chooseEntry.get(i)).set("e_payorg", returnBatchContent);
        ((DynamicObject)chooseEntry.get(i)).set("e_payeraccbank", null);
        ((DynamicObject)chooseEntry.get(i)).set("e_balance", null);
        ((DynamicObject)chooseEntry.get(i)).set("e_payerbank", null);
        ((DynamicObject)chooseEntry.get(i)).set("e_paymentchannel", null);
        ((DynamicObject)chooseEntry.get(i)).set("e_acctshort", null);
        if (TransferTypeEnum.SAME_TRANSFER.getValue().equals(type)) {
            ((DynamicObject)chooseEntry.get(i)).set("e_payee", returnBatchContent);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_payee"});
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_payeeaccbank"});
            ((DynamicObject)chooseEntry.get(i)).set("e_payeeaccbank", null);
            ((DynamicObject)chooseEntry.get(i)).set("e_payeeaccbankid", null);
            ((DynamicObject)chooseEntry.get(i)).set("e_payeeaccbanknum", null);
            ((DynamicObject)chooseEntry.get(i)).set("e_useraccbank", null);
            ((DynamicObject)chooseEntry.get(i)).set("e_payeebank", null);
            ((DynamicObject)chooseEntry.get(i)).set("e_accountname", null);
            ((DynamicObject)chooseEntry.get(i)).set("e_accountacctname", null);
            DynamicObject org = (DynamicObject)returnBatchContent;
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            if (defaultRecAccount != null) {
                ((DynamicObject)chooseEntry.get(i)).set("e_payeeaccbank", (Object)defaultRecAccount);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_payeeaccbank"});
                DynamicObject bank = defaultRecAccount.getDynamicObject("bank");
                if (bank != null) {
                    ((DynamicObject)chooseEntry.get(i)).set("e_payeebank", (Object)bank);
                    ((DynamicObject)chooseEntry.get(i)).set("e_accountname", bank.get("name"));
                    ((DynamicObject)chooseEntry.get(i)).set("e_accountacctname", defaultRecAccount.get("acctname"));
                    ((DynamicObject)chooseEntry.get(i)).set("e_payeeaccbanknum", defaultRecAccount.get("number"));
                }
            }
        }
    }
}

