/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.transferapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.TransferTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.pojo.ModelRequestBean;
import kd.fi.cas.util.EmptyUtil;

public class TransferEntryEdit
extends BillEditPlugin
implements ClickListener,
HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(TransferEntryEdit.class);
    private static final String SYSTEM_TYPE = "fi-cas-formplugin";
    protected static String[] temp = new String[]{"normal", "freeze", "closing"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeeBankNum = (TextEdit)this.getView().getControl("e_payeeaccbanknum");
        payeeBankNum.addButtonClickListener((ClickListener)this);
        TextEdit payerBankNum = (TextEdit)this.getView().getControl("e_payeraccbanknum");
        payerBankNum.addButtonClickListener((ClickListener)this);
        this.eUserAccBankF7();
        this.payeeF7();
        this.setPayerAccBankListener();
        this.ePayeeAccBankF7();
        this.settlementTypeF7();
        this.payOrgF7();
        EntryGrid entry = (EntryGrid)this.getView().getControl("cas_transferapply_entry");
        entry.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"e_payeebankname"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "e_payeeaccbanknum": {
                BasedataEdit payeeAcctBank = (BasedataEdit)this.getControl("e_payeeaccbank");
                payeeAcctBank.click();
                break;
            }
            case "e_payeraccbanknum": {
                BasedataEdit payerAcctBank = (BasedataEdit)this.getControl("e_payeraccbank");
                payerAcctBank.click();
                break;
            }
            case "e_payeebankname": {
                BasedataEdit payeeBankF7 = (BasedataEdit)this.getControl("e_payeebank");
                payeeBankF7.click();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String opKey = source.getOperateKey();
        if ("refreshbalance".equals(opKey)) {
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("cas_transferapply_entry");
            int[] selectRows = entryEntity.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TransferEntryEdit_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashSet<String> keySet = new HashSet<String>();
            for (int i : selectRows) {
                DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("e_payeraccbank", i);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("paycurrency");
                if (payerAccBank != null && currency != null) {
                    String accountBankId = String.valueOf(payerAccBank.getLong("id"));
                    String currencyId = String.valueOf(currency.getLong("id"));
                    keySet.add(accountBankId.concat(";").concat(currencyId));
                }
                if (!"B".equals(this.getModel().getValue("transfertype"))) continue;
                DynamicObject payeeAccBank = (DynamicObject)this.getModel().getValue("e_payeraccbank", i);
                DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
                if (payeeAccBank == null || payeeCurrency == null) continue;
                String accountBankId = String.valueOf(payeeAccBank.getLong("id"));
                String currencyId = String.valueOf(payeeCurrency.getLong("id"));
                keySet.add(accountBankId.concat(";").concat(currencyId));
            }
            if (keySet.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d26\u6237\u8fc7\u591a\u4f1a\u5bfc\u81f4\u66f4\u65b0\u65f6\u95f4\u8f83\u957f\uff0c\u56e0\u6b64\u7cfb\u7edf\u63a7\u5236\u6bcf\u6b21\u66f4\u65b0\u8d26\u6237\u6570\u91cf\uff08\u91cd\u590d\u8d26\u6237\u7b971\u4e2a\uff0c\u540c\u4e00\u8d26\u6237\u4e0d\u540c\u5e01\u79cd\u7b97\u591a\u4e2a\uff09\u4e0d\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u9009\u62e9\u4e0d\u8d85\u8fc7100\u4e2a\u8d26\u6237\u8fdb\u884c\u624b\u52a8\u5237\u65b0\u3002", (String)"TransferEntryEdit_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("refreshbalance".equals(opKey)) {
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("cas_transferapply_entry");
            int[] selectRows = entryEntity.getSelectRows();
            this.updateBalance(selectRows, true);
            this.updateBalance(selectRows, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (fieldKey) {
            case "e_payorg": {
                this.getModel().setValue("e_payeraccbanknum", null, rowIndex);
                this.getModel().setValue("e_balance", (Object)0, rowIndex);
                this.getModel().setValue("e_lastmodifytime", null, rowIndex);
                this.getModel().setValue("e_payerbank", null, rowIndex);
                this.getModel().setValue("e_paymentchannel", null, rowIndex);
                this.getModel().setValue("e_acctshort", null, rowIndex);
                String type = (String)this.getModel().getValue("transfertype");
                if (!TransferTypeEnum.SAME_TRANSFER.getValue().equals(type)) break;
                this.getModel().setValue("e_payee", newValue, rowIndex);
                break;
            }
            case "e_payeraccbank": {
                this.fillPayerAccountBank(rowIndex, null);
                DynamicObject settlementType = (DynamicObject)this.getModel().getValue("e_settlementtype", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)settlementType) || EmptyUtil.isEmpty((Object)newValue)) {
                    this.getModel().setValue("e_payeraccbank", null, rowIndex);
                    this.getModel().setValue("e_balance", (Object)0, rowIndex);
                    this.getModel().setValue("e_lastmodifytime", null, rowIndex);
                    this.getModel().setValue("e_payerbank", null, rowIndex);
                    this.getModel().setValue("e_paymentchannel", null, rowIndex);
                    this.getModel().setValue("e_acctshort", null, rowIndex);
                    break;
                }
                DynamicObject ePayerAccountBank = (DynamicObject)newValue;
                DynamicObject bank = (DynamicObject)ePayerAccountBank.get("bank");
                this.setPaymentChannelValue(ePayerAccountBank, model, rowIndex);
                this.getModel().setValue("e_payerbank", (Object)bank, rowIndex);
                this.getModel().setValue("e_acctshort", ePayerAccountBank.get("name"), rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"e_paymentchannel"});
                this.updateBalance(new int[]{rowIndex}, true);
                break;
            }
            case "e_payeebank": {
                DynamicObject payeeBank = (DynamicObject)model.getValue("e_payeebank", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)payeeBank)) {
                    this.getModel().setValue("e_recbanknumber", null, rowIndex);
                    this.getModel().setValue("e_recswiftcode", null, rowIndex);
                    this.getModel().setValue("e_recroutingnum", null, rowIndex);
                    this.getModel().setValue("e_recothercode", null, rowIndex);
                    this.getModel().beginInit();
                    this.getModel().setValue("e_payeebankname", null, rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("e_payeebankname", rowIndex);
                } else {
                    this.getModel().setValue("e_recbanknumber", payeeBank.get("union_number"), rowIndex);
                    this.getModel().setValue("e_recswiftcode", payeeBank.get("swift_code"), rowIndex);
                    this.getModel().setValue("e_recroutingnum", payeeBank.get("routingnum"), rowIndex);
                    this.getModel().setValue("e_recothercode", payeeBank.get("other_code"), rowIndex);
                    this.getModel().beginInit();
                    this.getModel().setValue("e_payeebankname", payeeBank.get("name"), rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("e_payeebankname", rowIndex);
                }
                this.updateBalance(new int[]{rowIndex}, false);
                break;
            }
            case "e_paymentchannel": {
                DynamicObject payerAccBank = (DynamicObject)model.getValue("e_payeraccbank", rowIndex);
                DynamicObject settlementType = (DynamicObject)model.getValue("e_settlementtype", rowIndex);
                String result = TransferEntryEdit.checkPaymentChannel(payerAccBank, settlementType, newValue);
                if (result == null) break;
                model.setValue("e_paymentchannel", oldValue, rowIndex);
                this.getView().showErrorNotification(result);
                break;
            }
            case "entrypaycurrency": {
                this.updateBalance(new int[]{rowIndex}, true);
                break;
            }
            case "payeecurrency": {
                this.updateBalance(null, false);
                break;
            }
            case "e_settlementtype": {
                DynamicObject payerAcctBank = (DynamicObject)model.getValue("e_payeraccbank", rowIndex);
                this.setPaymentChannelValue(payerAcctBank, model, rowIndex);
                this.getModel().setValue("e_payeraccbanknum", null, rowIndex);
                this.getModel().setValue("e_payeeaccbanknum", null, rowIndex);
                break;
            }
            case "e_payeeaccbank": {
                this.fillAccountName(rowIndex, null);
                this.updateBalance(new int[]{rowIndex}, false);
                break;
            }
            case "e_useraccbank": {
                this.setValue("e_payeeaccbank", null, rowIndex);
                this.setValue("e_payeeaccbankid", null, rowIndex);
                this.setValue("e_payeeaccbanknum", null, rowIndex);
                this.setValue("e_payeebank", null, rowIndex);
                DynamicObject erPayee = (DynamicObject)changeData[0].getNewValue();
                this.setValue("e_payeeaccbanknum", erPayee.getString("payeraccount"), rowIndex);
                this.setValue("e_payeeaccbankid", erPayee.getPkValue(), rowIndex);
                this.setValue("e_payeebank", erPayee.getDynamicObject("payerbank"), rowIndex);
                this.fillAccountName(rowIndex, null);
                break;
            }
            case "e_payeraccbanknum": {
                this.fillPayerAccountBank(null, rowIndex);
                break;
            }
            case "e_payeeaccbanknum": {
                this.fillAccountNameByBankAccount(null, rowIndex);
                break;
            }
            case "e_payeebankname": {
                this.getModel().beginInit();
                if (StringUtils.isNotBlank((Object)newValue)) {
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                    DynamicObject bank = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", newValue), enableFilter});
                    this.setValue("e_payeebank", bank);
                } else {
                    this.setValue("e_payeebankname", null);
                }
                this.getModel().endInit();
                this.getView().updateView("e_payeebank", rowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("e_payeeaccbank".equals(actionId)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 != null) {
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("cas_transferapply_entry"), returnData2);
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData2;
                Object entryKey = rowInfo.getPrimaryKeyValues()[0];
                this.setValue("e_payeeaccbank", entryKey);
            }
        } else if ("e_useraccbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.fillAccountName(this.getModel().getEntryCurrentRowIndex("cas_transferapply_entry"), returnData);
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.setValue("e_useraccbank", entryKey);
        }
    }

    private void eUserAccBankF7() {
        BasedataEdit eUserAccBankF7 = (BasedataEdit)this.getControl("e_useraccbank");
        eUserAccBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject ePayee = this.getDynamicObject("e_payee");
            if (ePayee != null) {
                QFilter qFilter = new QFilter("payer", "=", ePayee.getPkValue());
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
                if (currency != null) {
                    qFilter.and(new QFilter("currency.id", "is null", null).or(new QFilter("currency.id", "=", (Object)0).or(new QFilter("currency.id", "=", currency.getPkValue()))));
                }
                showPara.getListFilterParameter().setFilter(qFilter);
                List qFilters = showPara.getListFilterParameter().getQFilters();
                qFilters.removeIf(q -> q.toString().contains("t_er_Payee_U"));
                showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_useraccbank"));
            }
        });
    }

    private void payeeF7() {
        BasedataEdit payee = (BasedataEdit)this.getControl("e_payee");
        payee.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (AsstActTypeEnum.COMPANY.getValue().equals(this.getValue("e_payeetype"))) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("fisbankroll", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void setPayerAccBankListener() {
        BasedataEdit payerAccBankBillEdit = (BasedataEdit)this.getControl("e_payeraccbank");
        IDataModel model = this.getModel();
        payerAccBankBillEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject payCurrency = (DynamicObject)model.getValue("paycurrency");
            int index = model.getEntryCurrentRowIndex("cas_transferapply_entry");
            DynamicObject payOrg = (DynamicObject)model.getValue("e_payorg", index);
            DynamicObject settleMentType = (DynamicObject)model.getValue("e_settlementtype", index);
            if (EmptyUtil.isEmpty((DynamicObject)payOrg) || EmptyUtil.isEmpty((DynamicObject)payCurrency) || EmptyUtil.isEmpty((DynamicObject)settleMentType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u4ed8\u6b3e\u5e01\u79cd\u3001\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"TransferEntryEdit_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean isView = PermissionHelper.checkCurrentUserPermission((String)this.getView().getFormShowParameter().getAppId(), (long)payOrg.getLong("id"), (String)"am_accountbank", (String)"47150e89000000ac");
            if (!isView) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u94f6\u884c\u8d26\u6237\u67e5\u8be2\u6743\u9650\u3002", (String)"TransferEntryEdit_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), payOrg.getString("name")));
                evt.setCancel(true);
                return;
            }
            QFilter usableAccountFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)payOrg.getPkValue()));
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "not in", (Object)new String[]{BankAcctStatusEnum.CLOSED.getValue(), BankAcctStatusEnum.FREEZE.getValue()});
            DynamicObject currency = (DynamicObject)this.getModel().getValue("paycurrency");
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            qFilter.and(VisibleVirtualAcctHelper.virtualAcctQfNew());
            parameter.getListFilterParameter().getQFilters().add(usableAccountFilter);
            parameter.getListFilterParameter().getQFilters().add(qFilter);
            DynamicObject settlementType = (DynamicObject)model.getValue("e_settlementtype", index);
            if (settlementType != null && SettleMentTypeEnum.DCEP.getValue().equals(settleMentType.getString("settlementtype"))) {
                parameter.getListFilterParameter().getQFilters().add(new QFilter("iselecpayment", "=", (Object)Character.valueOf('1')));
            } else {
                parameter.getListFilterParameter().getQFilters().add(new QFilter("iselecpayment", "=", (Object)Character.valueOf('0')));
            }
        });
    }

    private void ePayeeAccBankF7() {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("e_payeeaccbank");
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int index = this.getModel().getEntryCurrentRowIndex("cas_transferapply_entry");
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "<>", (Object)BankAcctStatusEnum.CLOSED.getValue());
            DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
            if (currency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"TransferApplyEdit_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            showPara.getListFilterParameter().setFilter(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            DynamicObject payee = (DynamicObject)this.getValue("e_payee", index);
            if (payee != null) {
                boolean isView = PermissionHelper.checkCurrentUserPermission((String)this.getView().getFormShowParameter().getAppId(), (long)payee.getLong("id"), (String)"am_accountbank", (String)"47150e89000000ac");
                if (!isView) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u94f6\u884c\u8d26\u6237\u67e5\u8be2\u6743\u9650\u3002", (String)"TransferEntryEdit_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), payee.getString("name")));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"TransferApplyEdit_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter useOrgFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)payee.getPkValue()));
            qFilter.and(useOrgFilter);
            qFilter.and(VisibleVirtualAcctHelper.virtualAcctQfNew());
            LOGGER.info("\u6536\u6b3e\u8d26\u53f7\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a{}", (Object)qFilter);
            showPara.getListFilterParameter().setFilter(qFilter);
            showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_payeeaccbank"));
            DynamicObject settlementType = (DynamicObject)this.getModel().getValue("e_settlementtype", index);
            if (settlementType != null && SettleMentTypeEnum.DCEP.getValue().equals(settlementType.getString("settlementtype"))) {
                showPara.getListFilterParameter().getQFilters().add(new QFilter("iselecpayment", "=", (Object)Character.valueOf('1')));
            } else {
                showPara.getListFilterParameter().getQFilters().add(new QFilter("iselecpayment", "=", (Object)Character.valueOf('0')));
            }
        });
    }

    private void settlementTypeF7() {
        BasedataEdit settlementTypeEdit = (BasedataEdit)this.getControl("e_settlementtype");
        settlementTypeEdit.addBeforeF7SelectListener(evt -> {
            Optional<DynamicObject> optional;
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("settlementtype", "not in", Arrays.asList(SettleMentTypeEnum.MONEY.getValue(), SettleMentTypeEnum.VIRTUAL.getValue()));
            parameter.getListFilterParameter().getQFilters().add(qFilter);
            DynamicObjectCollection entry = this.getModel().getEntryEntity("cas_transferapply_entry");
            if (entry.size() - 1 >= evt.getRow()) {
                entry.remove(evt.getRow());
            }
            if ((optional = entry.stream().filter(e -> e.getDynamicObject("e_settlementtype") != null && SettleMentTypeEnum.DCEP.getValue().equals(e.getDynamicObject("e_settlementtype").getString("settlementtype"))).findFirst()).isPresent()) {
                parameter.getListFilterParameter().getQFilters().add(new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.DCEP.getValue()));
            }
        });
    }

    private void payOrgF7() {
        BasedataEdit payOrgF7 = (BasedataEdit)this.getControl("e_payorg");
        payOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = ExtendConfigHelper.isInitOnlySet() ? new QFilter("standardcurrency", "is not null", null) : new QFilter("isfinishinit", "=", (Object)"1");
            DynamicObject[] finishInitArrays = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id, org", (QFilter[])filter.toArray());
            List finishInitOrgIds = Arrays.stream(finishInitArrays).filter(f -> f.getDynamicObject("org") != null).map(f -> f.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
            showPara.getListFilterParameter().setFilter(new QFilter("id", "in", finishInitOrgIds));
        });
    }

    public static Date getAccountBankLastModifyTime(Long acctBankID, Long currencyID) {
        DynamicObject acctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)acctBankID, (String)"bd_accountbanks");
        if (acctBank != null && acctBank.getBoolean("issetbankinterface")) {
            QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankID), new QFilter("currency", "=", (Object)currencyID)};
            DynamicObjectCollection balanceInquires = QueryServiceHelper.query((String)"getLastestBalanceInquire", (String)"bei_bankbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"modifytime desc", (int)1);
            if (balanceInquires.isEmpty()) {
                return null;
            }
            return ((DynamicObject)balanceInquires.get(0)).getDate("modifytime");
        }
        return new Date();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = evt.getFieldName();
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_paybillno")) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("cas_transferapply_entry", rowIndex);
            String eBillNo = entryRowEntity.getString("e_paybillno");
            QFilter billNo = new QFilter("billno", "=", (Object)eBillNo);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{billNo});
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cas_paybill");
            showParameter.setPkId(ids[0].getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setPaymentChannelValue(DynamicObject payerAcctBank, IDataModel model, int rowIndex) {
        if (payerAcctBank != null) {
            String defChannel = TransferEntryEdit.getPaymentChannelValue(payerAcctBank, model, rowIndex);
            this.getModel().setValue("e_paymentchannel", (Object)defChannel, rowIndex);
        }
    }

    public static String getPaymentChannelValue(DynamicObject payerAcctBank, IDataModel model, int rowIndex) {
        DynamicObject settlementType = (DynamicObject)model.getValue("e_settlementtype", rowIndex);
        String defaultPaymentChannel = null;
        if (settlementType != null) {
            defaultPaymentChannel = settlementType.getString("defaultpaymentchannel");
        }
        if (PaymentChannelEnum.ONLINEBANK.getValue().equals(defaultPaymentChannel) && !payerAcctBank.getBoolean("isopenbank")) {
            defaultPaymentChannel = null;
        }
        if (PaymentChannelEnum.BEI.getValue().equals(defaultPaymentChannel) && !payerAcctBank.getBoolean("issetbankinterface")) {
            defaultPaymentChannel = null;
        }
        return defaultPaymentChannel;
    }

    private void fillAccountName(int rowIndex, Object returnData) {
        if (returnData != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.fillAccountNameByBankAccount(entryKey, rowIndex);
            this.setValue("e_payeeaccbank", entryKey, rowIndex);
        } else {
            DynamicObject payeeAccBank = (DynamicObject)this.getValue("e_payeeaccbank", rowIndex);
            if (payeeAccBank != null) {
                this.fillAccountNameByBankAccount(payeeAccBank.getPkValue(), rowIndex);
            } else {
                this.fillAccountNameByBankAccount(null, rowIndex);
            }
        }
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountname"});
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_accountacctname"});
    }

    private void fillAccountNameByBankAccount(Object entryKey, int rowIndex) {
        DynamicObject accountBank;
        if (entryKey != null) {
            accountBank = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"bd_accountbanks");
        } else {
            String number = (String)this.getValue("e_payeeaccbanknum", rowIndex);
            DynamicObject payee = (DynamicObject)this.getValue("e_payee", rowIndex);
            if (payee == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"TransferApplyEdit_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.setValue("e_payeeaccbanknum", null, rowIndex);
                return;
            }
            QFilter qFilter = new QFilter("acctstatus", "<>", (Object)BankAcctStatusEnum.CLOSED.getValue());
            DynamicObject currency = (DynamicObject)this.getModel().getValue("payeecurrency");
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            QFilter useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)payee.getLong("id"));
            accountBank = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,name,acctname,bankaccountnumber,bank,iselecpayment", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), useOrgFilter, qFilter});
        }
        if (accountBank == null) {
            this.setValue("e_payeeaccbank", null, rowIndex);
            this.setValue("e_accountname", null, rowIndex);
            this.setValue("e_accountacctname", null, rowIndex);
            this.setValue("e_payeebank", null, rowIndex);
            this.setValue("e_institutioncode", null, rowIndex);
            this.setValue("e_payeeaccbanknum", null, rowIndex);
        } else {
            this.setValue("e_payeeaccbanknum", accountBank.get("bankaccountnumber"), rowIndex);
            this.setValue("e_payeeaccbank", accountBank, rowIndex);
            this.setValue("e_accountname", accountBank.get("name"), rowIndex);
            this.setValue("e_accountacctname", accountBank.get("acctname"), rowIndex);
            this.setValue("e_payeebank", accountBank.get("bank"), rowIndex);
            if (accountBank.getBoolean("iselecpayment")) {
                String institutionCode = DcepConverHelper.getInstitUtionCode((DynamicObject)accountBank);
                this.setValue("e_institutioncode", institutionCode);
            } else {
                this.setValue("e_institutioncode", null, rowIndex);
            }
        }
    }

    private void fillPayerAccountBank(int rowIndex, Object returnData) {
        Object entryKey = null;
        if (returnData != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.setValue("e_payeraccbank", entryKey, rowIndex);
        } else {
            DynamicObject payerAccBank = (DynamicObject)this.getValue("e_payeraccbank", rowIndex);
            if (payerAccBank != null) {
                entryKey = payerAccBank.getPkValue();
            }
        }
        this.fillPayerAccountBank(entryKey, rowIndex);
    }

    private void fillPayerAccountBank(Object entryKey, int rowIndex) {
        if (entryKey != null) {
            DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"bd_accountbanks", (String)"bankaccountnumber");
            this.setValue("e_payeraccbanknum", accountBank.get("bankaccountnumber"), rowIndex);
        } else {
            String number = (String)this.getValue("e_payeraccbanknum", rowIndex);
            DynamicObject payCurrency = (DynamicObject)this.getValue("paycurrency");
            DynamicObject payOrg = (DynamicObject)this.getValue("e_payorg", rowIndex);
            DynamicObject settlementType = (DynamicObject)this.getValue("e_settlementtype", rowIndex);
            if (EmptyUtil.isEmpty((DynamicObject)payOrg) || EmptyUtil.isEmpty((DynamicObject)payCurrency) || EmptyUtil.isEmpty((DynamicObject)settlementType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u4ed8\u6b3e\u5e01\u79cd\u3001\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"TransferEntryEdit_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.setValue("e_payeraccbanknum", null, rowIndex);
                return;
            }
            QFilter qFilter = new QFilter("acctstatus", "not in", (Object)new String[]{BankAcctStatusEnum.CLOSED.getValue(), BankAcctStatusEnum.FREEZE.getValue()});
            DynamicObject currency = (DynamicObject)this.getModel().getValue("paycurrency");
            if (currency != null) {
                qFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            qFilter.and(VisibleVirtualAcctHelper.virtualAcctQfNew());
            QFilter useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)payOrg.getLong("id"));
            DynamicObject[] accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,name,acctname,bank", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), useOrgFilter, qFilter});
            if (accountBank == null || accountBank.length == 0) {
                this.setValue("e_payeraccbank", null, rowIndex);
            } else {
                this.setValue("e_payeraccbank", accountBank[0], rowIndex);
            }
        }
    }

    public static String checkPaymentChannel(DynamicObject payerAccBank, DynamicObject settlementType, Object newValue) {
        if (payerAccBank != null) {
            Set paymentChannels;
            String paymentChannelRange;
            if (PaymentChannelEnum.ONLINEBANK.getValue().equals(newValue) && !payerAccBank.getBoolean("isopenbank")) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"TransferEntryEdit_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            if (PaymentChannelEnum.BEI.getValue().equals(newValue) && !payerAccBank.getBoolean("issetbankinterface")) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"TransferEntryEdit_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            if (settlementType != null && StringUtils.isNotBlank((Object)newValue) && StringUtils.isNotEmpty((CharSequence)(paymentChannelRange = settlementType.getString("paymentchannel"))) && !(paymentChannels = Arrays.stream(paymentChannelRange.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet())).contains(newValue)) {
                return ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u5fc5\u987b\u662f\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u8303\u56f4\u5185\u3002", (String)"TransferEntryEdit_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void updateBalance(int[] selectRows, boolean isPay) {
        HashSet<String> keySet = new HashSet<String>();
        if (selectRows == null) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("cas_transferapply_entry");
            selectRows = new int[dynamicObjectCollection.size()];
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                selectRows[i] = i;
            }
        }
        if (selectRows.length == 0) {
            return;
        }
        for (int i : selectRows) {
            DynamicObject account = null;
            DynamicObject currency = null;
            if (isPay) {
                account = (DynamicObject)this.getModel().getValue("e_payeraccbank", i);
                currency = (DynamicObject)this.getModel().getValue("entrypaycurrency", i);
            } else if ("B".equals(this.getModel().getValue("transfertype"))) {
                account = (DynamicObject)this.getModel().getValue("e_payeeaccbank", i);
                currency = (DynamicObject)this.getModel().getValue("payeecurrency");
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("e_payorg", i);
            if (account == null || currency == null || org == null) continue;
            String payerAccBankId = String.valueOf(account.getLong("id"));
            String currencyId = String.valueOf(currency.getLong("id"));
            String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
            keySet.add(payerAccBankId.concat(";").concat(currencyId).concat(";").concat(balanceType));
        }
        ArrayList<BizBalanceModelBean> arrayList = new ArrayList<BizBalanceModelBean>(keySet.size());
        for (String key : keySet) {
            BizBalanceModelBean bizBean = new BizBalanceModelBean();
            String[] keys = key.split(";");
            bizBean.setAccountId(Long.valueOf(Long.parseLong(keys[0])));
            bizBean.setCurrencyId(Long.valueOf(Long.parseLong(keys[1])));
            if (keys.length == 3) {
                bizBean.setBalanceType(keys[2]);
            }
            arrayList.add(bizBean);
        }
        Map<String, BizBalanceModelBean> bizBalanceModelBeanMap = new HashMap<String, BizBalanceModelBean>(16);
        if (!arrayList.isEmpty()) {
            ModelRequestBean modelRequestBean = new ModelRequestBean();
            modelRequestBean.setBizBeans(arrayList);
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalanceBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)modelRequestBean)});
            modelRequestBean = (ModelRequestBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), ModelRequestBean.class);
            if (modelRequestBean != null && modelRequestBean.getBizBeans() != null) {
                bizBalanceModelBeanMap = modelRequestBean.getBizBeans().stream().filter(d -> d != null && EmptyUtil.isNoEmpty((Long)d.getAccountId()) && EmptyUtil.isNoEmpty((Long)d.getCurrencyId())).collect(Collectors.toMap(e -> e.getAccountId() + ";" + e.getCurrencyId(), e -> e, (v1, v2) -> v2));
            }
        }
        for (int i : selectRows) {
            this.updateBalance(i, bizBalanceModelBeanMap, isPay);
        }
    }

    private void updateBalance(int i, Map<String, BizBalanceModelBean> bizBalanceModelBeanMap, boolean isPay) {
        BizBalanceModelBean bizBalanceModelBean;
        DynamicObject currency;
        DynamicObject account;
        if (isPay) {
            account = (DynamicObject)this.getModel().getValue("e_payeraccbank", i);
            currency = (DynamicObject)this.getModel().getValue("entrypaycurrency", i);
        } else {
            account = (DynamicObject)this.getModel().getValue("e_payeeaccbank", i);
            currency = (DynamicObject)this.getModel().getValue("payeecurrency");
        }
        BigDecimal balance = BigDecimal.ZERO;
        Date accountBankLastModifyTime = null;
        if (account != null && currency != null && bizBalanceModelBeanMap != null && (bizBalanceModelBean = bizBalanceModelBeanMap.get(account.getLong("id") + ";" + currency.getLong("id"))) != null) {
            balance = bizBalanceModelBean.getAmount();
            accountBankLastModifyTime = bizBalanceModelBean.getLastTime();
        }
        if (isPay) {
            this.getModel().setValue("e_balance", (Object)balance, i);
        } else {
            this.getModel().setValue("e_rbalance", (Object)balance, i);
        }
        this.getModel().setValue("e_lastmodifytime", accountBankLastModifyTime, i);
    }
}

