/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.workbench.WorkbenchList;
import kd.fi.cas.helper.CasHelper;

public class PassivePayWorkbenchPlugin
extends WorkbenchList {
    @Override
    public String entryFormId() {
        return "cas_intelpay";
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setEntityId("bei_transdetail_cas");
        filterContainer.setTitle(new LocaleString(ResManager.loadKDString((String)"\u88ab\u52a8\u4ed8\u6b3e\u5165\u8d26", (String)"PassivePayWorkbenchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.tabChange();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (!"recedbillnumber".equals(fieldName)) {
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        Object focusRowPkId = list.getFocusRowPkId();
        DynamicObject detail = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"bei_transdetail_cas", (String)"id,recedbillnumber");
        String payBillNo = detail.getString("recedbillnumber");
        if (StringUtils.isEmpty((CharSequence)payBillNo)) {
            return;
        }
        QFilter filter = new QFilter("billno", "=", (Object)payBillNo);
        DynamicObject paybillDo = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
        if (CasHelper.isEmpty((Object)paybillDo)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String billstatus = paybillDo.getString("billstatus");
        if (!BillStatusEnum.SAVE.getValue().equals(billstatus)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.setFormId("cas_paybill");
        showParameter.setPkId(paybillDo.getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "recordbotn": {
                this.refreshList();
            }
        }
    }

    @Override
    protected void viewCard() {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
    }
}

