/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.AccSysHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class PayBizInfoPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(PayBizInfoPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sonaAcc = (BasedataEdit)this.getControl("sonacct");
        sonaAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List acct = AccSysHelper.getAllAcctGroupSonAcctIds();
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("id", "in", (Object)acct));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit fundflowitem = (BasedataEdit)this.getControl("fundflowitem");
        fundflowitem.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("isleaf", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String call = (String)this.getView().getFormShowParameter().getCustomParam("call");
        if (call == null) {
            return;
        }
        if ("cas_paybizinfomerge".equals(call)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"handlebill"});
        }
        ((BasedataEdit)this.getControl("paymenttype")).setMustInput(true);
        ((ComboEdit)this.getControl("receivertype")).setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        String propertyName = e.getProperty().getName();
        if (CasHelper.isNotEmpty((Object)newValue) && newValue.equals(oldValue)) {
            return;
        }
        if ("paymenttype".equals(propertyName)) {
            if (CasHelper.isEmpty((Object)newValue)) {
                this.getModel().setValue("receivertype", (Object)"");
                return;
            }
            this.setreceivertypeVisible();
        }
        if ("receivertype".equals(propertyName)) {
            this.getModel().setValue("e_recerbasetype", newValue);
            this.setOtherVisable();
        }
        if ("sonacct".equals(propertyName)) {
            this.setGroup(newValue);
        }
        if ("handlebill".equals(propertyName)) {
            if ("downbill".equals(newValue)) {
                ((BasedataEdit)this.getControl("paymenttype")).setMustInput(false);
                ((ComboEdit)this.getControl("receivertype")).setMustInput(false);
                this.setGroup(null);
            } else {
                ((BasedataEdit)this.getControl("paymenttype")).setMustInput(true);
                ((ComboEdit)this.getControl("receivertype")).setMustInput(true);
            }
        }
    }

    private void setGroup(Object newValue) {
        DynamicObject oppAccount;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String oppBankNumber = customParams.getOrDefault("oppBankNumber", null);
        Object accountBank = customParams.getOrDefault("accountBankId", null);
        Long accountBankId = EmptyUtil.isNoEmpty(accountBank) ? Long.parseLong(accountBank.toString()) : 0L;
        DynamicObject[] acctGroup = null;
        if (newValue != null) {
            if (EmptyUtil.isNoEmpty((Long)accountBankId)) {
                DynamicObject son = (DynamicObject)newValue;
                acctGroup = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)son.getLong("id")), new QFilter("accountbank", "=", (Object)accountBankId)});
            }
        } else if (EmptyUtil.isNoEmpty((Long)accountBankId) && EmptyUtil.isNoEmpty((String)oppBankNumber) && EmptyUtil.isNoEmpty((DynamicObject)(oppAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)oppBankNumber)})))) {
            acctGroup = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)oppAccount.getLong("id")), new QFilter("accountbank", "=", (Object)accountBankId)});
        }
        if (acctGroup != null && acctGroup.length > 0) {
            this.getModel().setValue("group", (Object)acctGroup[0].getLong("id"));
        } else {
            this.getModel().setValue("group", null);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOtherVisable();
    }

    private void setOtherVisable() {
        Object recertype = this.getModel().getValue("receivertype");
        if (CasHelper.isNotEmpty((Object)recertype) && "other".equals(recertype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_recer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_recerid"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_recerid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_recer"});
        }
    }

    private void setreceivertypeVisible() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit receiverTypeField = (ComboEdit)this.getControl("receivertype");
        ComboItem customerCI = new ComboItem();
        customerCI.setCaption(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()));
        customerCI.setValue(AsstActTypeEnum.CUSTOMER.getValue());
        ComboItem supplierCI = new ComboItem();
        supplierCI.setCaption(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()));
        supplierCI.setValue(AsstActTypeEnum.SUPPLIER.getValue());
        ComboItem employeeCI = new ComboItem();
        employeeCI.setCaption(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()));
        employeeCI.setValue(AsstActTypeEnum.EMPLOYEE.getValue());
        ComboItem companyCI = new ComboItem();
        companyCI.setCaption(new LocaleString(AsstActTypeEnum.COMPANY.getName()));
        companyCI.setValue(AsstActTypeEnum.COMPANY.getValue());
        ComboItem otherCI = new ComboItem();
        otherCI.setCaption(new LocaleString(AsstActTypeEnum.OTHER.getName()));
        otherCI.setValue(AsstActTypeEnum.OTHER.getValue());
        DynamicObject paymenttype = this.getModel().getDataEntity().getDynamicObject("paymenttype");
        if (!CasHelper.isEmpty((Object)paymenttype)) {
            boolean ispartpayment = paymenttype.getBoolean("ispartpayment");
            DynamicObject fundFlowItem = paymenttype.getDynamicObject("fundflowitem");
            this.getModel().setValue("fundflowitem", (Object)fundFlowItem);
            comboItems.add(customerCI);
            comboItems.add(supplierCI);
            comboItems.add(employeeCI);
            comboItems.add(companyCI);
            comboItems.add(otherCI);
            receiverTypeField.setComboItems(comboItems);
            if (ispartpayment) {
                this.getModel().setValue("receivertype", (Object)AsstActTypeEnum.SUPPLIER.getValue());
            } else {
                this.getModel().setValue("receivertype", (Object)AsstActTypeEnum.OTHER.getValue());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        switch (operateKey) {
            case "btnok": {
                String handleBill = dataEntity.getString("handlebill");
                if (!EmptyUtil.isNoEmpty((String)handleBill) || !StringUtils.equals((CharSequence)"downbill", (CharSequence)handleBill) || !customParams.getOrDefault("multiAccountBankId", false).booleanValue() && !customParams.getOrDefault("multiOppBankNumber", false).booleanValue()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u591a\u6761\u6570\u636e\u751f\u6210\u4e0a\u5212\u5904\u7406\u5355\u6216\u4e0b\u62e8\u5904\u7406\u5355\u65f6\uff0c\u9700\u4fdd\u8bc1\u4ea4\u6613\u660e\u7ec6\u94f6\u884c\u8d26\u53f7\u4e00\u81f4\u4e14\u5bf9\u65b9\u8d26\u53f7\u4fe1\u606f\u4e00\u81f4\u3002", (String)"PayBizInfoPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            DynamicObject group;
            DynamicObject sonAcct;
            DynamicObject fundflowitem;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propName = property.getName();
                Object value = this.getModel().getValue(propName);
                if (value instanceof DynamicObject) {
                    returnData.put(propName, ((DynamicObject)value).getPkValue());
                    continue;
                }
                if (value instanceof Date) {
                    returnData.put(propName, DateUtils.formatString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                returnData.put(propName, value);
            }
            DynamicObject paymenttype = dataEntity.getDynamicObject("paymenttype");
            if (!CasHelper.isEmpty((Object)paymenttype)) {
                String paymenttypeSeri = SerializeHelper.serializeDynamicObj((Object)paymenttype);
                returnData.put("e_paymenttype", paymenttypeSeri);
            }
            if (!CasHelper.isEmpty((Object)(fundflowitem = dataEntity.getDynamicObject("fundflowitem")))) {
                String fundflowitemSeri = SerializeHelper.serializeDynamicObj((Object)fundflowitem);
                returnData.put("e_fundflowitem", fundflowitemSeri);
            }
            String receivertype = dataEntity.getString("receivertype");
            returnData.put("e_payeetype", receivertype);
            String remark = dataEntity.getString("remark");
            if (!CasHelper.isEmpty((Object)remark)) {
                returnData.put("e_remark", remark);
            }
            if (AsstActTypeEnum.OTHER.getValue().equals(receivertype)) {
                String e_recer = dataEntity.getString("e_recer");
                if (!EmptyUtil.isEmpty((String)e_recer)) {
                    returnData.put("e_recer", dataEntity.getString("e_recer"));
                }
            } else {
                DynamicObject e_recerid = dataEntity.getDynamicObject("e_recerid");
                if (!CasHelper.isEmpty((Object)e_recerid)) {
                    returnData.put("e_recer", e_recerid.getPkValue());
                }
            }
            String handleBill = dataEntity.getString("handlebill");
            if (!EmptyUtil.isEmpty((String)handleBill)) {
                returnData.put("handleBill", handleBill);
            }
            if (!EmptyUtil.isEmpty((DynamicObject)(sonAcct = dataEntity.getDynamicObject("sonacct")))) {
                returnData.put("sonacct", sonAcct.getLong("id"));
            }
            if (!EmptyUtil.isEmpty((DynamicObject)(group = dataEntity.getDynamicObject("group")))) {
                returnData.put("group", group.getLong("id"));
            }
            logger.info("\u4ed8\u6b3e\u624b\u5de5\u5165\u8d26\u8fd4\u56de\u4fe1\u606f" + returnData);
            this.getView().returnDataToParent(returnData);
        }
    }
}

