/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.enums.TabRecordStatusEnum;
import kd.fi.cas.formplugin.common.CasCommonFilterListPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;

public abstract class WorkbenchList
extends CasCommonFilterListPlugin {
    protected boolean orgChange = true;

    @Override
    protected String getAcctEntity() {
        return "bd_accountbanks";
    }

    protected abstract void viewCard();

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Iterator iterator = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
        while (iterator.hasNext()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)iterator.next();
            String fieldName = commonFilterColumn.getFieldName();
            if (this.isOrgFilterColumn(fieldName) || this.isBankAccountFilterColumn(fieldName) || fieldName.startsWith("bizdate")) continue;
            iterator.remove();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        boolean hasAccounts = false;
        if (filters != null) {
            for (QFilter qFilter : filters) {
                QFilter filter = qFilter.copy();
                List<Object> list = new ArrayList();
                String property = qFilter.getProperty();
                if (this.isBankAccountFilterColumn(property)) {
                    hasAccounts = true;
                    list = this.getAcctIds(filter);
                    this.cacheIdList("selectedAcctIdList", list);
                    continue;
                }
                if (property.equals("bizdate")) {
                    Date dateFilterBegin = null;
                    Date dateFilterEnd = null;
                    this.parseDateBeginAndEnd(dateFilterBegin, dateFilterEnd, filter);
                    continue;
                }
                if (!this.isOrgFilterColumn(property)) continue;
                this.selectedOrgIdList = list = this.getOrgIds(filter);
                this.cacheIdList("selectedOrgIdList", list);
            }
        }
        if (this.selectedOrgIdList.size() == 0) {
            ArrayList orgIds = new ArrayList();
            String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.entryFormId(), (String)"47150e89000000ac");
            orgIds.addAll(orgList);
            this.selectedOrgIdList = orgIds;
        }
        if (!hasAccounts) {
            this.cacheIdList("selectedAcctIdList", this.getAcctsByOrg(this.selectedOrgIdList));
        }
        QFilter q = null;
        Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
        q = "2".equals(recordbotn) ? new QFilter("receredtype", "=", (Object)ReceredtypeEnum.ACCOUNTED.getValue()) : new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
        if ("cas_intelrec".equals(this.getView().getFormShowParameter().getFormId())) {
            q = q.and(new QFilter("creditamount", ">", (Object)0));
        }
        if ("cas_intelpay".equals(this.getView().getFormShowParameter().getFormId())) {
            q = q.and(new QFilter("debitamount", ">", (Object)0));
        }
        q = q.and(new QFilter("istransup", "=", (Object)false));
        q = q.and(new QFilter("istransdown", "=", (Object)false));
        if (filters != null) {
            filters.add(q);
        }
        this.viewCard();
    }

    @Override
    protected boolean isOrgFilterColumn(String filterColumnName) {
        return filterColumnName.startsWith("company.") || filterColumnName.startsWith("org.");
    }

    private List<Long> getAcctsByOrg(List<Object> orgIds) {
        if (orgIds == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> orgPks = new ArrayList<Long>();
        for (Object orgId : orgIds) {
            if (orgId == null) continue;
            orgPks.add(Long.valueOf(orgId.toString()));
        }
        if (orgPks.isEmpty()) {
            return new ArrayList<Long>();
        }
        return AccountBankHelper.getUseableAccountPks(orgPks);
    }

    protected List<Long> getSelectedOrgPks() {
        if (!this.selectedOrgIdList.isEmpty()) {
            ArrayList<Long> orgIds = new ArrayList<Long>(this.selectedOrgIdList.size());
            for (Object orgIdObj : this.selectedOrgIdList) {
                if (orgIdObj == null) continue;
                orgIds.add(Long.valueOf(orgIdObj.toString()));
            }
            return orgIds;
        }
        return this.getCachedList("selectedOrgIdList");
    }

    protected List<Long> getSelectedAccountPks() {
        return this.getCachedList("selectedAcctIdList");
    }

    protected Date getSelectedBeginDate() {
        List<Object> selectedDateList = this.getCachedIdList("selectedDateList");
        if (selectedDateList != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return sdf.parse(selectedDateList.get(0).toString());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected Date getSelectedEndDate() {
        List<Object> selectedDateList = this.getCachedIdList("selectedDateList");
        if (selectedDateList != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return sdf.parse(selectedDateList.get(1).toString());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private List<Long> getCachedList(String key) {
        if (this.getPageCache().get(key) != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), List.class);
        }
        return null;
    }

    private <T> void cacheIdList(String key, List<T> selectedIdList) {
        if (selectedIdList != null) {
            this.getPageCache().put(key, SerializationUtils.toJsonString(selectedIdList));
        } else {
            this.getPageCache().put(key, null);
        }
    }

    private List<Object> getCachedIdList(String key) {
        String cache = this.getPageCache().get(key);
        if (cache != null) {
            return (List)SerializationUtils.fromJsonString((String)cache, List.class);
        }
        return null;
    }

    private void parseDateBeginAndEnd(Date dateFilterBegin, Date dateFilterEnd, QFilter dateFilter) {
        if (dateFilter != null) {
            if (">=".equals(dateFilter.getCP())) {
                dateFilterBegin = (Date)dateFilter.getValue();
            } else {
                dateFilterEnd = (Date)dateFilter.getValue();
            }
            List dateFilterNest = dateFilter.getNests(false);
            Iterator it = dateFilterNest.iterator();
            while (it.hasNext()) {
                QFilter filterInner = ((QFilter.QFilterNest)it.next()).getFilter();
                if (">=".equals(filterInner.getCP())) {
                    if (dateFilterBegin != null && !dateFilterBegin.before((Date)filterInner.getValue())) continue;
                    dateFilterBegin = (Date)filterInner.getValue();
                    continue;
                }
                if (dateFilterEnd != null && !dateFilterEnd.after((Date)filterInner.getValue())) continue;
                dateFilterEnd = (Date)filterInner.getValue();
            }
        }
        ArrayList<Date> list = new ArrayList<Date>();
        list.add(dateFilterBegin);
        list.add(dateFilterEnd);
        this.cacheIdList("selectedDateList", list);
    }

    private List<Object> getAcctIds(QFilter filter) {
        ArrayList<Object> acctIds = new ArrayList<Object>();
        if (filter != null) {
            this.processFilterProp(filter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filter});
            if (coll.size() > 0) {
                acctIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        }
        return acctIds;
    }

    private List<Object> getOrgIds(QFilter filter) {
        ArrayList<Object> orgIds = new ArrayList<Object>();
        if (filter != null) {
            this.processFilterProp(filter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
            if (coll.size() > 0) {
                orgIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        }
        return orgIds;
    }

    private void processFilterProp(QFilter filter) {
        String property = filter.getProperty();
        String[] str = property.split("\\.");
        if (str.length == 1) {
            filter.__setProperty("id");
        } else {
            filter.__setProperty(str[1]);
        }
        List filterNest = filter.getNests(true);
        Iterator it = filterNest.iterator();
        while (it.hasNext()) {
            QFilter filterInner = ((QFilter.QFilterNest)it.next()).getFilter();
            this.processFilterProp(filterInner);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "refresh": {
                this.refresh();
            }
        }
    }

    protected void refresh() {
        IListView listView = (IListView)this.getView();
        listView.refresh();
    }

    public String entryFormId() {
        return "cas_intelrec";
    }

    protected void refreshList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        billList.clearSelection();
    }

    protected void tabChange() {
        Tab tab = (Tab)this.getControl("recordstatustab");
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent tabSelectEvent) {
                String tabKey = tabSelectEvent.getTabKey();
                if ("norecord".equals(tabKey)) {
                    WorkbenchList.this.getModel().setValue("recordbotn", (Object)TabRecordStatusEnum.NORECORD.getValue());
                }
                if ("alrecord".equals(tabKey)) {
                    WorkbenchList.this.getModel().setValue("recordbotn", (Object)TabRecordStatusEnum.ALRECORD.getValue());
                }
            }
        });
    }
}

