/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.PropertyNode;

public class Mob2PcEntityTranslatorHelper {
    private static final Log log = LogFactory.getLog(Mob2PcEntityTranslatorHelper.class);

    public static DynamicObject getPcEntity(DynamicObject mobEntity, DynamicObject pcEntity, DataSourceConfig dataSourceConfig) {
        Map fieldMapping = dataSourceConfig.getFieldMapping();
        List entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
        HashMap<String, List<String>> entryFiledMap = new HashMap<String, List<String>>(16);
        for (Map.Entry<String, PropertyNode> entry : fieldMapping.entrySet()) {
            PropertyNode propertyNode = (PropertyNode)entry.getValue();
            Mob2PcEntityTranslatorHelper.setMainValue(entry, propertyNode, pcEntity, mobEntity, entryFiledMap);
        }
        for (Map.Entry<String, List<String>> entry : entryFiledMap.entrySet()) {
            String errMsg;
            String pcEntryKey = (String)entry.getKey();
            String mobEntryKey = null;
            String mobEntryIdKey = null;
            for (EntryMappingRelationship entryMappingRelationship : entryMappingRelationships) {
                String pcKey = entryMappingRelationship.getPcEntryKey();
                if (!pcEntryKey.equals(pcKey)) continue;
                mobEntryKey = entryMappingRelationship.getMobEntryKey();
                mobEntryIdKey = entryMappingRelationship.getMobEntryIdKey();
                break;
            }
            DynamicObjectCollection pcEntryCollection = pcEntity.getDynamicObjectCollection(pcEntryKey);
            if (StringUtils.isEmpty(mobEntryKey)) {
                errMsg = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u5206\u5f55\u6620\u5c04\u5173\u7cfb\u672a\u914d\u7f6e\u3010\u5206\u5f55\u6807\u8bc6\u3011", (String)"Mob2PcEntityTranslatorHelper_0", (String)"fi-dcm-mobile", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
            if (StringUtils.isEmpty(mobEntryIdKey)) {
                errMsg = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u5206\u5f55\u6620\u5c04\u5173\u7cfb\u672a\u914d\u7f6e\u3010\u5206\u5f55Id\u6807\u8bc6\u3011", (String)"Mob2PcEntityTranslatorHelper_1", (String)"fi-dcm-mobile", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
            DynamicObjectCollection mobEntryCollection = mobEntity.getDynamicObjectCollection(mobEntryKey);
            if (mobEntryCollection == null || mobEntryCollection.isEmpty()) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(pcEntryCollection.getDynamicObjectType(), null);
                pcEntity.set((String)entry.getKey(), (Object)dynamicObjectCollection);
                continue;
            }
            DynamicObjectCollection pcSaveDynamicObjectCollection = new DynamicObjectCollection();
            Mob2PcEntityTranslatorHelper.processEntryData(fieldMapping, pcSaveDynamicObjectCollection, entry, mobEntryIdKey, pcEntryCollection, mobEntryCollection);
            pcEntity.set(entry.getKey(), (Object)pcSaveDynamicObjectCollection);
        }
        log.info("\u8c03\u7528\u4fdd\u5b58\u670d\u52a1\u64cd\u4f5c\u7684\u5355\u636e\u5bf9\u8c61\u4fe1\u606f\uff1a\u3010{}\u3011", (Object)pcEntity.toString());
        return pcEntity;
    }

    private static void processEntryData(Map<String, PropertyNode> fieldMapping, DynamicObjectCollection pcSaveDynamicObjectCollection, Map.Entry<String, List<String>> entryFieldMappingItem, String mobEntryIdKey, DynamicObjectCollection pcEntryCollection, DynamicObjectCollection mobEntryCollection) {
        for (int i = 0; i < mobEntryCollection.size(); ++i) {
            DynamicObject mobItem = (DynamicObject)mobEntryCollection.get(i);
            Object mobPkValue = mobItem.get(mobEntryIdKey);
            DynamicObject pcItem = null;
            if (mobPkValue == null || String.valueOf(mobPkValue).equals("0")) {
                pcItem = new DynamicObject(pcEntryCollection.getDynamicObjectType());
            } else {
                for (int k = 0; k < pcEntryCollection.size(); ++k) {
                    DynamicObject pcEntry = (DynamicObject)pcEntryCollection.get(k);
                    Object pcPkValue = pcEntry.getPkValue();
                    if (!pcPkValue.equals(mobPkValue)) continue;
                    pcItem = (DynamicObject)pcEntryCollection.get(k);
                }
            }
            if (pcItem == null) continue;
            List<String> entryFieldList = entryFieldMappingItem.getValue();
            for (String entryField : entryFieldList) {
                PropertyNode propertyNode = fieldMapping.get(entryField);
                String fieldKey = propertyNode.getFieldKey();
                Object value = mobItem.get(entryField);
                pcItem.set(StringUtils.substringAfter((String)fieldKey, (String)(entryFieldMappingItem.getKey() + ".")), value);
            }
            pcSaveDynamicObjectCollection.add((Object)pcItem);
        }
    }

    private static void setMainValue(Map.Entry<String, PropertyNode> fieldMappingItem, PropertyNode pcField, DynamicObject dataEntity, DynamicObject billData, Map<String, List<String>> entryFiledMap) {
        PropertyNode parentNode = pcField.getParentNode();
        if (parentNode.getType() instanceof MainEntityType) {
            dataEntity.set(fieldMappingItem.getValue().getFieldKey(), billData.get(fieldMappingItem.getKey()));
            return;
        }
        if (parentNode.getType() instanceof EntityType) {
            List<String> newKey = entryFiledMap.get(parentNode.getFieldKey());
            if (newKey == null) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(fieldMappingItem.getKey());
                entryFiledMap.put(parentNode.getFieldKey(), keys);
            } else {
                newKey.add(fieldMappingItem.getKey());
                entryFiledMap.put(parentNode.getFieldKey(), newKey);
            }
            return;
        }
        Mob2PcEntityTranslatorHelper.setMainValue(fieldMappingItem, pcField.getParentNode(), dataEntity, billData, entryFiledMap);
    }
}

