/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.form;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ai.util.JsonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.dcm.mobile.business.helper.OrgHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.utils.PropertyValueUtils;

public class AppHomePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final String DCM_APP_ID = "dcm";
    private static final String USER_ORG_UNIT = "userOrgUnit";
    private static final String ENTITY_NUM = "entityNum";
    private static final String PERM_ITEM_ID = "permItemId";
    private Map<String, HashSet<String>> menuPerms = new HashMap<String, HashSet<String>>(12);
    private Map<String, Map<String, String>> permItems = new HashMap<String, Map<String, String>>(12);
    private String[] button = new String[]{"collection_task_list"};

    public void initialize() {
        super.initialize();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setOrgFunc("15");
        this.setCheckPermMenu();
        this.setCheckPerm();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.button);
        BasedataEdit f7 = (BasedataEdit)this.getControl("org");
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.beforeOrg(e);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setOrg();
        this.checkPermission();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.orgChange();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"AppHomePlugin_1", (String)"fi-dcm-mobile", (Object[])new Object[0]));
            return;
        }
        String orgNo = org.getString("number");
        Long orgId = org.getLong("id");
        MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
        switch (key) {
            case "collection_task_list": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobdcm_collection_list");
                break;
            }
        }
    }

    private void goUrl(String orgNo, Long orgId, MobileFormShowParameter formShowParameter, String entityNum) {
        formShowParameter.setFormId(entityNum);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("orgBillNo", (Object)orgNo);
        formShowParameter.setCustomParam("orgid", (Object)orgId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void setOrg() {
        IDataModel model = this.getModel();
        RequestContext requestContext = RequestContext.get();
        Object org = this.getModel().getValue("org");
        long curOrgId = org == null ? requestContext.getOrgId() : ((Long)((DynamicObject)org).getPkValue()).longValue();
        long userId = Long.parseLong(requestContext.getUserId());
        List<Long> invPermOrgIdList = OrgHelper.getOrgUnitIds(userId);
        this.getPageCache().put(USER_ORG_UNIT, JsonUtil.encodeToString(invPermOrgIdList));
        Long invOrgId = curOrgId;
        if (invPermOrgIdList.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458", (String)"AppHomePlugin_0", (String)"fi-dcm-mobile", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        String type = "10";
        List invPermOrgs = OrgUnitServiceHelper.filterOrgDuty(invPermOrgIdList, (String)type);
        if (invPermOrgs == null || invPermOrgs.isEmpty()) {
            if (!invPermOrgIdList.contains(curOrgId)) {
                invOrgId = invPermOrgIdList.get(0);
            }
        } else if (!invPermOrgs.contains(curOrgId)) {
            invOrgId = (Long)invPermOrgs.get(0);
        }
        model.setValue("org", (Object)invOrgId);
    }

    private void beforeOrg(BeforeF7SelectEvent e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (!hasPermOrgs.hasAllOrgPerm()) {
            List orgIdList = hasPermOrgs.getHasPermOrgs();
            formShowParameter.setCustomParam("range", (Object)orgIdList);
        }
    }

    public void orgChange() {
        this.checkPermission();
    }

    private void setCheckPermMenu() {
        HashSet<String> collTaskMenu = new HashSet<String>(2);
        collTaskMenu.add("collection_task_view");
        this.menuPerms.put("collection_task_list", collTaskMenu);
    }

    private void setCheckPerm() {
        HashMap<String, String> collTaskPerms = new HashMap<String, String>(3);
        collTaskPerms.put(ENTITY_NUM, "dcm_collaction");
        collTaskPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("collection_task_view", collTaskPerms);
    }

    private Boolean handleMenuOrgType(String menuKey) {
        Object org = this.getModel().getValue("org");
        Long orgId = (Long)((DynamicObject)org).getPkValue();
        switch (menuKey) {
            case "collection_task_list": {
                return this.checkOrgAccounting(orgId);
            }
        }
        return Boolean.TRUE;
    }

    private void checkPermission() {
        Object org = this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(this.permItems.size());
            RequestContext requestContext = RequestContext.get();
            long userId = Long.parseLong(requestContext.getUserId());
            for (Map.Entry<String, Map<String, String>> perms : this.permItems.entrySet()) {
                Map<String, String> perm = perms.getValue();
                String permKey = perms.getKey();
                boolean b = PermissionHelper.checkPermission((Long)userId, (Long)orgId, (String)DCM_APP_ID, (String)perm.get(ENTITY_NUM), (String)perm.get(PERM_ITEM_ID));
                permMap.put(permKey, b);
            }
            this.handleMenu(permMap);
        }
    }

    private void handleMenu(Map<String, Boolean> permMap) {
        Set keys;
        HashMap<Boolean, HashSet<String>> visibleMap = new HashMap<Boolean, HashSet<String>>(8);
        for (Map.Entry<String, HashSet<String>> perms : this.menuPerms.entrySet()) {
            HashSet<String> items;
            HashSet<String> permSet = perms.getValue();
            String menuKey = perms.getKey();
            Boolean isPerm = Boolean.TRUE;
            Boolean orgType = this.handleMenuOrgType(menuKey);
            if (orgType.booleanValue()) {
                for (String permKey : permSet) {
                    Boolean permValue = permMap.get(permKey);
                    if (permValue.booleanValue()) continue;
                    isPerm = Boolean.FALSE;
                    break;
                }
            } else {
                isPerm = orgType;
            }
            if ((items = (HashSet<String>)visibleMap.get(isPerm)) == null) {
                items = new HashSet<String>(8);
            }
            items.add(menuKey);
            visibleMap.put(isPerm, items);
        }
        Set isPermKeys = (Set)visibleMap.get(Boolean.TRUE);
        if (isPermKeys != null && !isPermKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, isPermKeys.toArray(new String[0]));
        }
        if ((keys = (Set)visibleMap.get(Boolean.FALSE)) != null && !keys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, ((Set)visibleMap.get(Boolean.FALSE)).toArray(new String[0]));
        }
    }

    private Boolean checkOrgAccounting(Long orgId) {
        List list = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList(orgId), (String)"10");
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

