/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.form.collection;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.dcm.mobile.common.StyleHelper;
import kd.fi.dcm.mobile.plugin.form.collection.ICollectionTaskBillPagePlugin;
import kd.scmc.msmob.business.helper.BaseDataFieldBizHelper;
import kd.scmc.msmob.common.utils.LabelAndToolUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class CollectionFeedbackEntryEditPlugin
extends EntryEditTplPlugin
implements ICollectionTaskBillPagePlugin,
IMobBillEditable {
    private static final Log LOG = LogFactory.getLog(CollectionFeedbackEntryEditPlugin.class);
    private static final String[] MODEL_FIELD_KEYS = new String[]{"e_overduereason", "e_recoverdate", "e_recoveramt", "e_overduereasonmsg", "e_recoverdesc", "e_attachment", "currency"};
    private static final String FBASEDATAID = "fbasedataid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"completeandnew", "cancel", "completeop"});
    }

    public void afterCreateNewData(EventObject e) {
        int entryEntityIndex = this.getEntryEntityIndex();
        this.setModelFieldKeys(entryEntityIndex);
        IFormView view = this.getView();
        LabelAndToolUtils.selBasedataEditLabelValue((IFormView)view, (String)"unit", (String)"unitlabel");
        LabelAndToolUtils.selBasedataEditLabelValue((IFormView)view, (String)"unit2nd", (String)"unit2ndlabel");
        this.setBtnVisible();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit recoverDate = (DateEdit)this.getControl("e_recoverdate");
        recoverDate.setMaxDate(new Date());
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData[] changeDatas = e.getChangeSet();
        Object newValue = changeDatas[0].getNewValue();
        switch (propertyName = e.getProperty().getName()) {
            case "e_recoveramt": 
            case "e_recoverdate": 
            case "e_overduereason": 
            case "e_overduereasonmsg": 
            case "e_recoverdesc": {
                this.setParentValue(propertyName, newValue);
                break;
            }
            case "e_attachment": {
                this.saveAttacheFile();
                break;
            }
        }
    }

    private void saveAttacheFile() {
        DynamicObjectCollection mobAttachment = (DynamicObjectCollection)this.getModel().getValue("e_attachment");
        int rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        this.getParentModel().beginInit();
        DynamicObjectCollection parentAttachment = (DynamicObjectCollection)this.getParentView().getModel().getValue("e_attachment", rowIndex);
        this.getParentView().getModel().setValue("e_attachment", null, rowIndex);
        parentAttachment.clear();
        for (DynamicObject attData : mobAttachment.getInsertRows()) {
            DynamicObject fbasedataid = attData.getDynamicObject(FBASEDATAID);
            DynamicObject addNew = parentAttachment.addNew();
            addNew.set(FBASEDATAID, (Object)fbasedataid);
        }
        this.getParentModel().endInit();
        this.getParentView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        String name;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (name = control.getKey()) {
            case "completeandnew": {
                this.getModel().beginInit();
                int entryIndex = this.getParentModel().createNewEntryRow("entryentity");
                Date date = (Date)this.getParentModel().getValue("e_backdate", entryIndex);
                DynamicObject currentUser = (DynamicObject)this.getParentModel().getValue("e_backuser", entryIndex);
                if (date == null) {
                    this.getParentModel().setValue("e_backdate", (Object)new Date(), entryIndex);
                }
                if (currentUser == null) {
                    RequestContext requestContext = RequestContext.get();
                    this.getParentModel().setValue("e_backuser", (Object)Long.parseLong(requestContext.getUserId()), entryIndex);
                }
                this.getParentModel().updateCache();
                this.setModelFieldKeys(entryIndex);
                String successAttIdsKey = "SuccessAttIds:" + this.getView().getPageId() + ":" + "e_attachment";
                this.getPageCache().remove(successAttIdsKey);
                this.getView().updateView();
                this.getModel().endInit();
                break;
            }
            case "cancel": {
                int index = Integer.parseInt(this.getPageCache().get("row"));
                this.getModel().beginInit();
                this.getParentModel().deleteEntryRow("entryentity", index);
                this.getModel().endInit();
                this.getView().close();
                break;
            }
        }
    }

    private void setBtnVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"cancel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"completeandnew"});
        Boolean isNew = (Boolean)this.getView().getFormShowParameter().getCustomParam("isNew");
        if (isNew != null && isNew.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"goupop"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"godownuo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"completeandnew"});
            Control compeleteAndNew = this.getView().getControl("completeop");
            StyleHelper.controlSetFrontAndBackColor(compeleteAndNew, "#000000", "#FFFFFF");
        }
    }

    private int getEntryEntityIndex() {
        int index = this.getView().getParentView().getModel().getEntryCurrentRowIndex(this.getEntryEntity());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object row = formShowParameter.getCustomParam("row");
        if (row != null) {
            index = Integer.parseInt(row.toString());
        }
        return index;
    }

    private void setModelFieldKeys(int entryEntityIndex) {
        IDataModel model = this.getModel();
        this.getPageCache().put("row", String.valueOf(entryEntityIndex));
        IDataModel parentModel = this.getView().getParentView().getModel();
        List<String> fieldKeys = this.getFieldKeys();
        for (String fieldKey : fieldKeys) {
            Object fieldValue = parentModel.getValue(fieldKey, entryEntityIndex);
            this.setMobFieldValue(model, parentModel, fieldKey, fieldValue);
        }
    }

    private void setMobFieldValue(IDataModel model, IDataModel parentModel, String fieldKey, Object fieldValue) {
        model.beginInit();
        IDataEntityProperty property = parentModel.getProperty(fieldKey);
        if (property instanceof MulBasedataProp) {
            Object[] multiBaseDataIdArr = BaseDataFieldBizHelper.getMultiBaseDataIdArr((Object)fieldValue);
            model.setValue(fieldKey, (Object)multiBaseDataIdArr);
        } else {
            model.setValue(fieldKey, fieldValue);
        }
        model.endInit();
    }
}

