/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.form.collection;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.dcm.mobile.common.StyleHelper;
import kd.fi.dcm.mobile.plugin.form.collection.CollectionFeedbackEntryEditPlugin;
import kd.scmc.msmob.business.helper.BaseDataFieldBizHelper;
import kd.scmc.msmob.common.utils.LabelAndToolUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;

public class CollectionPlayersEntryEditPlugin
extends EntryEditTplPlugin {
    private static final Log LOG = LogFactory.getLog(CollectionFeedbackEntryEditPlugin.class);
    private static final String[] MODEL_FIELD_KEYS = new String[]{"e_user", "e_position", "e_phone", "e_email"};

    public void afterCreateNewData(EventObject e) {
        int entryEntityIndex = this.getEntryEntityIndex();
        this.setModelFieldKeys(entryEntityIndex);
        IFormView view = this.getView();
        LabelAndToolUtils.selBasedataEditLabelValue((IFormView)view, (String)"unit", (String)"unitlabel");
        LabelAndToolUtils.selBasedataEditLabelValue((IFormView)view, (String)"unit2nd", (String)"unit2ndlabel");
        this.setBtnVisible();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"completeandnew", "cancel"});
    }

    public void click(EventObject evt) {
        String name;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (name = control.getKey()) {
            case "completeandnew": {
                this.getModel().beginInit();
                int entryIndex = this.getParentModel().createNewEntryRow("userentry");
                this.setModelFieldKeys(entryIndex);
                this.getView().updateView();
                this.getModel().endInit();
                break;
            }
            case "cancel": {
                int index = Integer.parseInt(this.getPageCache().get("row"));
                this.getModel().beginInit();
                this.getParentModel().deleteEntryRow("userentry", index);
                this.getModel().endInit();
                this.getView().close();
                break;
            }
        }
    }

    public String getEntryEntity() {
        return "userentry";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    private void setBtnVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"cancel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"completeandnew"});
        Boolean isNew = (Boolean)this.getView().getFormShowParameter().getCustomParam("isNew");
        if (isNew != null && isNew.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"goupop"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"godownuo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"completeandnew"});
            Control compeleteAndNew = this.getView().getControl("completeop");
            StyleHelper.controlSetFrontAndBackColor(compeleteAndNew, "#000000", "#FFFFFF");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData[] changeDatas = e.getChangeSet();
        Object newValue = changeDatas[0].getNewValue();
        switch (propertyName = e.getProperty().getName()) {
            case "e_user": 
            case "e_position": 
            case "e_phone": 
            case "e_email": {
                this.setParentValue(propertyName, newValue);
                break;
            }
        }
    }

    private int getEntryEntityIndex() {
        int index = this.getView().getParentView().getModel().getEntryCurrentRowIndex(this.getEntryEntity());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object row = formShowParameter.getCustomParam("row");
        if (row != null) {
            index = Integer.parseInt(row.toString());
        }
        return index;
    }

    private void setModelFieldKeys(int entryEntityIndex) {
        IDataModel model = this.getModel();
        this.getPageCache().put("row", String.valueOf(entryEntityIndex));
        IDataModel parentModel = this.getView().getParentView().getModel();
        List<String> fieldKeys = this.getFieldKeys();
        for (String fieldKey : fieldKeys) {
            Object fieldValue = parentModel.getValue(fieldKey, entryEntityIndex);
            this.setMobFieldValue(model, parentModel, fieldKey, fieldValue);
        }
    }

    private void setMobFieldValue(IDataModel model, IDataModel parentModel, String fieldKey, Object fieldValue) {
        model.beginInit();
        IDataEntityProperty property = parentModel.getProperty(fieldKey);
        if (property instanceof MulBasedataProp) {
            Object[] multiBaseDataIdArr = BaseDataFieldBizHelper.getMultiBaseDataIdArr((Object)fieldValue);
            model.setValue(fieldKey, (Object)multiBaseDataIdArr);
        } else {
            model.setValue(fieldKey, fieldValue);
        }
        model.endInit();
    }
}

