/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.form.collection;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.mobile.plugin.form.collection.ICollectionTaskBillPagePlugin;
import kd.scmc.msmob.business.helper.AttachedFileHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;
import kd.scmc.msmob.pojo.PropertyNode;

public class CollectionTaskEditPlugin
extends MobBizBillInfoTplPlugin
implements ICollectionTaskBillPagePlugin,
IMobBillEditable {
    private static final String USER_DELETE_OP = "userdeleteop";
    private static final String ENTRY_DELETE_OP = "entrydeleteop";
    private static final String NEW_FEED_BACK_BTN = "newfeedbackbtn";
    private static final String NEW_FEED_BACK_VECTOR = "newfeedbackvector";
    private static final String DOWN = "down";
    private static final String UP = "up";
    private static final String DOWN_FLEX = "downflex";
    private static final String USER_ENTRY_EDIT_OP = "userentryeditop";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";
    private static final String USER_ENTRY = "userentry";
    private static final String NEW_USER_VECTOR = "newuservector";
    private static final String NEW_USERBTN = "newuserbtn";
    private static final String NEW_OPEN = "newOpen";
    private static final String MOBDCM_PLAYERS_ENTRYEDIT = "mobdcm_players_entryedit";
    private static final String MOBDCM_FEEDBACK_ENTRYEDIT = "mobdcm_feedback_entryedit";
    private String[] buttons = new String[]{"up", "down", "newfeedbackvector", "newfeedbackbtn", "entrydeleteop", "userdeleteop", "userentryeditop", "newuserbtn", "newuservector"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        for (int i = 0; i < this.curData.length; ++i) {
            Date earlistDate = (Date)this.curData[i].get("earlistdate");
            if (!EmptyUtils.isNotEmpty((Object)earlistDate)) continue;
            int overDueDay = DateUtils.getDiffDays((Date)earlistDate, (Date)new Date());
            this.getView().getModel().setValue("overdueday", (Object)overDueDay);
        }
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{UP, DOWN_FLEX});
        view.setVisible(Boolean.TRUE, new String[]{DOWN});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.buttons);
    }

    public String getEntryEntity() {
        return ENTRY_ENTITY;
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        IFormView view = this.getView();
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "down": {
                this.downOp(view);
                break;
            }
            case "up": {
                this.upOp(view);
                break;
            }
            case "entrydeleteop": {
                this.confirmDelEntryRow(ENTRY_ENTITY);
                break;
            }
            case "userdeleteop": {
                this.confirmDelEntryRow(USER_ENTRY);
                break;
            }
            case "newuservector": 
            case "newuserbtn": {
                this.openNewUserEntry(USER_ENTRY, NEW_OPEN, MOBDCM_PLAYERS_ENTRYEDIT);
                break;
            }
            case "newfeedbackvector": 
            case "newfeedbackbtn": {
                this.openNewFeedBackEntry(ENTRY_ENTITY, NEW_OPEN, MOBDCM_FEEDBACK_ENTRYEDIT);
                break;
            }
            case "userentryeditop": {
                this.openEntryEditPage(MOBDCM_PLAYERS_ENTRYEDIT);
                break;
            }
        }
    }

    private void openEntryEditPage(String entryKey) {
        MobileFormShowParameter formShowParameter = this.createShowParameter(entryKey, true);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "callback");
        formShowParameter.setCloseCallBack(callBack);
        this.goUrl(formShowParameter, false);
    }

    private void confirmDelEntryRow(String entryKey) {
        String msg = ResManager.loadKDString((String)" \u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"CollectionTaskEditPlugin_0", (String)"fi-dcm-mobile", (Object[])new Object[0]);
        int index = this.getModel().getEntryCurrentRowIndex(entryKey);
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        pageCache.put(pageId, String.valueOf(index));
        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(entryKey), null, String.valueOf(index));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        String customValue = pageCache.get(pageId);
        switch (callBackId) {
            case "entryentity": {
                this.delEntryRow(result, customValue, ENTRY_ENTITY);
                break;
            }
            case "userentry": {
                this.delEntryRow(result, customValue, USER_ENTRY);
                break;
            }
        }
    }

    private void delEntryRow(MessageBoxResult result, String customValue, String entryKey) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            int index = Integer.parseInt(customValue);
            this.getModel().deleteEntryRow(entryKey, index);
        }
    }

    private void downOp(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{DOWN});
        view.setVisible(Boolean.TRUE, new String[]{UP, DOWN_FLEX});
    }

    private void upOp(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{UP, DOWN_FLEX});
        view.setVisible(Boolean.TRUE, new String[]{DOWN});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView(ENTRY_ENTITY);
        this.getView().updateView(USER_ENTRY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "saveop": {
                this.afterSave(operationResult);
                break;
            }
            case "submitop": {
                if (operationResult.isSuccess()) {
                    IPageCache pageCache = this.getPageCache();
                    String pcId = pageCache.get("pcId");
                    this.afterSubmit(pcId);
                    break;
                }
                this.refreshMainFields("billno");
                break;
            }
        }
    }

    private void afterSave(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            IPageCache pageCache = this.getPageCache();
            String pcId = pageCache.get("pcId");
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
            AttachedFileHelper attachedFileHelper = new AttachedFileHelper();
            AttachedFileHelper.saveAttacheFile((AttachmentPanel)attachmentPanel, (String)this.getPcEntityKey(), (String)pcId);
            List attachments = AttachmentServiceHelper.getAttachments((String)this.getPcEntityKey(), (Object)pcId, (String)"attachmentpanel", (boolean)true);
            if (attachmentPanel != null) {
                attachmentPanel.bindData(attachments);
            }
        }
    }

    private void refreshMainFields(String ... fieldKeys) {
        if (fieldKeys == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String pcEntityKey = this.getPcEntityKey();
        Long billId = this.getBillId();
        DynamicObject pcBillDy = null;
        if (!this.isPush()) {
            pcBillDy = this.curData != null && this.curData.length == 1 ? this.curData[0] : this.getPcEntityById(billId.toString());
        } else {
            boolean exists = QueryServiceHelper.exists((String)pcEntityKey, (Object)billId);
            if (exists) {
                pcBillDy = this.getPcEntityById(billId.toString());
            }
        }
        if (pcBillDy != null) {
            Map fieldMapping = this.getFieldMapping();
            if (fieldKeys.length == 0) {
                model.beginInit();
                for (Map.Entry entryCase : fieldMapping.entrySet()) {
                    String mobFieldKey = (String)entryCase.getKey();
                    PropertyNode pcField = (PropertyNode)entryCase.getValue();
                    this.setMainEntityTypeValue(model, pcBillDy, mobFieldKey, pcField);
                    view.updateView(mobFieldKey);
                }
                model.endInit();
            } else {
                model.beginInit();
                for (String mobFieldKey : fieldKeys) {
                    PropertyNode pcField;
                    if (StringUtils.isEmpty((CharSequence)mobFieldKey) || (pcField = (PropertyNode)fieldMapping.get(mobFieldKey)) == null) continue;
                    this.setMainEntityTypeValue(model, pcBillDy, mobFieldKey, pcField);
                    view.updateView(mobFieldKey);
                }
                model.endInit();
            }
        }
    }

    private void setMainEntityTypeValue(IDataModel model, DynamicObject pcbillData, String mobFieldKey, PropertyNode pcField) {
        if (pcField == null) {
            return;
        }
        PropertyNode parentNode = pcField.getParentNode();
        if (parentNode == null) {
            return;
        }
        if (parentNode.getType() instanceof MainEntityType) {
            model.setValue(mobFieldKey, pcbillData.get(pcField.getFieldKey()));
            return;
        }
        if (parentNode.getType() instanceof SubEntryType || parentNode.getType() instanceof EntryType) {
            return;
        }
        this.setMainEntityTypeValue(model, pcbillData, mobFieldKey, pcField.getParentNode());
    }

    public void afterSubmit(String pcId) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
        AttachedFileHelper attachedFileHelper = new AttachedFileHelper();
        AttachedFileHelper.saveAttacheFile((AttachmentPanel)attachmentPanel, (String)this.getPcEntityKey(), (String)pcId);
        String successMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"CollectionTaskEditPlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
        this.getView().showSuccessNotification(successMsg);
        Boolean isModify = this.checkModifyPermission();
        if (Boolean.TRUE.equals(isModify)) {
            MobileFormShowParameter formShowParameter = this.createShowParameter(this.getBillViewFormKey(), false);
            this.goUrl(formShowParameter, true);
        } else {
            this.getModel().setValue("billStatus", (Object)"B");
            this.getView().updateView();
        }
    }

    private void openNewUserEntry(String entryEntity, String actionId, String pagekey) {
        int rowIndex = this.getModel().createNewEntryRow(entryEntity);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setFormId(pagekey);
        String pcId = this.getPageCache().get("pcId");
        formShowParameter.setCustomParam("pcId", (Object)pcId);
        formShowParameter.setCustomParam("row", (Object)rowIndex);
        formShowParameter.setCustomParam("isNew", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openNewFeedBackEntry(String entryEntity, String actionId, String pagekey) {
        int rowIndex = this.getModel().createNewEntryRow(entryEntity);
        Date date = (Date)this.getModel().getValue("e_backdate", rowIndex);
        DynamicObject currentUser = (DynamicObject)this.getModel().getValue("e_backuser", rowIndex);
        if (date == null) {
            this.getModel().setValue("e_backdate", (Object)new Date(), rowIndex);
        }
        if (currentUser == null) {
            RequestContext requestContext = RequestContext.get();
            this.getModel().setValue("e_backuser", (Object)Long.parseLong(requestContext.getUserId()), rowIndex);
        }
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setFormId(pagekey);
        String pcId = this.getPageCache().get("pcId");
        formShowParameter.setCustomParam("pcId", (Object)pcId);
        formShowParameter.setCustomParam("row", (Object)rowIndex);
        formShowParameter.setCustomParam("isNew", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

