/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.form.collection;

import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.mobile.plugin.form.collection.CollectionFeedbackEntryEditPlugin;
import kd.fi.dcm.mobile.plugin.form.collection.ICollectionTaskBillPagePlugin;
import kd.scmc.msmob.common.utils.PropertyValueUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillListTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;

public class CollectionTaskListPlugin
extends MobBillListTplPlugin
implements ICollectionTaskBillPagePlugin,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(CollectionFeedbackEntryEditPlugin.class);
    private static final String ASSTACT_MASTER_ID = "asstact.masterid";
    private static final String MASTER_ID = "masterid";
    private static final String BIZ_TIME = "biztime";
    private static final String BIZ_TYPE = "biztype";
    private static final String TASK_RADIO_LIST = "task_radio_list";
    private static final String INNER_USER_MASTER_ID = "inneruser.masterid";
    private static final String ITEMCLASSFIELD = "itemclassfield";
    private static final String INIT_ORG_ID = "initOrgId";
    private static final String ORGID = "orgid";
    private static final String ORG_BILL_NO = "orgBillNo";
    private static final String BD_CUSTOMER = "bd_customer";
    private static final String EARLIST_DATE = "earlistdate";
    private static final String OVER_DUE_DAY = "overdueday";
    private static final String ITEMCLASSTYPEFIELD = "itemclasstypefield";
    private static final String ORG_NUMBER = "org.number";
    public static final String AUDIT_STATUS = "A";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(ITEMCLASSFIELD);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public List<FilterCondition> getFilters() {
        DynamicObject asstactSelect;
        String orgNumber;
        List filters = super.getFilters();
        this.removeFilter(filters);
        String taskSelection = (String)this.getModel().getValue(TASK_RADIO_LIST);
        if (taskSelection != null && !"".equals(taskSelection) && AUDIT_STATUS.equals(taskSelection)) {
            RequestContext requestContext = RequestContext.get();
            Long userId = Long.parseLong(requestContext.getUserId());
            FilterCondition condition = new FilterCondition(INNER_USER_MASTER_ID, "=", (Object)userId);
            filters.add(condition);
        }
        if ((orgNumber = (String)this.getView().getFormShowParameter().getCustomParam(ORG_BILL_NO)) != null) {
            FilterCondition condition = new FilterCondition(ORG_NUMBER, "=", (Object)orgNumber);
            filters.add(condition);
        }
        if ((asstactSelect = (DynamicObject)this.getModel().getValue(ITEMCLASSFIELD)) != null && asstactSelect.get(MASTER_ID) != null) {
            Long asstactMasterId = (Long)asstactSelect.get(MASTER_ID);
            FilterCondition condition = new FilterCondition(ASSTACT_MASTER_ID, "=", (Object)asstactMasterId);
            filters.add(condition);
        }
        return filters;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String message = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"CollectionTaskListPlugin_1", (String)"fi-dcm-mobile", (Object[])new Object[0]);
        this.setFilterKeyPrompt(ITEMCLASSFIELD, message);
        this.getModel().beginInit();
        for (int i = 0; i < this.curData.length; ++i) {
            Date earListDate = (Date)this.curData[i].get(EARLIST_DATE);
            if (!EmptyUtils.isNotEmpty((Object)earListDate)) continue;
            int overDueDay = DateUtils.getDiffDays((Date)earListDate, (Date)new Date());
            this.getModel().setValue(OVER_DUE_DAY, (Object)overDueDay, i);
            this.getView().updateView("entryentity");
        }
        this.getModel().endInit();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) {
            return;
        }
        IDataModel model = this.getModel();
        switch (propName = e.getProperty().getName()) {
            case "task_radio_list": 
            case "itemclassfield": {
                model.beginInit();
                this.updateData();
                model.endInit();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "itemclassfield": {
                String value = (String)this.getView().getModel().getValue(ITEMCLASSTYPEFIELD);
                if (!BD_CUSTOMER.equals(value)) break;
                this.beforeCounterparties(e);
                break;
            }
        }
    }

    private void beforeCounterparties(BeforeF7SelectEvent e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object orgId = this.getView().getFormShowParameter().getCustomParam(ORGID);
        if (orgId != null) {
            List filters = e.getCustomQFilters();
            QFilter q = new QFilter("status", "=", (Object)"C");
            filters.add(q);
            e.setCustomQFilters(filters);
            formShowParameter.setCustomParam(INIT_ORG_ID, (Object)Long.valueOf(orgId.toString()));
        }
    }

    private void removeFilter(List<FilterCondition> filters) {
        Iterator<FilterCondition> iterator = filters.iterator();
        while (iterator.hasNext()) {
            FilterCondition filterCondition = iterator.next();
            if (BIZ_TIME.equals(filterCondition.getFilterKey())) {
                iterator.remove();
                continue;
            }
            if (!BIZ_TYPE.equals(filterCondition.getFilterKey())) continue;
            iterator.remove();
        }
    }
}

