/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.form.collection;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.mobile.plugin.form.collection.ICollectionTaskBillPagePlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;

public class CollectionTaskViewPlugin
extends MobBizBillInfoTplPlugin
implements ICollectionTaskBillPagePlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        for (int i = 0; i < this.curData.length; ++i) {
            Date earlistDate = (Date)this.curData[i].get("earlistdate");
            if (!EmptyUtils.isNotEmpty((Object)earlistDate)) continue;
            int overDueDay = DateUtils.getDiffDays((Date)earlistDate, (Date)new Date());
            this.getView().getModel().setValue("overdueday", (Object)overDueDay);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"up", "downflex"});
        view.setVisible(Boolean.TRUE, new String[]{"down"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"up", "down"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("userentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid grid = (EntryGrid)e.getSource();
        if ("userentry".equals(grid.getKey())) {
            String entryFormKey = "mobdcm_players_entryview";
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            Map customParams = mobileFormShowParameter.getCustomParams();
            this.setEntryViewParameter(customParams);
            mobileFormShowParameter.setFormId(entryFormKey);
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        }
        if ("entryentity".equals(grid.getKey())) {
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            Map customParams = mobileFormShowParameter.getCustomParams();
            this.setEntryViewParameter(customParams);
            mobileFormShowParameter.setFormId("mobdcm_feedback_entryview");
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        }
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        IFormView view = this.getView();
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "down": {
                this.downOp(view);
                break;
            }
            case "up": {
                this.upOp(view);
                break;
            }
        }
    }

    public String getEditFormId() {
        return "mobdcm_collection_edit";
    }

    private void downOp(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"down"});
        view.setVisible(Boolean.TRUE, new String[]{"up", "downflex"});
    }

    private void upOp(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"up", "downflex"});
        view.setVisible(Boolean.TRUE, new String[]{"down"});
    }
}

