/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.mobile.plugin.op.collection;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.mobile.business.helper.Mob2PcEntityTranslatorHelper;
import kd.scmc.msmob.plugin.tpl.optpl.BaseTplOp;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;

public class CollectionTaskTplOp
extends BaseTplOp {
    private static final String ATT_ID = "id";
    private static final String BILL_NUMBER = "number";
    private static final String BILL_PAGEID = "pageid";
    private static final String ATT_NAME = "name";
    private static final String ATT_STATUS = "status";
    private static final String ATT_TEMPFILE = "tempfile";
    private static final String ATT_UID = "uid";
    private static final String ATT_URL = "url";
    private static final String ATT_SIZE = "size";
    private static final String ATT_SUCCESS_STATUS = "B";
    private static final int ATT_OFFICIAL = 1;
    private static final String CONFIG_KEY = "tempfile/download.do?configKey";
    private static final int ATT_TEMP = 0;
    private static final String ATT_TEMP_CHAR = "0";
    private static final String ATT_ENTITYID = "bd_attachment";

    protected String getOperationKey() {
        return null;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = this.getOperationKey();
        String mobFormKey = dataEntities[0].getDynamicObjectType().getName();
        DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
        DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig(mobFormKey);
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        ArrayList<DynamicObject> pcEntityList = new ArrayList<DynamicObject>(dataEntities.length + 1);
        OperateOption operateOption = this.getOperateOption();
        for (DynamicObject dataEntity : dataEntities) {
            Long billId = dataEntity.getLong("billId");
            DynamicObject pcDyn = CollectionTaskTplOp.getDynamicObject(billId, pcEntityKey);
            DynamicObject pcEntity = Mob2PcEntityTranslatorHelper.getPcEntity(dataEntity, pcDyn, dataSourceConfig);
            if (pcEntity == null) continue;
            pcEntityList.add(pcEntity);
        }
        this.processEntity(pcEntityList);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)pcEntityKey, (DynamicObject[])pcEntityList.toArray(new DynamicObject[pcEntityList.size()]), (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            this.afterExecuteOperate(pcEntityList);
        }
        this.processOperationResult(operationResult);
    }

    private void afterExecuteOperate(List<DynamicObject> pcEntityList) {
        ArrayList<Object> pkValues = new ArrayList<Object>(32);
        for (DynamicObject dynamicObject : pcEntityList) {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("backentry");
            for (DynamicObject entry : collection) {
                DynamicObjectCollection attCollection = entry.getDynamicObjectCollection("e_attachment");
                for (DynamicObject attachment : attCollection) {
                    DynamicObject baseData = attachment.getDynamicObject("fbasedataid");
                    if (baseData == null) continue;
                    Object pkValue = baseData.getPkValue();
                    pkValues.add(pkValue);
                }
            }
        }
        if (!pkValues.isEmpty()) {
            this.saveAttacheFile(pkValues);
        }
    }

    private void saveAttacheFile(List<Object> pkValues) {
        QFilter[] filters = new QFilter[]{new QFilter(ATT_TEMPFILE, "=", (Object)ATT_TEMP_CHAR), new QFilter(ATT_ID, "in", pkValues), new QFilter(ATT_STATUS, "=", (Object)ATT_SUCCESS_STATUS)};
        String selectFields = "id,name,tempfile,url,pageid,size,type,uid,description";
        DynamicObject[] att = BusinessDataServiceHelper.load((String)ATT_ENTITYID, (String)selectFields, (QFilter[])filters);
        long compressPicSize = AttachmentServiceHelper.getCompressPicSize();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(att.length);
        for (int i = 0; i < att.length; ++i) {
            String tempUrl = (String)att[i].get(ATT_URL);
            String name = String.valueOf(att[i].get(ATT_NAME));
            Object attPk = att[i].getPkValue();
            if (!tempUrl.contains(CONFIG_KEY)) continue;
            String path = AttachmentFieldServiceHelper.saveTempToFileService((String)tempUrl, (Object)attPk, (String)name);
            att[i].set(ATT_URL, (Object)path);
            att[i].set(ATT_TEMPFILE, (Object)1);
            att[i].set(BILL_PAGEID, (Object)"");
            String extName = name.substring(name.lastIndexOf(46) + 1);
            if ("jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,dcx,pic,tif,wmf".contains(extName.toLowerCase()) && compressPicSize != 0L && Long.parseLong(att[i].get(ATT_SIZE).toString()) > compressPicSize * 1024L) {
                att[i].set(ATT_SIZE, (Object)(compressPicSize * 1024L));
            }
            list.add(att[i]);
        }
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    protected void processEntity(List<DynamicObject> list) {
        for (DynamicObject entity : list) {
            Date earlistDate = entity.getDate("earlistdate");
            if (!EmptyUtils.isNotEmpty((Object)earlistDate)) continue;
            int overDueDay = DateUtils.getDiffDays((Date)earlistDate, (Date)new Date());
            entity.set("overdueday", (Object)overDueDay);
        }
    }

    public static DynamicObject getDynamicObject(Long pcId, String pcEntityKey) {
        if (pcId == null || StringUtils.isEmpty((CharSequence)pcEntityKey)) {
            String errMsg = ResManager.loadKDString((String)"\u8c03\u7528Mob2PcEntityTranslatorHelper\u7684getDynamicObject\u65b9\u6cd5\u7684\u5165\u53c2\u3010pcId\u3011\u6216\u3010pcEntityKey\u3011\u6216\u3010operateOption\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"Mob2PcEntityTranslatorHelper_0", (String)"fi-dcm-mobile", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (!QueryServiceHelper.exists((String)pcEntityKey, (Object)pcId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"Mob2PcEntityTranslatorHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        return BusinessDataServiceHelper.loadSingle((Object)pcId, (String)pcEntityKey);
    }
}

