/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.formplugin;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.StringUtils;

public class CollectionTplEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("billtree");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadBillTreeNodeByCache();
        this.setBillTreeNode();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (!"billentity".equals(key)) {
            return;
        }
        DynamicObject oldValueDo = (DynamicObject)changeSet[0].getOldValue();
        if (oldValueDo == null) {
            this.loadBillTreeNodeByCache();
            this.setBillTreeNode();
            return;
        }
        String oldValue = StringUtils.toSafeString((Object)oldValueDo.getPkValue());
        DynamicObject newValueDo = (DynamicObject)changeSet[0].getNewValue();
        if (newValueDo == null) {
            this.setBillTreeNode();
            return;
        }
        String newValue = StringUtils.toSafeString((Object)newValueDo.getPkValue());
        if (!oldValue.equals(newValue)) {
            this.loadBillTreeNodeByCache();
            this.setBillTreeNode();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = StringUtils.toSafeString((Object)e.getNodeId());
        if (StringUtils.isBlank((String)nodeId)) {
            return;
        }
        TreeNode root = this.getRootNode();
        if (null == root) {
            return;
        }
        TreeNode selectedNode = root.getTreeNode(nodeId, 16);
        if (null == selectedNode) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)selectedNode.getChildren())) {
            return;
        }
        IDataModel model = this.getModel();
        String text = StringUtils.toSafeString((Object)model.getValue("tplcontent"));
        model.setValue("tplcontent", (Object)(text + "{" + nodeId + "}"));
    }

    private TreeNode getRootNode() {
        IPageCache pageCache = this.getPageCache();
        DynamicObject billEntity = (DynamicObject)this.getModel().getValue("billentity");
        if (billEntity == null) {
            return null;
        }
        String json = pageCache.get(StringUtils.toSafeString((Object)billEntity.getPkValue()));
        if (StringUtils.isNotBlank((String)json)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        return null;
    }

    private void loadBillTreeNodeByCache() {
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        DynamicObject billEntityDo = (DynamicObject)this.getModel().getValue("billentity");
        if (billEntityDo == null) {
            return;
        }
        String billEntityNumber = StringUtils.toSafeString((Object)billEntityDo.getPkValue());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        billTreeNode.setIsOpened(true);
        String billTreeNodeJson = SerializationUtils.toJsonString((Object)billTreeNode);
        this.getPageCache().put(billEntityNumber, billTreeNodeJson);
    }

    private void setBillTreeNode() {
        TreeView treeView = (TreeView)this.getView().getControl("billtree");
        treeView.deleteAllNodes();
        TreeNode root = this.getRootNode();
        if (null != root) {
            root.setIsOpened(true);
            treeView.addNode(root);
        }
    }
}

