/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StringUtils;

public class DcmRecordEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid acEntryGrid = (EntryGrid)this.getControl("actiondetailentry");
        acEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid srcEntryGrid = (EntryGrid)this.getControl("srcentry");
        srcEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Date earlistDate = (Date)this.getModel().getValue("earlistdate");
        if (EmptyUtils.isNotEmpty((Object)earlistDate)) {
            int overDueDay = DateUtils.getDiffDays((Date)earlistDate, (Date)new Date());
            this.getModel().setValue("overdueday", (Object)overDueDay);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int iRow = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "ac_actionbillno": 
            case "e_srcbillno": {
                Object pk;
                BillShowParameter parameter = new BillShowParameter();
                if ("ac_actionbillno".equals(fieldName)) {
                    pk = this.getModel().getValue("ac_actiontbillid", iRow);
                    parameter.setFormId("dcm_collaction");
                    parameter.setPkId(pk);
                }
                if ("e_srcbillno".equals(fieldName)) {
                    pk = this.getModel().getValue("e_srcbillid", iRow);
                    DynamicObject eBillEntity = (DynamicObject)this.getModel().getValue("e_billentity", iRow);
                    parameter.setFormId(StringUtils.toSafeString((Object)eBillEntity.getPkValue()));
                    parameter.setPkId(pk);
                }
                parameter.setStatus(OperationStatus.EDIT);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("viewactionback".equals(key)) {
            this.viewBackReport("dcm_collrecord", new Object[]{this.getModel().getDataEntity().getPkValue()});
        }
    }

    public void viewBackReport(String formid, Object[] billid) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("dcm_actionback");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("formid", formid);
        customParams.put("billid", billid);
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }
}

