/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.StringUtils;
import kd.fi.dcm.formplugin.base.DcmStrategyBaseEdit;

public class DcmRecordRuleEdit
extends DcmStrategyBaseEdit {
    private Map<String, List<FilterField>> billEntityNumMap = new HashMap<String, List<FilterField>>();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBotpGroupByMode(this.getModel().getValue("ruleid"));
        this.setEntryTargetField();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (key) {
            case "ruleid": {
                if (newValue != null && oldValue != null && newValue.equals(oldValue)) break;
                this.getModel().deleteEntryData("groupentry");
                this.setBotpGroupByMode(newValue);
                this.setWriteBackField(this.getModel().getValue("writebackfield"));
                break;
            }
            case "writebackfield": {
                this.setWriteBackField(newValue);
            }
        }
    }

    private void setWriteBackField(Object newValue) {
        if (newValue == null) {
            return;
        }
        DynamicObject ruleId = (DynamicObject)this.getModel().getValue("ruleid");
        if (ruleId == null) {
            return;
        }
        ConvertRuleElement ruleElement = ConvertMetaServiceHelper.loadRule((String)StringUtils.toSafeString((Object)ruleId.get("number")));
        LinkEntityPolicy linkEntityPolicy = ruleElement.getLinkEntityPolicy();
        String sourceEntryKey = linkEntityPolicy.getSourceEntryKey();
        String[] fields = StringUtils.toSafeString((Object)newValue).split("\\.");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getBillEntityNumber());
        Map entryFields = ((EntityType)entityType.getAllEntities().get(sourceEntryKey)).getFields();
        boolean isExist = false;
        for (String field : fields) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entryFields.get(field);
            if (iDataEntityProperty == null) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.getModel().setValue("writebackfield", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9[\u8f6c\u6362\u89c4\u5219]->[\u5173\u8054\u5b9e\u4f53]->[\u6e90\u5355\u5173\u8054\u5b9e\u4f53]\u7684\u53cd\u5199\u5b57\u6bb5!", (String)"DcmRecordRuleEdit_0", (String)"fi-dcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setBotpGroupByMode(Object newValue) {
        if (newValue == null) {
            return;
        }
        DynamicObject ruleId = (DynamicObject)newValue;
        ConvertRuleElement ruleElement = ConvertMetaServiceHelper.loadRule((String)StringUtils.toSafeString((Object)ruleId.get("number")));
        GroupByPolicy groupByPolicy = ruleElement.getGroupByPolicy();
        if (StringUtils.isNotBlank((String)groupByPolicy.getGroupByField())) {
            Object[] fields = groupByPolicy.getGroupByField().split(",");
            if (CollectionUtils.isEmpty((Object[])fields)) {
                return;
            }
            for (Object field : fields) {
                if (this.isExistField(ruleElement.getId(), 1, (String)field)) continue;
                String propFullCaption = this.getPropFullCaption((String)field);
                int newEntryRow = this.getModel().createNewEntryRow("groupentry");
                this.getModel().setValue("e_policy", (Object)1, newEntryRow);
                this.getModel().setValue("e_fieldname", (Object)propFullCaption, newEntryRow);
                this.getModel().setValue("e_fieldvalue", field, newEntryRow);
                this.getModel().setValue("e_ruleid", (Object)ruleElement.getId(), newEntryRow);
                this.getModel().setValue("e_rulename", (Object)ruleElement.getName().getLocaleValue(), newEntryRow);
            }
        }
    }

    private boolean isExistField(String ruleId, int policy, String field) {
        DynamicObjectCollection groupentry = this.getModel().getEntryEntity("groupentry");
        if (CollectionUtils.isEmpty((Collection)groupentry)) {
            return false;
        }
        for (DynamicObject dynamicObject : groupentry) {
            String fieldvalue = dynamicObject.getString("e_fieldvalue");
            int entryPolicy = dynamicObject.getInt("e_policy");
            String entryRuleid = dynamicObject.getString("e_ruleid");
            if (entryPolicy != policy || !entryRuleid.equals(ruleId) || !field.equals(fieldvalue)) continue;
            return true;
        }
        return false;
    }

    private String getPropFullCaption(String fullPropVal) {
        String billEntityNumber = this.getBillEntityNumber();
        String fullCaption = "";
        List filterFields = this.billEntityNumMap.get(billEntityNumber);
        if (CollectionUtils.isEmpty(filterFields)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
            filterFields = EntityTypeUtil.getInstance().getFilterFields((IDataEntityType)entityType);
            this.billEntityNumMap.put(billEntityNumber, filterFields);
        }
        for (FilterField field : filterFields) {
            if (!fullPropVal.equals(field.getFullFieldName())) continue;
            fullCaption = field.getCaption().getLocaleValue();
            break;
        }
        return fullCaption;
    }

    public void setEntryTargetField() {
        if (StringUtils.isBlank((String)this.getBillEntityNumber())) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getBillEntityNumber());
        List filterFields = EntityTypeUtil.getInstance().getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        ComboEdit targerFieldCombo = (ComboEdit)this.getControl("e_targerfield");
        targerFieldCombo.setComboItems(items);
    }
}

