/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.formplugin.base;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.dcm.common.consts.StrategyLimitValue;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.ConditionUtils;
import kd.fi.dcm.common.util.StringUtils;

public class DcmStrategyBaseEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"morefilerdesc", "closerecordfilter", "billentity", "amtuplimit", "amtdownlimit", "daysuplimit", "daysdownlimit"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if ("morefilerdesc".equals(key)) {
            this.showMoreFilterView("morefilerdesc", "morefilerval");
        }
        if ("closerecordfilter".equals(key)) {
            this.showMoreFilterView("closerecordfilter", "closerecordfilterval");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setContrastFieldValues();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("dcm_actionstrategy".equals(dataEntity.getDataEntityType().getExtendName())) {
            this.setPositionFieldValues();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key = e.getProperty().getName()) {
            case "amtdownlimit": 
            case "amtuplimit": 
            case "daysdownlimit": 
            case "daysuplimit": {
                this.checkInputValue(key, oldValue, newValue);
            }
        }
    }

    private void showMoreFilterView(String filterKeyEntity, String filterValEntity) {
        String entityName = this.getBillEntityNumber();
        if (StringUtils.isBlank((String)entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e", (String)"DcmStrategyBaseEdit_0", (String)"fi-dcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ConditionUtils conditionUtils = new ConditionUtils(this.getView(), (AbstractFormPlugin)this);
        conditionUtils.showConditionForm(entityName, false, filterKeyEntity, filterValEntity);
    }

    public void closedCallBack(ClosedCallBackEvent close) {
        String actionId = close.getActionId();
        String filterValEntity = "";
        if ("morefilerdesc".equals(actionId)) {
            filterValEntity = "morefilerval";
        }
        if ("closerecordfilter".equals(actionId)) {
            filterValEntity = "closerecordfilterval";
        }
        if (StringUtils.isNotBlank((String)filterValEntity)) {
            String entityName = this.getBillEntityNumber();
            if (StringUtils.isBlank((String)entityName)) {
                return;
            }
            ConditionUtils conditionUtils = new ConditionUtils(this.getView(), (AbstractFormPlugin)this);
            conditionUtils.closeCallBackHandle(close, actionId, entityName, filterValEntity);
        }
    }

    public void setContrastFieldValues() {
        if (StringUtils.isBlank((String)this.getBillEntityNumber())) {
            return;
        }
        ArrayList<ComboItem> amtItems = new ArrayList<ComboItem>(10);
        ArrayList<ComboItem> dateItems = new ArrayList<ComboItem>(10);
        ArrayList<ComboItem> booleanItems = new ArrayList<ComboItem>(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getBillEntityNumber());
        List filterFields = EntityTypeUtil.getInstance().getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            ComboItem item;
            String fullFieldName;
            LocaleString caption;
            IDataEntityProperty fieldProp = field.getFieldProp();
            if (fieldProp instanceof DateProp) {
                caption = field.getCaption();
                fullFieldName = field.getFullFieldName();
                item = new ComboItem(caption, fullFieldName);
                dateItems.add(item);
                continue;
            }
            if (fieldProp instanceof AmountProp) {
                caption = field.getCaption();
                fullFieldName = field.getFullFieldName();
                item = new ComboItem(caption, fullFieldName);
                amtItems.add(item);
                continue;
            }
            if (!(fieldProp instanceof BooleanProp)) continue;
            caption = field.getCaption();
            fullFieldName = field.getFullFieldName();
            item = new ComboItem(caption, fullFieldName);
            booleanItems.add(item);
        }
        ComboEdit amtFieldCombo = (ComboEdit)this.getControl("amtfield");
        amtFieldCombo.setComboItems(amtItems);
        ComboEdit dateFieldCombo = (ComboEdit)this.getControl("datefield");
        dateFieldCombo.setComboItems(dateItems);
        ComboEdit wbFieldCombo = (ComboEdit)this.getControl("writebackfield");
        if (wbFieldCombo != null) {
            wbFieldCombo.setComboItems(booleanItems);
        }
    }

    public void setPositionFieldValues() {
        QFilter positiontypeFilter = new QFilter("positiontype", "=", (Object)"A");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] qFilter = new QFilter[]{positiontypeFilter, enableFilter};
        Object[] collectiopositions = BusinessDataServiceHelper.load((String)"dcm_collposition", (String)"id,name", (QFilter[])qFilter);
        if (CollectionUtils.isEmpty((Object[])collectiopositions)) {
            return;
        }
        ArrayList<ComboItem> collpositionjoinCim = new ArrayList<ComboItem>(10);
        for (Object collectioposition : collectiopositions) {
            collpositionjoinCim.add(new ComboItem(new LocaleString(collectioposition.getString("name")), collectioposition.getString("id")));
        }
        MulComboEdit collpositionjoinCtl = (MulComboEdit)this.getControl("ac_collpositionjoin");
        collpositionjoinCtl.setComboItems(collpositionjoinCim);
    }

    public String getBillEntityNumber() {
        String billEntityNumber = "";
        DynamicObject billEntityDo = (DynamicObject)this.getModel().getValue("billentity");
        if (billEntityDo == null) {
            return billEntityNumber;
        }
        billEntityNumber = StringUtils.toSafeString((Object)billEntityDo.getPkValue());
        return billEntityNumber;
    }

    private void checkInputValue(String key, Object oldValue, Object newValue) {
        if ("amtuplimit".equals(key)) {
            if (newValue == null) {
                this.getModel().setValue(key, (Object)StrategyLimitValue.MaxAmtValue);
                return;
            }
            Object eAmtDownLimit = this.getModel().getValue("amtdownlimit");
            if (eAmtDownLimit != null && ((BigDecimal)newValue).compareTo((BigDecimal)eAmtDownLimit) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u4e0a\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u91d1\u989d\u4e0b\u9650\u3002", (String)"DcmStrategyBaseEdit_1", (String)"fi-dcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, oldValue);
            }
        }
        if ("amtdownlimit".equals(key)) {
            if (newValue == null) {
                this.getModel().setValue(key, (Object)StrategyLimitValue.MinAmtValue);
                return;
            }
            Object eAmtUpLimit = this.getModel().getValue("amtuplimit");
            if (eAmtUpLimit != null && ((BigDecimal)newValue).compareTo((BigDecimal)eAmtUpLimit) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u4e0a\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u91d1\u989d\u4e0b\u9650\u3002", (String)"DcmStrategyBaseEdit_1", (String)"fi-dcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, oldValue);
            }
        }
        if ("daysdownlimit".equals(key)) {
            if (newValue == null) {
                this.getModel().setValue(key, (Object)StrategyLimitValue.MinDayValue);
                return;
            }
            Object daysuplimit = this.getModel().getValue("daysuplimit");
            if (daysuplimit != null && (Integer)newValue > (Integer)daysuplimit) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u903e\u671f\u5929\u6570\u4e0a\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u903e\u671f\u5929\u6570\u4e0b\u9650\u3002", (String)"DcmStrategyBaseEdit_2", (String)"fi-dcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, oldValue);
            }
        }
        if ("daysuplimit".equals(key)) {
            if (newValue == null) {
                this.getModel().setValue(key, (Object)StrategyLimitValue.MaxDayValue);
                return;
            }
            Object daysdownlimit = this.getModel().getValue("daysdownlimit");
            if (daysdownlimit != null && (Integer)newValue < (Integer)daysdownlimit) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u903e\u671f\u5929\u6570\u4e0a\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u903e\u671f\u5929\u6570\u4e0b\u9650\u3002", (String)"DcmStrategyBaseEdit_2", (String)"fi-dcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, oldValue);
            }
        }
    }
}

