/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.common.convert;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.fi.dcm.common.util.DateUtils;

public class FinArToDcmRecordPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey("dcm_collrecord")) {
            DynamicObject collRecord = entity.getDataEntity();
            this.entrySummary(collRecord);
        }
    }

    private void entrySummary(DynamicObject record) {
        DynamicObjectCollection srcEntry = record.getDynamicObjectCollection("srcentry");
        if (srcEntry == null || srcEntry.size() == 0) {
            return;
        }
        Date earliestDate = null;
        Date latestDate = null;
        int overDueDay = 0;
        BigDecimal overDueAmt = BigDecimal.ZERO;
        for (DynamicObject row : srcEntry) {
            Date eSrcDuedate;
            boolean isClose = row.getBoolean("e_isclose");
            BigDecimal eSrcOverAmount = row.getBigDecimal("e_srcoveramount");
            if (!isClose) {
                overDueAmt = overDueAmt.add(eSrcOverAmount);
            }
            if ((eSrcDuedate = row.getDate("e_srcduedate")) == null) continue;
            if (earliestDate == null) {
                earliestDate = eSrcDuedate;
            } else if (eSrcDuedate.before(earliestDate)) {
                earliestDate = eSrcDuedate;
            }
            if (latestDate == null) {
                latestDate = eSrcDuedate;
                continue;
            }
            if (!eSrcDuedate.after(latestDate)) continue;
            latestDate = eSrcDuedate;
        }
        if (earliestDate != null) {
            overDueDay = DateUtils.getDiffDays(earliestDate, new Date());
        }
        record.set("earlistdate", earliestDate);
        record.set("lastestdate", latestDate);
        record.set("overdueday", (Object)overDueDay);
        record.set("overdueamt", (Object)overDueAmt);
    }
}

