/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StringUtils;

public class SendMsgHelper {
    private static final Log logger = LogFactory.getLog(SendMsgHelper.class);

    public static void sendMsgPrepare(List<Long> receivers, String channels, DynamicObject collectionTpl, DynamicObject record, String userType, DynamicObject actionObjEntry) {
        try {
            logger.info("SendMsgHelper sendMsgbegin , dcm_collrecord is " + record, (Object)("userType is " + userType + "receiverids" + receivers));
            String userName = RequestContext.get().getUserName();
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setType("message");
            messageInfo.setTitle(ResManager.loadKDString((String)"\u50ac\u6536\u6d88\u606f\u6765\u4fe1\uff01", (String)"SendMsgHelper_0", (String)"fi-ar-common", (Object[])new Object[0]));
            messageInfo.setSenderName(userName);
            messageInfo.setSendTime(new Date());
            if (CollectionUtils.isNotEmpty(receivers)) {
                messageInfo.setUserIds(receivers);
            } else {
                messageInfo = SendMsgHelper.wrapMessageParam(messageInfo, channels, actionObjEntry);
            }
            messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb\uff01", (String)"SendMsgHelper_1", (String)"fi-ar-common", (Object[])new Object[0]));
            messageInfo.setNotifyType(channels);
            messageInfo = SendMsgHelper.sendContentByType(messageInfo, userType, collectionTpl, record, actionObjEntry);
            SendMsgHelper.sendMsg(messageInfo, userType);
            logger.info("SendMsgHelper sendMsgend , dcm_collrecord is " + record, (Object)("userType is " + userType + "receiverids" + receivers));
        }
        catch (Exception e) {
            logger.info("SendMsgHelper sendMsgfail, dcm_collrecord is " + record, (Object)("userType is " + userType));
            logger.info("SendMsgHelper running exception " + e.getMessage());
            throw e;
        }
    }

    private static void sendMsg(MessageInfo messageInfo, String userType) {
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static MessageInfo wrapMessageParam(MessageInfo messageInfo, String channels, DynamicObject actionObjEntity) {
        HashMap pm = new HashMap();
        ArrayList<String> sendInfo = new ArrayList<String>();
        switch (channels) {
            case "sms": {
                String phone = actionObjEntity.getString("guestphone");
                if (StringUtils.isNotBlank(phone)) {
                    sendInfo.add(phone);
                }
                pm.put("phone", sendInfo);
                break;
            }
            case "email": {
                String email = actionObjEntity.getString("guestemail");
                if (StringUtils.isNotBlank(email)) {
                    sendInfo.add(email);
                }
                pm.put("email", sendInfo);
                break;
            }
            default: {
                return messageInfo;
            }
        }
        messageInfo.setParams(pm);
        return messageInfo;
    }

    private static MessageInfo sendContentByType(MessageInfo messageInfo, String userType, DynamicObject collectionTpl, DynamicObject record, DynamicObject actionObjEntry) {
        String clientFullContextPath = RequestContext.get().getClientFullContextPath();
        messageInfo.setEntityNumber("dcm_collrecord");
        messageInfo.setTemplateNumber(EmptyUtils.isEmpty(collectionTpl) ? "" : collectionTpl.getString("number"));
        messageInfo.setBizDataId(Long.valueOf(record.getLong("id")));
        if ("inner".equals(userType)) {
            String linkPath = String.format("%s/ierp/index.html?formId=%s&pkId=%s", clientFullContextPath, "dcm_collrecord", record.getLong("id"));
            messageInfo.setContentUrl(linkPath);
        }
        return messageInfo;
    }
}

