/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.common.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dcm.common.task.TaskContext;
import kd.fi.dcm.common.task.TaskResult;
import kd.fi.dcm.common.task.TaskService;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StringUtils;

public abstract class AbstractTaskService
implements TaskService {
    public static final Log log = LogFactory.getLog(AbstractTaskService.class);
    protected TaskContext taskContext;
    protected TaskResult taskResult;

    public AbstractTaskService(TaskContext taskContext, TaskResult taskResult) {
        this.taskContext = taskContext;
        this.taskResult = taskResult;
    }

    public void createNewTask(String taskClassName) {
        JobInfo JobInfo2 = new JobInfo();
        JobInfo2.setAppId("dcm");
        JobInfo2.setJobType(JobType.REALTIME);
        JobInfo2.setName("test job");
        JobInfo2.setId(this.taskContext.getTaskId());
        JobInfo2.setTaskClassname(taskClassName);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taskContext", this.taskContext);
        params.put("taskResult", this.taskResult);
        JobInfo2.setParams(params);
        JobClient.dispatch((JobInfo)JobInfo2);
    }

    public void printErrorLog(String msg) {
        List<String> msgs = this.taskResult.getMsgs();
        msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a\u8c03\u5ea6\u4efb\u52a1ID[%s],", (String)"AbstractTaskService_0", (String)"fi-dcm-common", (Object[])new Object[0]), this.taskContext.getTaskId()) + msg;
        msgs.add(msg);
        this.taskResult.setMsgs(msgs);
        log.error(msg);
    }

    public void printInfoLog(String msg) {
        StringBuilder builder = new StringBuilder();
        builder.append(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a", (String)"AbstractTaskService_1", (String)"fi-dcm-common", (Object[])new Object[0]));
        builder.append(msg);
        log.info(builder.toString());
    }

    public DynamicObjectCollection getCollRecordBills(int flag, Boolean isAudit) {
        ArrayList<QFilter> recordQFilters = new ArrayList<QFilter>(1);
        if (1 == flag) {
            recordQFilters.add(new QFilter("srcentry.e_isclose", "=", (Object)Boolean.TRUE));
        } else if (2 == flag) {
            recordQFilters.add(new QFilter("srcentry.e_isclose", "=", (Object)Boolean.FALSE));
        }
        if (Boolean.TRUE.equals(isAudit)) {
            recordQFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        if (EmptyUtils.isNotEmpty(this.taskContext.getStartDate())) {
            recordQFilters.add(new QFilter("createtime", ">=", (Object)this.taskContext.getStartDate()));
        }
        DynamicObjectCollection recordBills = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), "dcm_collrecord", StringUtils.join(this.getCollRecordSeleteField()), recordQFilters.toArray(new QFilter[0]), "createtime asc", this.taskContext.getSelectNum());){
            recordBills = orm.toPlainDynamicObjectCollection(ds);
        }
        return recordBills;
    }

    protected void getSrcBillEntity() {
        String billEntityNumber;
        DynamicObject[] recordStrategys = this.taskContext.getRecordStrategys();
        if (EmptyUtils.isEmpty(recordStrategys)) {
            DynamicObject strategy = QueryServiceHelper.queryOne((String)"dcm_recordstrategy", (String)"billentity", null);
            billEntityNumber = StringUtils.toSafeString(strategy.getString("billentity"));
        } else {
            DynamicObject strategy = recordStrategys[0];
            billEntityNumber = StringUtils.toSafeString(strategy.getDynamicObject("billentity").getPkValue());
        }
        if (StringUtils.isBlank(billEntityNumber)) {
            String msg = String.format(ResManager.loadKDString((String)"\u6863\u6848\u62bd\u53d6\u89c4\u5219[%s]\u672a\u914d\u7f6e[\u5355\u636e\u7c7b\u578b],\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"BillToRecordServiceImpl_0", (String)"fi-dcm-business", (Object[])new Object[0]), recordStrategys[0].get("billno"));
            this.printErrorLog(msg);
            return;
        }
        this.taskContext.setSrcBillEntity(billEntityNumber);
    }

    public void getRecordStrategys(Boolean isCheckFilter) {
        Object[] recordStrategys;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        if (Boolean.TRUE.equals(isCheckFilter)) {
            qFilterList.add(new QFilter("status", "=", (Object)"C"));
            qFilterList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (CollectionUtils.isEmpty(recordStrategys = BusinessDataServiceHelper.load((String)"dcm_recordstrategy", (String)StringUtils.join(this.getRecordStgySelectField()), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"createtime asc"))) {
            return;
        }
        this.taskContext.setRecordStrategys((DynamicObject[])recordStrategys);
    }

    public void getActionStrategys(Boolean flag) {
        Set<Long> orgIds;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        if (Boolean.TRUE.equals(flag)) {
            qFilterList.add(new QFilter("status", "=", (Object)"C"));
            qFilterList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if ((orgIds = this.taskContext.getOrgIds()) != null) {
            qFilterList.add(new QFilter("org.id", "in", orgIds));
        }
        Map strategyCollection = BusinessDataServiceHelper.loadFromCache((String)"dcm_actionstrategy", (QFilter[])qFilterList.toArray(new QFilter[0]));
        Date now = new Date();
        ArrayList<DynamicObject> exeStrategy = new ArrayList<DynamicObject>(10);
        for (DynamicObject strategy : strategyCollection.values()) {
            Date lastDate = strategy.getDate("lastexetime");
            if (EmptyUtils.isNotEmpty(lastDate)) {
                int days;
                int cycle = strategy.getInt("executecycle");
                if (cycle > (days = DateUtils.getDiffDays(lastDate, new Date()))) continue;
                strategy.set("lastexetime", (Object)now);
                exeStrategy.add(strategy);
                continue;
            }
            strategy.set("lastexetime", (Object)now);
            exeStrategy.add(strategy);
        }
        if (CollectionUtils.isNotEmpty(exeStrategy)) {
            SaveServiceHelper.update((DynamicObject[])exeStrategy.toArray(new DynamicObject[0]));
            this.taskContext.setActionStrategys(exeStrategy.toArray(new DynamicObject[0]));
        }
    }

    protected void invokeRecordSave(Set<Long> recordIds) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"dcm_collrecord", (Object[])recordIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6\u66f4\u65b0[\u8868\u5934\u5b57\u6bb5\u5904\u7406\u6210\u529f],\u6210\u529f\u5904\u7406[%s]\u5f20\u5355\u636e,\u5355\u636eID[%s]", (String)"RecordUpdateHelper_2", (String)"fi-dcm-common", (Object[])new Object[0]), operationResult.getSuccessPkIds().size(), operationResult.getSuccessPkIds());
            this.printInfoLog(msg);
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6\u66f4\u65b0[\u8868\u5934\u5b57\u6bb5\u5904\u7406\u5931\u8d25],\u5931\u8d25\u539f\u56e0[%s]", (String)"RecordUpdateHelper_3", (String)"fi-dcm-common", (Object[])new Object[0]), operationResult.getMessage());
            this.printErrorLog(msg);
        }
    }

    public List<String> getRecordStgySelectField() {
        ArrayList<String> selectField = new ArrayList<String>(1);
        selectField.add("id");
        selectField.add("name");
        selectField.add("amtdownlimit");
        selectField.add("amtuplimit");
        selectField.add("amtfield");
        selectField.add("daysdownlimit");
        selectField.add("daysuplimit");
        selectField.add("datefield");
        selectField.add("useorg");
        selectField.add("morefilerdesc");
        selectField.add("morefilerval");
        selectField.add("ruleid");
        selectField.add("morefilerval_tag");
        selectField.add("closerecordfilterval_tag");
        selectField.add("billentity.number");
        selectField.add("writebackfield");
        selectField.add("groupentry.e_rulename");
        selectField.add("groupentry.e_policy");
        selectField.add("groupentry.e_fieldname");
        selectField.add("groupentry.e_fieldvalue");
        selectField.add("groupentry.e_targerfield");
        selectField.add("groupentry.e_ruleid");
        selectField.add("ctrlstrategy");
        return selectField;
    }

    public List<String> getCollRecordSeleteField() {
        ArrayList<String> selectField = new ArrayList<String>(1);
        selectField.add("id");
        selectField.add("createtime");
        selectField.add("srcentry.id entryId");
        selectField.add("srcentry.e_isclose isClose");
        selectField.add("srcentry.e_billentity billEntity");
        selectField.add("srcentry.e_srcbillid srcBillId");
        selectField.add("srcentry.e_srcentryid srcEntryId");
        selectField.add("srcentry.e_srcentryentity srcEntryEntity");
        selectField.add("srcentry.e_recordstrategy.id recordStrategyId");
        selectField.add("srcentry.e_botpruleid botpRuleId");
        selectField.add("srcentry.e_srcamount srcAmount");
        selectField.add("srcentry.e_srcoveramount srcOverAmount");
        selectField.add("srcentry.id");
        return selectField;
    }
}

