/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.common.util;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CheckMessage;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StringUtils;

public class ConditionUtils {
    private IFormView view;
    private AbstractFormPlugin plugin;

    public ConditionUtils() {
    }

    public ConditionUtils(IFormView view, AbstractFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
    }

    public void showConditionForm(String entityNumber, boolean onlyHeadFields, String closeCallBackActionId, String sourceCtrlVal) {
        String conditionJson = (String)this.view.getModel().getValue(sourceCtrlVal + "_tag");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
        String fieldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.view.showForm(showParameter);
    }

    public void closeCallBackHandle(ClosedCallBackEvent closedCallBackEvent, String closeCallBackActionId, String billEntityName, String conditionValEntity) {
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData) || !actionId.equals(closeCallBackActionId)) {
            return;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        CheckResult checkResult = new CheckResult();
        if (!checkResult.isPass()) {
            this.view.showErrorNotification(((CheckMessage)checkResult.getMessages().get(0)).getMessage());
            return;
        }
        this.view.getModel().setValue(conditionValEntity + "_tag", (Object)returnData);
        String exprDesc = condition.getExprDesc();
        this.view.getModel().setValue(actionId, (Object)(exprDesc.length() > 255 ? exprDesc.substring(0, 255) : exprDesc));
    }

    public QFilter buildQFilter(String conditionVal, String billEntityName) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionVal, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        QFilter qfilter = filterBuilder.getQFilter();
        if (StringUtils.isNotBlank(condition.getExpression())) {
            QFilter of = QFilter.of((String)condition.getExpression(), (Object[])new Object[0]);
            qfilter = EmptyUtils.isEmpty(qfilter) ? of : qfilter.and(of);
        }
        return qfilter;
    }
}

