/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.dcm.common.consts.StrategyLimitValue;
import kd.fi.dcm.common.util.ConditionUtils;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StringUtils;

public class StrategyFilterUtils {
    public static List<QFilter> buildStrategyFilters(DynamicObject strategy) {
        QFilter baseDataFilter;
        QFilter qFilter;
        if (EmptyUtils.isEmpty(strategy) || strategy.getDynamicObject("billentity") == null || StringUtils.isBlank(StringUtils.toSafeString(strategy.getDynamicObject("billentity").getPkValue()))) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        String amtField = strategy.getString("amtfield");
        String dateField = strategy.getString("datefield");
        if (EmptyUtils.isNotEmpty(amtField)) {
            BigDecimal amtDownLimit = strategy.getBigDecimal("amtdownlimit");
            BigDecimal amtUpLimit = strategy.getBigDecimal("amtuplimit");
            if (StrategyLimitValue.MinAmtValue.compareTo(amtDownLimit) != 0 && StrategyLimitValue.MaxAmtValue.compareTo(amtUpLimit) != 0) {
                if (amtDownLimit.compareTo(amtUpLimit) == 0) {
                    filters.add(new QFilter(amtField, "=", (Object)amtDownLimit));
                } else {
                    filters.add(new QFilter(amtField, ">=", (Object)amtDownLimit));
                    filters.add(new QFilter(amtField, "<=", (Object)amtUpLimit));
                }
            }
            if (StrategyLimitValue.MinAmtValue.compareTo(amtDownLimit) == 0 && StrategyLimitValue.MaxAmtValue.compareTo(amtUpLimit) != 0) {
                filters.add(new QFilter(amtField, "<", (Object)amtUpLimit));
            }
            if (StrategyLimitValue.MinAmtValue.compareTo(amtDownLimit) != 0 && StrategyLimitValue.MaxAmtValue.compareTo(amtUpLimit) == 0) {
                filters.add(new QFilter(amtField, ">=", (Object)amtDownLimit));
            }
        }
        if (EmptyUtils.isNotEmpty(dateField)) {
            Date uplimit;
            int daysDownLimit = strategy.getInt("daysdownlimit");
            int daysUpLimit = strategy.getInt("daysuplimit");
            Date date = DateUtils.getDataFormat(new Date(), true);
            if (StrategyLimitValue.MinDayValue != daysDownLimit && StrategyLimitValue.MaxDayValue != daysUpLimit) {
                uplimit = DateUtils.getLastDay(date, daysUpLimit);
                Date downlimit = DateUtils.getLastDay(date, daysDownLimit);
                downlimit = DateUtils.getDataFormat(downlimit, false);
                filters.add(new QFilter(dateField, "<=", (Object)downlimit));
                filters.add(new QFilter(dateField, ">=", (Object)uplimit));
            }
            if (StrategyLimitValue.MinDayValue == daysDownLimit && StrategyLimitValue.MaxDayValue != daysUpLimit) {
                uplimit = DateUtils.getLastDay(date, daysUpLimit);
                filters.add(new QFilter(dateField, ">=", (Object)uplimit));
            }
            if (StrategyLimitValue.MinDayValue != daysDownLimit && StrategyLimitValue.MaxDayValue == daysUpLimit) {
                Date downlimit = DateUtils.getLastDay(date, daysDownLimit);
                downlimit = DateUtils.getDataFormat(downlimit, false);
                filters.add(new QFilter(dateField, "<=", (Object)downlimit));
            }
        }
        ConditionUtils conditionUtils = new ConditionUtils();
        String srcBillName = strategy.getString("billentity.number");
        String filterJson = strategy.getString("morefilerval_tag");
        if (EmptyUtils.isNotEmpty(filterJson) && EmptyUtils.isNotEmpty(qFilter = conditionUtils.buildQFilter(filterJson, srcBillName))) {
            filters.add(qFilter);
        }
        if (EmptyUtils.isNotEmpty(baseDataFilter = StrategyFilterUtils.getBaseDataFilter(strategy))) {
            filters.add(baseDataFilter);
        }
        return filters;
    }

    private static QFilter getBaseDataFilter(DynamicObject strategy) {
        String ctrlStrategy;
        QFilter filter = null;
        if (EmptyUtils.isEmpty(strategy)) {
            return filter;
        }
        String entityId = FormMetadataCache.getFormConfig((String)strategy.getDataEntityType().getName()).getEntityTypeId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
        String baseDataTableName = dt.getAlias();
        Long useOrgId = (Long)strategy.getDynamicObject("useorg").getPkValue();
        switch (ctrlStrategy = strategy.getString("ctrlstrategy")) {
            case "5": {
                break;
            }
            case "7": {
                filter = new QFilter("org", "=", (Object)useOrgId);
                break;
            }
            case "1": 
            case "2": {
                String dataBaseUsingTableName = baseDataTableName + "UseReg";
                Set userOrgIds = (Set)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)("select fuseorgid from " + dataBaseUsingTableName + " where fdataid =" + strategy.getPkValue()), (Object[])new Object[0], e -> {
                    HashSet<Long> idSet = new HashSet<Long>(128);
                    while (e.next()) {
                        idSet.add(e.getLong("fuseorgid"));
                    }
                    return idSet;
                });
                filter = new QFilter("org", "in", (Object)userOrgIds);
                break;
            }
            case "6": {
                DynamicObject ctrlview = null;
                DynamicObject[] baseDataView = BusinessDataServiceHelper.load((String)"bd_basedataview", (String)"ctrlview.treetype", (QFilter[])new QFilter[]{new QFilter("basedata", "=", (Object)entityId)});
                if (null == baseDataView || baseDataView.length == 0) {
                    DynamicObject[] defaultCtrlStrategy = BusinessDataServiceHelper.load((String)"bd_bddefctrlstrtgy", (String)"ctrlview.treetype", (QFilter[])new QFilter[]{new QFilter("basedataid", "=", (Object)entityId)});
                    if (null != defaultCtrlStrategy && defaultCtrlStrategy.length > 0) {
                        ctrlview = defaultCtrlStrategy[0].getDynamicObject("ctrlview");
                    }
                } else {
                    ctrlview = baseDataView[0].getDynamicObject("ctrlview");
                }
                if (ctrlview == null) break;
                List<Long> allOrgList = StrategyFilterUtils.getSubordinateOrgList((Long)ctrlview.getPkValue(), useOrgId);
                filter = new QFilter("org", "in", allOrgList);
            }
        }
        return filter;
    }

    private static List<Long> getSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        ArrayList<Long> subOrgIds = new ArrayList<Long>(1);
        QFilter f1 = new QFilter("view.id", "=", (Object)orgViewId);
        QFilter f2 = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter f3 = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        DynamicObject parentOrgView = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,longnumber,org", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)parentOrgId), f1, f2, f3});
        if (EmptyUtils.isEmpty(parentOrgView.getString("longnumber"))) {
            return subOrgIds;
        }
        QFilter f4 = new QFilter("longnumber", "like", (Object)(parentOrgView.getString("longnumber") + "!%"));
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"id,org.id", (QFilter[])new QFilter[]{f1, f2, f3, f4});
        for (DynamicObject org : orgs) {
            subOrgIds.add(org.getLong("org.id"));
        }
        subOrgIds.add(parentOrgId);
        return subOrgIds;
    }
}

