/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.EmptyUtils;

public class DcmActionSaveAndSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("strategyid");
        list.add("sourcebillid");
        list.add("sourceentryid");
        list.add("isautopush");
        list.add("billstatus");
        list.add("billhead_lk_sid");
        list.add("billhead_lk_stableid");
        list.add("billhead_lk_sbillid");
        list.add("e_backdate");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.changeRelationShip(dataEntities);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject action : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection actionEntry = action.getDynamicObjectCollection("backentry");
            if (CollectionUtils.isNotEmpty((Collection)actionEntry)) {
                Collections.sort(actionEntry, new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        return o1.getDate("e_backdate").after(o2.getDate("e_backdate")) ? 1 : -1;
                    }
                });
                for (int i = 0; i < actionEntry.size(); ++i) {
                    int index = i + 1;
                    ((DynamicObject)actionEntry.get(i)).set("seq", (Object)index);
                }
            }
            action.set("backentry", (Object)actionEntry);
        }
    }

    private void changeRelationShip(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> handPushActions = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject action : dataEntities) {
            if (EmptyUtils.isEmpty((Object)action.get("sourcebillid")) || EmptyUtils.isNotEmpty((Object)action.get("sourceentryid")) || action.getBoolean("isautopush")) continue;
            handPushActions.add(action);
        }
        if (EmptyUtils.isNotEmpty(handPushActions)) {
            List srcIds = handPushActions.stream().map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"dcm_collrecord", (String)String.join((CharSequence)",", this.getRecordSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)});
            Map<Object, DynamicObject> recordMap = Arrays.stream(records).collect(Collectors.toMap(DataEntityBase::getPkValue, bill -> bill));
            DynamicObjectType entryType = (DynamicObjectType)records[0].getDataEntityType();
            DynamicObjectType entryType1 = ((EntryProp)entryType.getProperty("actiondetailentry")).getDynamicCollectionItemPropertyType();
            ArrayList<DynamicObject> toSaveRecord = new ArrayList<DynamicObject>(records.length);
            for (DynamicObject handPushAction : handPushActions) {
                Long sourceBillId = handPushAction.getLong("sourcebillid");
                DynamicObject record = recordMap.get(sourceBillId);
                int seq = this.getLargeSeq(record);
                DynamicObject row = new DynamicObject(entryType1);
                row.set("seq", (Object)(++seq));
                row.set("ac_actionbillno", (Object)"2481043411950800");
                record.getDynamicObjectCollection("actiondetailentry").add((Object)row);
                toSaveRecord.add(record);
            }
            if (EmptyUtils.isNotEmpty(toSaveRecord)) {
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])toSaveRecord.toArray(new DynamicObject[0]));
                        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)"dcm_collrecord", (String)"actiondetailentry");
                        Long srcTableId = tableDefine.getTableId();
                        for (DynamicObject handPushAction : handPushActions) {
                            Long sourceBillId = handPushAction.getLong("sourcebillid");
                            DynamicObject record = recordMap.get(sourceBillId);
                            DynamicObjectCollection actionDetailEntry = record.getDynamicObjectCollection("actiondetailentry");
                            List newRow = actionDetailEntry.stream().filter(ac -> "2481043411950800".equals(ac.getString("ac_actionbillno"))).collect(Collectors.toList());
                            if (newRow == null || newRow.size() != 1) continue;
                            DynamicObjectCollection billHeadLk = handPushAction.getDynamicObjectCollection("billhead_lk");
                            ((DynamicObject)billHeadLk.get(0)).set("billhead_lk_stableid", (Object)srcTableId);
                            ((DynamicObject)billHeadLk.get(0)).set("billhead_lk_sid", ((DynamicObject)newRow.get(0)).getPkValue());
                            ((DynamicObject)billHeadLk.get(0)).set("billhead_lk_sbillid", handPushAction.get("sourcebillid"));
                            handPushAction.set("sourceentryid", ((DynamicObject)newRow.get(0)).getPkValue());
                        }
                    }
                    catch (Exception exception) {
                        txHandle.markRollback();
                        throw exception;
                    }
                }
            }
        }
    }

    private int getLargeSeq(DynamicObject bill) {
        int seq = 0;
        DynamicObjectCollection actionDetailEntry = bill.getDynamicObjectCollection("actiondetailentry");
        for (DynamicObject row : actionDetailEntry) {
            int acSeq = row.getInt("seq");
            seq = Math.max(seq, acSeq);
        }
        return seq;
    }

    private List<String> getRecordSelector() {
        ArrayList<String> selector = new ArrayList<String>(128);
        selector.add("actiondetailentry");
        selector.add("actiondetailentry.seq");
        selector.add("actiondetailentry.ac_actionbillno");
        selector.add("actiondetailentry.ac_collectiondate");
        selector.add("actiondetailentry.ac_collectionmethod");
        selector.add("actiondetailentry.ac_collectionbackamt");
        selector.add("actiondetailentry.ac_overdueamt");
        selector.add("actiondetailentry.ac_currency");
        selector.add("actiondetailentry.ac_innerposition");
        selector.add("actiondetailentry.ac_inneruser");
        selector.add("actiondetailentry.ac_guestposition");
        selector.add("actiondetailentry.ac_guestuser");
        selector.add("actiondetailentry.ac_directions");
        selector.add("actiondetailentry.ac_actiontbillid");
        selector.add("actiondetailentry.ac_actioncreatedate");
        selector.add("actiondetailentry.ac_strategyid");
        selector.add("actiondetailentry.ac_strategyentryid");
        selector.add("actiondetailentry.ac_ispush");
        selector.add("actiondetailentry.ac_guestphone");
        selector.add("actiondetailentry.ac_guestemail");
        selector.add("actiondetailentry.ac_earlistdate");
        selector.add("actiondetailentry.ac_lastestdate");
        selector.add("actiondetailentry.ac_overduereason");
        selector.add("actiondetailentry.ac_overduereason");
        return selector;
    }
}

