/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.fi.dcm.common.util.DateUtils;

public class DcmRecordSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("id");
        list.add("srcentry");
        list.add("e_isclose");
        list.add("e_srcoveramount");
        list.add("e_srcduedate");
        list.add("earlistdate");
        list.add("lastestdate");
        list.add("overdueday");
        list.add("overdueamt");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] entities;
        for (DynamicObject obj : entities = e.getDataEntities()) {
            this.entrySummary(obj);
        }
    }

    private void entrySummary(DynamicObject record) {
        DynamicObjectCollection srcentry = record.getDynamicObjectCollection("srcentry");
        if (srcentry == null || srcentry.size() == 0) {
            return;
        }
        Date earlistDate = null;
        Date latestDate = null;
        int overDueDay = 0;
        BigDecimal overDueAmt = BigDecimal.ZERO;
        for (DynamicObject row : srcentry) {
            boolean isClose = row.getBoolean("e_isclose");
            if (isClose) continue;
            BigDecimal eSrcOverAmount = row.getBigDecimal("e_srcoveramount");
            overDueAmt = overDueAmt.add(eSrcOverAmount);
            Date e_srcduedate = row.getDate("e_srcduedate");
            if (e_srcduedate == null) continue;
            if (earlistDate == null) {
                earlistDate = e_srcduedate;
            } else if (e_srcduedate.before(earlistDate)) {
                earlistDate = e_srcduedate;
            }
            if (latestDate == null) {
                latestDate = e_srcduedate;
                continue;
            }
            if (!e_srcduedate.after(latestDate)) continue;
            latestDate = e_srcduedate;
        }
        if (earlistDate != null) {
            overDueDay = DateUtils.getDiffDays(earlistDate, (Date)new Date());
        }
        record.set("earlistdate", earlistDate);
        record.set("lastestdate", latestDate);
        record.set("overdueday", (Object)overDueDay);
        record.set("overdueamt", (Object)overDueAmt);
    }
}

