/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.botp.convert;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.exception.KDBizException;
import kd.bos.mutex.DataMutex;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.BuildQueryParameterAction;
import kd.bos.service.botp.convert.actions.CompileRuleAction;
import kd.bos.service.botp.convert.actions.CreateConvertPlugAction;
import kd.bos.service.botp.convert.actions.CreateDependEntityRowsAction;
import kd.bos.service.botp.convert.actions.ExecuteBizRuleAction;
import kd.bos.service.botp.convert.actions.FillLinkInfoAction;
import kd.bos.service.botp.convert.actions.GroupSourceRowsAction;
import kd.bos.service.botp.convert.actions.InitializeAction;
import kd.bos.service.botp.convert.actions.LoadDependEntityRowsAction;
import kd.bos.service.botp.convert.actions.LoadFunctionTypesAction;
import kd.bos.service.botp.convert.actions.LoadSourceDataAction;
import kd.bos.service.botp.convert.actions.MappingDependFieldAction;
import kd.bos.service.botp.convert.actions.MappingFieldAction;
import kd.bos.service.botp.convert.actions.MergePushResultAction;
import kd.bos.service.botp.convert.actions.RunDataConditionAction;
import kd.bos.service.botp.convert.actions.RunRuleConditionAction;
import kd.bos.service.botp.convert.actions.SortSourceRowsAction;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.dcm.business.botp.convert.CRComparator;
import kd.fi.dcm.business.botp.convert.actions.CreateLinkEntityRowsAction;
import kd.fi.dcm.business.botp.convert.actions.CreateTargetBillAction;
import kd.fi.dcm.business.botp.convert.actions.PushHelper;
import kd.fi.dcm.common.task.BillAndRule;
import kd.fi.dcm.common.task.model.PushRecordDO;

public class ConvertEngine {
    private String ERROR_NOSOURCE = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6e90\u5355\u7c7b\u578b", (String)"ConvertEngine_0", (String)"bos-mservice-operation", (Object[])new Object[0]);
    private String ERROR_NOTARGET = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u76ee\u6807\u5355\u7c7b\u578b", (String)"ConvertEngine_1", (String)"bos-mservice-operation", (Object[])new Object[0]);
    private String ERROR_NODATA = ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e", (String)"ConvertEngine_2", (String)"bos-mservice-operation", (Object[])new Object[0]);
    private String MSG_NOMATCHRULE = ResManager.loadKDString((String)"\u65e0\u5339\u914d\u89c4\u5219", (String)"ConvertEngine_3", (String)"bos-mservice-operation", (Object[])new Object[0]);
    private List<AbstractConvertAction> pushActions;

    public ConvertOperationResult push(PushArgs args, PushRecordDO pushRecordDO) {
        try (TraceSpan span = Tracer.create((String)"ConvertEngine", (String)"push");){
            ConvertOperationResult convertOperationResult = this.doPush(args, pushRecordDO);
            return convertOperationResult;
        }
    }

    private ConvertOperationResult doPush(PushArgs args, PushRecordDO pushRecordDO) {
        ConvertOperationResult result = new ConvertOperationResult();
        result.setSourceEntityNumber(args.getSourceEntityNumber());
        result.setTargetEntityNumber(args.getTargetEntityNumber());
        result.setStartTime(new Date());
        if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NODATA);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOSOURCE);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOTARGET);
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        ConvertResultManager resultManager = this.createResultManager();
        this.initPushContext(context, resultManager, args);
        try {
            for (ConvertRuleElement rule : context.getRules()) {
                if (resultManager.isSkipNextRule()) continue;
                SingleRuleContext ruleContext = this.createRuleContext(context, rule);
                SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
                List<AbstractConvertAction> runAction = null;
                runAction = this.createPushActions(context, resultManager);
                for (AbstractConvertAction action : runAction) {
                    PushHelper.pushActionIntercept(action, pushRecordDO);
                    action.setRuleContext(ruleContext);
                    action.setRuleResultManager(ruleResultManager);
                    action.action();
                }
            }
            this.exportPushResult(context, resultManager, result);
        }
        catch (KDBizException exp) {
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
        }
        if (result.getCachePageIds().isEmpty()) {
            StringBuilder errMsg = new StringBuilder();
            this.releaseDataMutex(context.getSourceMainType().getName(), resultManager.getDataMutexSrcBillIds(), errMsg);
        } else {
            result.getDataMutexSrcBillIds().addAll(resultManager.getDataMutexSrcBillIds());
        }
        result.setFinishedTime(new Date());
        return result;
    }

    private ConvertContext createContext(AbstractConvertServiceArgs args) {
        ConvertContext context = new ConvertContext();
        context.setInputArgs(args);
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        BillEntityType tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getTargetEntityNumber());
        context.setSourceMainType(srcMainType);
        context.setTargetMainType(tgtMainType);
        List<ConvertRuleElement> rules = this.loadRules(context);
        if (args instanceof PushArgs && !((PushArgs)args).getRuleIds().isEmpty()) {
            for (ConvertRuleElement convertRuleElement : rules) {
                if (!((PushArgs)args).getRuleIds().contains(convertRuleElement.getId())) continue;
                context.getRules().add(convertRuleElement);
            }
        } else {
            context.getRules().addAll(rules);
        }
        if (args.getCustomParams() != null) {
            for (Map.Entry entry : args.getCustomParams().entrySet()) {
                context.getOption().setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return context;
    }

    private void initPushContext(ConvertContext context, ConvertResultManager resultManager, PushArgs args) {
        resultManager.getReporter().initBillAndRules(args.getSelectedRows());
        context.setConvertOpType(ConvertOpType.Push);
    }

    private SingleRuleContext createRuleContext(ConvertContext context, ConvertRuleElement rule) {
        SingleRuleContext ruleContext = new SingleRuleContext();
        ruleContext.setContext(context);
        ruleContext.setRule(rule);
        return ruleContext;
    }

    private List<ConvertRuleElement> loadRules(ConvertContext context) {
        if (StringUtils.isNotBlank((CharSequence)context.getInputArgs().getRuleId())) {
            ConvertRuleElement rule = ConvertRuleCache.loadRule((String)context.getInputArgs().getRuleId());
            if (!rule.isEnabled()) {
                return new ArrayList<ConvertRuleElement>();
            }
            ArrayList<ConvertRuleElement> rules = new ArrayList<ConvertRuleElement>();
            rules.add(rule);
            return rules;
        }
        String sourceEntityNumber = context.getInputArgs().getSourceEntityNumber();
        String targetEntityNumber = context.getInputArgs().getTargetEntityNumber();
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled() || !rule.isVisibled()) continue;
            enableRules.add(rule);
        }
        enableRules.sort(new CRComparator());
        return enableRules;
    }

    private ConvertResultManager createResultManager() {
        return new ConvertResultManager();
    }

    private SingleRuleResultManager createRuleResultManager(ConvertResultManager resultManager) {
        SingleRuleResultManager ruleResultManager = new SingleRuleResultManager();
        ruleResultManager.setConvertResultManager(resultManager);
        return ruleResultManager;
    }

    private List<AbstractConvertAction> createPushActions(ConvertContext context, ConvertResultManager resultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractConvertAction>(32);
            this.pushActions.add((AbstractConvertAction)new CreateConvertPlugAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new LoadFunctionTypesAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new InitializeAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new RunRuleConditionAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new CompileRuleAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new BuildQueryParameterAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new LoadSourceDataAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new LoadDependEntityRowsAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new RunDataConditionAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new SortSourceRowsAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new GroupSourceRowsAction(context, resultManager));
            this.pushActions.add(new CreateTargetBillAction(context, resultManager));
            this.pushActions.add(new CreateLinkEntityRowsAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new CreateDependEntityRowsAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new MappingDependFieldAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new MappingFieldAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new FillLinkInfoAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new ExecuteBizRuleAction(context, resultManager));
            this.pushActions.add((AbstractConvertAction)new MergePushResultAction(context, resultManager));
        }
        return this.pushActions;
    }

    private void exportPushResult(ConvertContext context, ConvertResultManager resultManager, ConvertOperationResult operationResult) {
        this.updateConvertReport(resultManager.getReporter(), operationResult);
        List targetDataObjects = resultManager.getTargetDataObjects();
        if (!targetDataObjects.isEmpty()) {
            operationResult.addTargetDataObjects((objs, dt) -> BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dt), (MainEntityType)context.getTargetMainType(), targetDataObjects);
            operationResult.setSuccess(true);
        }
        if (!resultManager.getTargetBillIds().isEmpty()) {
            HashSet billIds = new HashSet(resultManager.getTargetBillIds());
            operationResult.getTargetBillIds().addAll(billIds);
            operationResult.setSuccess(true);
        }
        if (operationResult.getTargetBillIds().isEmpty() && operationResult.getCachePageIds().isEmpty()) {
            operationResult.setSuccess(false);
        }
    }

    private void updateConvertReport(ConvertReportManager reportManager, ConvertOperationResult operationResult) {
        boolean hasMatchRule = false;
        String billAndRulesJsonStr = JSONObject.toJSONString((Object)reportManager.getBillAndRules());
        List billAndRules = JSONObject.parseArray((String)billAndRulesJsonStr, BillAndRule.class);
        for (BillAndRule bill : billAndRules) {
            if (StringUtils.isBlank((CharSequence)bill.getRuleId())) {
                reportManager.failBill(bill.getBillId(), this.MSG_NOMATCHRULE);
                continue;
            }
            hasMatchRule = true;
        }
        if (!hasMatchRule) {
            operationResult.setSuccess(false);
            operationResult.setMessage(this.MSG_NOMATCHRULE);
        } else if (!reportManager.getBreakMessages().isEmpty()) {
            operationResult.setSuccess(false);
            operationResult.setMessage((String)reportManager.getBreakMessages().entrySet().iterator().next().getValue());
        }
        for (SourceBillReport billReport : reportManager.getBillReports()) {
            billReport.copyReportToList();
            operationResult.getBillReports().add(billReport);
        }
        if (operationResult.getBillReports().size() > 200) {
            for (SourceBillReport billReport : operationResult.getBillReports()) {
                billReport.getLinkEntityRowReports().clear();
                billReport.getDependEntityRowReports().clear();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean releaseDataMutex(String srcEntityNumber, Set<String> srcBillIds, StringBuilder errMsg) {
        if (srcBillIds.isEmpty()) {
            return true;
        }
        ArrayList mutexRequireList = new ArrayList(10);
        for (String billId : srcBillIds) {
            HashMap<String, String> requireParam = new HashMap<String, String>(16);
            requireParam.put("dataObjId", billId);
            requireParam.put("groupId", "default_netctrl");
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "botp_convert");
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            Map releaseResult = dataMutex.batchRelease(mutexRequireList);
            for (Map.Entry releaseItem : releaseResult.entrySet()) {
                boolean releaseRet = (Boolean)releaseItem.getValue();
                if (!releaseRet) continue;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            errMsg.append(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519: ", (String)"ConvertEngine_4", (String)"bos-mservice-operation", (Object[])new Object[0])).append(e.getMessage());
            return false;
        }
    }
}

