/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.report.IBuildDetailReport;
import kd.bos.service.business.datamodel.BillTypeDefValueProvider;
import kd.bos.service.business.datamodel.DrawDataModel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.dcm.common.task.model.PushRecordDO;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.EmptyUtils;

public class CreateTargetBillAction
extends AbstractConvertAction {
    private static final String DEFAULT_BILLTYPE_ID = "DEFAULT_BILLTYPE_ID";
    private DrawDataModel modelProxy;
    private Map<String, DynamicObject> blankDataEntitys = new HashMap<String, DynamicObject>();
    private LinkEntityMap linkEntityMap;
    private IBuildDetailReport buildReport = null;
    private BillEntityType targetMainType = null;
    private IMappingField mappingMainOrg = null;
    private MainOrgProp mainOrgProp = null;
    private Long defOrgId = null;
    private HasPermOrgResult permOrgResult = null;
    private IMappingField mappingBillType = null;
    private IGetValueMode srcBillTypeReader = null;
    private BillTypeProp billTypeProp = null;
    private Map<Object, DynamicObject> targetBillTypeObjs = null;
    private BillTypeMapParser billTypeMapParser = null;
    private Map<Object, Object> customerMap = new HashMap<Object, Object>(2);

    public Map<Object, Object> getCustomerMap() {
        return this.customerMap;
    }

    public void setCustomerMap(Map<Object, Object> customerMap) {
        this.customerMap = customerMap;
    }

    private boolean isHasRight() {
        if (this.getContext().getOption().containsVariable("botp_hasright")) {
            String hasRight = this.getContext().getOption().getVariableValue("botp_hasright", String.valueOf(false));
            if (StringUtils.isBlank((CharSequence)hasRight)) {
                return ((PushArgs)this.getContext().getInputArgs()).isHasRight();
            }
            return Boolean.parseBoolean(hasRight);
        }
        return ((PushArgs)this.getContext().getInputArgs()).isHasRight();
    }

    private Object getBlankDataEntity(IDataModel model) {
        Object billTypeId;
        Object mainOrgId = this.mainOrgProp == null ? null : model.getContextVariable(this.mainOrgProp.getName());
        String key = String.format("%s_%s", mainOrgId, billTypeId = this.billTypeProp == null ? null : model.getContextVariable(DEFAULT_BILLTYPE_ID));
        if (!this.blankDataEntitys.containsKey(key)) {
            model.beginInit();
            model.createNewData();
            model.clearNoDataRow();
            model.endInit();
            this.blankDataEntitys.put(key, model.getDataEntity());
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)this.blankDataEntitys.get(key)), (boolean)false, (boolean)true);
    }

    private void initVar() {
        this.modelProxy = this.getModelProxy();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        EntityType srcLinkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(this.linkEntityMap.getSourceLinkEntityKey());
        this.buildReport = this.ruleContext.getSrcRowReportBuilder(srcLinkEntity);
        this.targetMainType = this.context.getTargetMainType();
        this.mappingMainOrg = this.linkEntityMap.getMappingMainOrg();
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            this.mainOrgProp = (MainOrgProp)this.targetMainType.getProperty(this.targetMainType.getMainOrg());
        }
        this.mappingBillType = this.linkEntityMap.getMappingBillType();
        this.srcBillTypeReader = this.linkEntityMap.getSrcBillTypeReader();
        for (IDataEntityProperty property : this.targetMainType.getProperties()) {
            if (!(property instanceof BillTypeProp)) continue;
            this.billTypeProp = (BillTypeProp)property;
            break;
        }
        this.billTypeMapParser = new BillTypeMapParser();
        this.targetBillTypeObjs = this.loadBillTypeObjs();
    }

    public CreateTargetBillAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    protected void doAction() {
        super.doAction();
        this.initVar();
        SourceRowsGroup group = this.getSourceRowsGroupRoot();
        ExtendedDataEntitySet targetExtSet = new ExtendedDataEntitySet();
        int dataEntityIndex = 0;
        this.modelProxy.beginInit();
        ArrayList<ExtendedDataEntity> headExtEntitys = new ArrayList<ExtendedDataEntity>(group.getChildGroupList().size());
        for (SourceRowsGroup srcBillGroup : group.getChildGroupList()) {
            SourceRowsGroupKey srcBillGroupKey = srcBillGroup.getGroupKey();
            if (!this.createNewData(srcBillGroup)) continue;
            DynamicObject headObj = this.modelProxy.getDataEntity();
            headObj.getDataEntityState().setPushChanged(true);
            ExtendedDataEntity headExtEntity = new ExtendedDataEntity(headObj, dataEntityIndex, 0);
            headExtEntity.setValue("ConvertSource", (Object)srcBillGroup.getSourceRows());
            if (this.modelProxy.getDataEntity() != null && this.modelProxy.getDataEntity().getLong("id") != 0L) {
                headExtEntity.setValue("isNewEntity", (Object)Boolean.FALSE);
            } else {
                headExtEntity.setValue("isNewEntity", (Object)Boolean.TRUE);
            }
            headExtEntity.setValue("SourceRowsGroupKey", (Object)srcBillGroupKey);
            headExtEntitys.add(headExtEntity);
            ++dataEntityIndex;
        }
        this.modelProxy.endInit();
        targetExtSet.AddExtendedDataEntities(this.targetMainType.getName(), headExtEntitys);
        this.setTargetExtendedDataEntities(targetExtSet);
    }

    private boolean createNewData(SourceRowsGroup srcBillGroup) {
        StringBuilder errMessage = new StringBuilder();
        Boolean merge = (Boolean)this.getCustomerMap().get("merge");
        if (!merge.booleanValue()) {
            return this.createNewData(srcBillGroup, errMessage);
        }
        ConvertRuleElement convertRuleElement = this.ruleContext.getRule();
        GroupByPolicy groupByPolicy = convertRuleElement.getGroupByPolicy();
        if (groupByPolicy.getGroupByMode().getValue() != GroupByMode.GroupByField.getValue()) {
            return false;
        }
        PushRecordDO pushRecordDO = (PushRecordDO)this.getCustomerMap().get("pushRecordDO");
        DynamicObject recordStrategy = pushRecordDO.getRecordStrategy();
        ListSelectedRow listSelectedRow = (ListSelectedRow)this.ruleContext.getSelectedRows().get(0);
        String[] fields = groupByPolicy.getGroupByField().split(",");
        DynamicObject sourceBill = null;
        if (EmptyUtils.isEmpty((Object)listSelectedRow.getPrimaryKeyValue())) {
            QFilter filter = new QFilter(listSelectedRow.getEntryEntityKey() + ".id", "=", listSelectedRow.getEntryPrimaryKeyValue());
            DynamicObject temp = QueryServiceHelper.queryOne((String)this.getContext().getSourceMainType().getExtendName(), (String)"id", (QFilter[])new QFilter[]{filter});
            sourceBill = BusinessDataServiceHelper.loadSingle((Object)temp.get("id"), (String)this.getContext().getSourceMainType().getExtendName());
        } else {
            sourceBill = BusinessDataServiceHelper.loadSingle((Object)((ListSelectedRow)this.ruleContext.getSelectedRows().get(0)).getPrimaryKeyValue(), (String)this.getContext().getSourceMainType().getExtendName());
        }
        DynamicObjectCollection groupentrys = recordStrategy.getDynamicObjectCollection("groupentry");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (String field : fields) {
            String targetFiled = "";
            for (DynamicObject groupentry : groupentrys) {
                if (!convertRuleElement.getId().equals(groupentry.getString("e_ruleid")) || groupentry.getInt("e_policy") != 1 || !field.equals(groupentry.getString("e_fieldvalue"))) continue;
                targetFiled = groupentry.getString("e_targerfield");
                break;
            }
            if (!StringUtils.isNotBlank((CharSequence)targetFiled)) continue;
            qFilters.add(new QFilter(targetFiled, "=", sourceBill.get(field)));
        }
        if (qFilters.size() != fields.length) {
            return this.createNewData(srcBillGroup, errMessage);
        }
        Object[] targetBills = BusinessDataServiceHelper.load((String)"dcm_collrecord", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Object[])targetBills)) {
            return this.createNewData(srcBillGroup, errMessage);
        }
        DynamicObject targetBill = BusinessDataServiceHelper.loadSingle((Object)targetBills[0].get("id"), (String)"dcm_collrecord");
        this.modelProxy.createNewData((Object)targetBill);
        return true;
    }

    protected boolean createNewData(SourceRowsGroup srcBillGroup, StringBuilder errMessage) {
        if (!this.setMainOrg(srcBillGroup.getSourceRows())) {
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_0", (String)"bos-mservice-operation", (Object[])new Object[0]));
            if (errMessage != null) {
                errMessage.append(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_0", (String)"bos-mservice-operation", (Object[])new Object[0]));
            }
            return false;
        }
        if (!this.setBillType(srcBillGroup.getSourceRows())) {
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_1", (String)"bos-mservice-operation", (Object[])new Object[0]));
            if (errMessage != null) {
                errMessage.append(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_1", (String)"bos-mservice-operation", (Object[])new Object[0]));
            }
            return false;
        }
        this.modelProxy.createNewData(this.getBlankDataEntity((IDataModel)this.modelProxy));
        return true;
    }

    private boolean setMainOrg(List<DynamicObject> sourceRows) {
        if (this.mainOrgProp == null) {
            return true;
        }
        this.modelProxy.removeContextVariable("SELECT_ORG_ID");
        this.modelProxy.removeContextVariable(this.mainOrgProp.getName());
        if (this.isHasRight()) {
            this.modelProxy.putContextVariable("hasright", (Object)String.valueOf(true));
        }
        HasPermOrgResult permResult = this.loadPermOrgResult();
        Set authOrgIds = permResult.getHasPermOrgs().stream().collect(Collectors.toSet());
        Long pushDefOrgId = ((PushArgs)this.getContext().getInputArgs()).getDefOrgId();
        if (this.mappingMainOrg != null) {
            return this.execMappingMainOrg(sourceRows);
        }
        if (pushDefOrgId != null && Long.compare(0L, pushDefOrgId) != 0 && this.mainOrgProp.canBeMainOrg(pushDefOrgId.longValue(), false, authOrgIds)) {
            this.modelProxy.putContextVariable(this.mainOrgProp.getName(), (Object)pushDefOrgId);
            return true;
        }
        if (this.defOrgId == null) {
            this.defOrgId = this.mainOrgProp.calcDefaultValue((IDataModel)this.modelProxy);
        }
        if (this.defOrgId != null && Long.compare(0L, this.defOrgId) != 0) {
            this.modelProxy.putContextVariable(this.mainOrgProp.getName(), (Object)this.defOrgId);
            return true;
        }
        if (this.ruleContext.getRuleCompiler().getMappingMainOrg() == null) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010%s\u3011\u3010%s\u3011\u5b57\u6bb5\u7684\u53d6\u503c\u516c\u5f0f\uff1b", (String)"CreateTargetBillAction_2", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString());
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        return true;
    }

    private HasPermOrgResult loadPermOrgResult() {
        if (this.permOrgResult != null) {
            return this.permOrgResult;
        }
        boolean isBindNewPerm = PermissionServiceHelper.isBindingAddNewPermission((String)this.targetMainType.getName());
        if (this.isHasRight()) {
            isBindNewPerm = false;
        }
        if (isBindNewPerm) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            this.permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.context.getInputArgs().getAppId(), (String)this.targetMainType.getName(), (String)"47156aff000000ac");
        } else {
            this.permOrgResult = new HasPermOrgResult(){

                public boolean hasAllOrgPerm() {
                    return true;
                }

                public List<Long> getHasPermOrgs() {
                    return new ArrayList<Long>();
                }
            };
        }
        return this.permOrgResult;
    }

    private boolean execMappingMainOrg(List<DynamicObject> sourceRows) {
        HasPermOrgResult permResult = this.loadPermOrgResult();
        HashSet authOrgIds = new HashSet(permResult.getHasPermOrgs());
        Long pushDefOrgId = ((PushArgs)this.getContext().getInputArgs()).getDefOrgId();
        DynamicObject calcOrgObj = this.calcMainOrg(pushDefOrgId, sourceRows);
        if (calcOrgObj == null) {
            String failMessage = this.buildErrMessageForMainOrg(sourceRows);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (this.mainOrgProp.canBeMainOrg(((Long)calcOrgObj.getPkValue()).longValue(), !permResult.hasAllOrgPerm(), authOrgIds)) {
            this.modelProxy.putContextVariable(this.mainOrgProp.getName(), (Object)((Long)calcOrgObj.getPkValue()));
            return true;
        }
        String failMessage = "";
        failMessage = permResult.hasAllOrgPerm() ? String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%s\u3011\u4e0d\u7b26\u5408\u76ee\u6807\u5355\u7ec4\u7ec7\u804c\u80fd\u8981\u6c42", (String)"CreateTargetBillAction_3", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString(), calcOrgObj.getString("name")) : (!authOrgIds.contains((Long)calcOrgObj.getPkValue()) ? String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%s\u3011\u672a\u83b7\u6388\u6743", (String)"CreateTargetBillAction_4", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString(), calcOrgObj.getString("name")) : String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%s\u3011\u4e0d\u7b26\u5408\u76ee\u6807\u5355\u7ec4\u7ec7\u804c\u80fd\u8981\u6c42", (String)"CreateTargetBillAction_3", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString(), calcOrgObj.getString("name")));
        this.addErrorReport(sourceRows, failMessage);
        return false;
    }

    private DynamicObject calcMainOrg(Long defOrgId, List<DynamicObject> sourceRows) {
        if (defOrgId != null && Long.compare(0L, defOrgId) != 0) {
            this.getContext().getOption().setVariableValue("botp_firstrelationorgid", defOrgId.toString());
        } else {
            this.getContext().getOption().removeVariable("botp_firstrelationorgid");
        }
        if (this.mappingMainOrg != null) {
            Long calcOrgId = (Long)this.mappingMainOrg.calcMapValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows);
            if (calcOrgId == null || Long.compare(0L, calcOrgId) == 0) {
                return null;
            }
            Map orgObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{calcOrgId}, (DynamicObjectType)this.mainOrgProp.getDynamicComplexPropertyType());
            return (DynamicObject)orgObjs.get(calcOrgId);
        }
        return null;
    }

    private String buildErrMessageForMainOrg(List<DynamicObject> sourceRows) {
        String failMessage = "";
        if (this.mappingMainOrg == null) {
            failMessage = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010%s\u3011\u3010%s\u3011\u5b57\u6bb5\u7684\u53d6\u503c\u516c\u5f0f\uff1b", (String)"CreateTargetBillAction_2", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString());
        } else if (this.mappingMainOrg.getFieldMap().getFieldConvertType() == FieldConvertType.SourceField) {
            if (!this.linkEntityMap.getSrcFldAlias().containsKey(this.mappingMainOrg.getFieldMap().getSourceFieldKey())) {
                failMessage = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u662f\u4e3b\u7ec4\u7ec7\u5b57\u6bb5\uff0c\u53ea\u80fd\u53d6\u6e90\u5355\u5355\u636e\u5934\u6216\u8005\u5173\u8054\u4e3b\u5b9e\u4f53\u5b57\u6bb5\u503c", (String)"CreateTargetBillAction_5", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString());
            } else {
                IDataEntityProperty srcProp = this.context.getSourceMainType().findProperty(this.mappingMainOrg.getFieldMap().getSourceFieldKey());
                failMessage = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6e90\u5355\u3010%s\u3011\u662f\u5426\u6709\u503c", (String)"CreateTargetBillAction_6", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString(), srcProp.getDisplayName().toString());
            }
        } else {
            failMessage = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u5b57\u6bb5\u53d6\u503c\u516c\u5f0f\u662f\u5426\u65e0\u8bef", (String)"CreateTargetBillAction_7", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.mainOrgProp.getDisplayName().toString());
        }
        return failMessage;
    }

    private boolean setBillType(List<DynamicObject> sourceRows) {
        if (this.billTypeProp == null) {
            return true;
        }
        this.modelProxy.removeContextVariable(DEFAULT_BILLTYPE_ID);
        this.modelProxy.removeContextVariable(this.billTypeProp.getName());
        OutValue mappingId = new OutValue();
        OutValue mappingName = new OutValue();
        if (!this.execMappingBillType(sourceRows, (OutValue<Long>)mappingId, (OutValue<String>)mappingName)) {
            return false;
        }
        Long billTypeId = (Long)mappingId.get();
        Long srcBillTypeId = (Long)this.srcBillTypeReader.getValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows.get(0));
        DynamicObject[] billTypeObjs = this.targetBillTypeObjs.values().toArray(new DynamicObject[0]);
        this.billTypeMapParser.tryGetTargetBillTypeIds(this.ruleContext.getRule().getBillTypeMapPolicy(), srcBillTypeId, billTypeObjs);
        if (this.billTypeMapParser.isCannotPushAnyOne()) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\uff0c\u7981\u6b62\u5f53\u524d\u6e90\u5355\u5355\u636e\u7c7b\u578b\uff0c\u4e0b\u63a8\u5230%s", (String)"CreateTargetBillAction_8", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString());
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (this.billTypeMapParser.getOutBillTypeIds().isEmpty()) {
            String failMessage = ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u914d\u7f6e\u6709\u8bef\uff0c\u5f53\u524d\u6e90\u5355\u7c7b\u578b\uff0c\u627e\u4e0d\u5230\u53ef\u8f6c\u6362\u7684\u76ee\u6807\u5355\u7c7b\u578b", (String)"CreateTargetBillAction_9", (String)"bos-mservice-operation", (Object[])new Object[0]);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (billTypeId == null || Long.compare(0L, billTypeId) == 0) {
            if (!this.billTypeMapParser.getOutBillTypeIds().isEmpty() && (billTypeId = this.getEnabledBillTypeId(sourceRows, this.billTypeMapParser.getOutBillTypeIds())) == null) {
                return false;
            }
        } else {
            if (this.billTypeMapParser.getOutCannotPushBillTypeIds().contains(billTypeId)) {
                String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011, \u88ab\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u9650\u5236\u4e0b\u63a8", (String)"CreateTargetBillAction_10", (String)"bos-mservice-operation", (Object[])new Object[0]), mappingName.get());
                this.addErrorReport(sourceRows, failMessage);
                return false;
            }
            if (!this.billTypeMapParser.getOutBillTypeIds().contains(billTypeId)) {
                String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011, \u4e0d\u5728\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u5141\u8bb8\u4e0b\u63a8\u7684\u8303\u56f4", (String)"CreateTargetBillAction_11", (String)"bos-mservice-operation", (Object[])new Object[0]), mappingName.get());
                this.addErrorReport(sourceRows, failMessage);
                return false;
            }
        }
        if (billTypeId != null && Long.compare(0L, billTypeId) != 0) {
            this.modelProxy.putContextVariable(DEFAULT_BILLTYPE_ID, (Object)billTypeId);
            BillTypeDefValueProvider defValueProvider = new BillTypeDefValueProvider(billTypeId);
            this.modelProxy.addService(IDefValueProvider.class, (Object)defValueProvider);
            return true;
        }
        String failMessage = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u3010%s\u3011\u5b57\u6bb5\u503c\u8ba1\u7b97\u5931\u8d25", (String)"CreateTargetBillAction_12", (String)"bos-mservice-operation", (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.billTypeProp.getDisplayName().toString());
        for (DynamicObject sourceRow : sourceRows) {
            this.buildReport.addErrorReport(this.getResultManager().getReporter(), this.linkEntityMap.getSrcFldPropertys(), sourceRow, failMessage);
        }
        return false;
    }

    private void addErrorReport(List<DynamicObject> sourceRows, String failMessage) {
        for (DynamicObject sourceRow : sourceRows) {
            this.buildReport.addErrorReport(this.getResultManager().getReporter(), this.linkEntityMap.getSrcFldPropertys(), sourceRow, failMessage);
        }
    }

    private boolean execMappingBillType(List<DynamicObject> sourceRows, OutValue<Long> mappingId, OutValue<String> mappingName) {
        Long billTypeId = null;
        if (this.mappingBillType == null) {
            return true;
        }
        billTypeId = (Long)this.mappingBillType.calcMapValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows);
        if (billTypeId == null || Long.compare(0L, billTypeId) == 0) {
            return true;
        }
        mappingId.set((Object)billTypeId);
        if (!this.targetBillTypeObjs.containsKey(billTypeId)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578bId\u3010%s\u3011\u65e0\u6548", (String)"CreateTargetBillAction_13", (String)"bos-mservice-operation", (Object[])new Object[0]), billTypeId.toString());
            Object[] objs = BusinessDataReader.load((Object[])new Object[]{billTypeId}, (IDataEntityType)this.billTypeProp.getDynamicComplexPropertyType());
            if (objs != null && objs.length > 0) {
                DynamicObject obj = (DynamicObject)objs[0];
                failMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\uff0c\u4e0d\u5c5e\u4e8e\u76ee\u6807\u5355\uff0c\u4e0d\u80fd\u7ed9\u5b57\u6bb5\u8d4b\u503c", (String)"CreateTargetBillAction_14", (String)"bos-mservice-operation", (Object[])new Object[0]), obj.get("name").toString());
            }
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        DynamicObject billTypeObj = this.targetBillTypeObjs.get(billTypeId);
        String billTypeName = billTypeObj.get("name").toString();
        String status = billTypeObj.getString("status");
        String enable = billTypeObj.getString("enable");
        if (!StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)enable)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u7ecf\u7981\u7528", (String)"CreateTargetBillAction_15", (String)"bos-mservice-operation", (Object[])new Object[0]), billTypeName);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)status)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u672a\u5ba1\u6838", (String)"CreateTargetBillAction_16", (String)"bos-mservice-operation", (Object[])new Object[0]), billTypeName);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        mappingName.set((Object)billTypeName);
        return true;
    }

    private Long getEnabledBillTypeId(List<DynamicObject> sourceRows, List<Long> billTypeIds) {
        Long billTypeId = null;
        ArrayList<String> unAuditNames = new ArrayList<String>();
        ArrayList<String> disableNames = new ArrayList<String>();
        for (Long id : billTypeIds) {
            DynamicObject billTypeObj = this.targetBillTypeObjs.get(id);
            if (billTypeObj == null) continue;
            String billTypeName = billTypeObj.get("name").toString();
            if (!this.isEnabledBillType(billTypeObj)) {
                disableNames.add(billTypeName);
                continue;
            }
            if (!this.isAuditdBillType(billTypeObj)) {
                unAuditNames.add(billTypeName);
                continue;
            }
            billTypeId = id;
            break;
        }
        if (billTypeId == null) {
            String failMessage = null;
            failMessage = !disableNames.isEmpty() && !unAuditNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u672a\u5ba1\u6838\uff0c\u3010%s\u3011\u5df2\u7981\u7528", (String)"CreateTargetBillAction_17", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])unAuditNames.toArray(), (String)","), StringUtils.join((Object[])disableNames.toArray(), (String)",")) : (!unAuditNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u672a\u5ba1\u6838", (String)"CreateTargetBillAction_18", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])unAuditNames.toArray(), (String)",")) : (!disableNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u7981\u7528", (String)"CreateTargetBillAction_19", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])disableNames.toArray(), (String)",")) : String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u88ab\u5220\u9664", (String)"CreateTargetBillAction_20", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])billTypeIds.toArray(), (String)","))));
            this.addErrorReport(sourceRows, failMessage);
        }
        return billTypeId;
    }

    private boolean isAuditdBillType(DynamicObject billTypeObj) {
        String status = billTypeObj.getString("status");
        return StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)status);
    }

    private boolean isEnabledBillType(DynamicObject billTypeObj) {
        String enable = billTypeObj.getString("enable");
        return StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)enable);
    }

    private Map<Object, DynamicObject> loadBillTypeObjs() {
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)this.targetMainType.getName())};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }
}

