/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.botp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FilterPolicy;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.fi.dcm.business.botp.convert.actions.CreateLinkEntityRowsAction;
import kd.fi.dcm.business.botp.convert.actions.CreateTargetBillAction;
import kd.fi.dcm.common.enums.CompareTypeEnum;
import kd.fi.dcm.common.task.model.PushRecordDO;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.StrategyFilterUtils;
import kd.fi.dcm.common.util.StringUtils;

public class PushHelper {
    public static void setFilterPolicy(ConvertRuleElement rule, DynamicObject recordStrategy) {
        List srcFilterRow = rule.getFilterPolicy().getCondition().getFilterCondition().getFilterRow();
        List billFilters = StrategyFilterUtils.buildStrategyFilters((DynamicObject)recordStrategy);
        if (CollectionUtils.isEmpty((Collection)billFilters)) {
            return;
        }
        for (QFilter billFilter : billFilters) {
            srcFilterRow.add(PushHelper.buildSimpleFilterRow(StringUtils.toSafeString((Object)billFilter.getValue()), billFilter.getProperty(), CompareTypeEnum.getValueByName((String)billFilter.getCP())));
        }
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(srcFilterRow);
        CRCondition crCondition = new CRCondition();
        crCondition.setFilterCondition(filterCondition);
        FilterPolicy filterPolicy = new FilterPolicy();
        filterPolicy.setCondition(crCondition);
        rule.setFilterPolicy(filterPolicy);
        rule.setCacheVersion(null);
    }

    private static SimpleFilterRow buildSimpleFilterRow(String val, String field, String compareType) {
        if (field.contains(".")) {
            String[] split = field.split("\\.");
            field = split[split.length - 1];
        }
        FilterValue filterValue = new FilterValue();
        filterValue.setValue((Object)val);
        ArrayList<FilterValue> filterValueList = new ArrayList<FilterValue>(1);
        filterValueList.add(filterValue);
        SimpleFilterRow simpleFilterRow = new SimpleFilterRow("", compareType, field, "", "0", filterValueList);
        return simpleFilterRow;
    }

    public static void pushActionIntercept(AbstractConvertAction action, PushRecordDO pushRecordDO) {
        HashMap<Object, Object> customerMap;
        if (action instanceof CreateTargetBillAction) {
            customerMap = new HashMap<Object, Object>(2);
            customerMap.put("merge", Boolean.TRUE);
            customerMap.put("pushRecordDO", pushRecordDO);
            ((CreateTargetBillAction)action).setCustomerMap(customerMap);
        }
        if (action instanceof CreateLinkEntityRowsAction) {
            customerMap = new HashMap(2);
            customerMap.put("merge", Boolean.TRUE);
            customerMap.put("pushRecordDO", pushRecordDO);
            ((CreateLinkEntityRowsAction)action).setCustomerMap(customerMap);
        }
    }
}

