/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.message;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.dcm.business.message.ISendMessage;
import kd.fi.dcm.common.helper.SendMsgHelper;
import kd.fi.dcm.common.task.model.MessageDO;
import kd.fi.dcm.common.task.model.PreFillRowDao;
import kd.fi.dcm.common.util.EmptyUtils;

public abstract class AbstractSendMessage
implements ISendMessage {
    private static Log log = LogFactory.getLog(AbstractSendMessage.class);
    private MessageDO messageDO = null;

    public void printErrorMsg(String msg) {
        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406(\u6d88\u606f\u5904\u7406):", (String)"AbstractSendMessage_0", (String)"fi-dcm-business", (Object[])new Object[0]));
        builder.append(msg);
        log.error(builder.toString());
    }

    public void printInfoMsg(String msg) {
        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406(\u6d88\u606f\u5904\u7406):", (String)"AbstractSendMessage_0", (String)"fi-dcm-business", (Object[])new Object[0]));
        builder.append(msg);
        log.info(builder.toString());
    }

    public MessageDO getMessageDO() {
        return this.messageDO;
    }

    public void setMessageDO(MessageDO messageDO) {
        this.messageDO = messageDO;
    }

    protected boolean customerNotExits(DynamicObject collMethod, DynamicObject actionObj) {
        if (EmptyUtils.isNotEmpty((Object)collMethod)) {
            switch (collMethod.getString("collectionmethod")) {
                case "sms": {
                    return EmptyUtils.isNotEmpty((Object)actionObj.getString("guestphone"));
                }
                case "email": {
                    return EmptyUtils.isNotEmpty((Object)actionObj.getString("guestemail"));
                }
                case "mcenter": {
                    return EmptyUtils.isNotEmpty((Object)actionObj.getString("guestuser"));
                }
            }
            return false;
        }
        return false;
    }

    public boolean sendMsgToCustomer(DynamicObject collMethod, DynamicObject collTpl, DynamicObject actionObj, DynamicObject recordObj) {
        String channels = collMethod.getString("collectionmethod");
        if (EmptyUtils.isEmpty((Object)channels) || EmptyUtils.isEmpty((Object)collTpl)) {
            this.printInfoMsg("AnalysRecordSendMsgHelper sendMsgToCustomer , tpl is not exist " + recordObj);
            return false;
        }
        this.printInfoMsg("AnalysRecordSendMsgHelper sendMsgToCustomer , customer not exist");
        if (!this.customerNotExits(collMethod, actionObj)) {
            return false;
        }
        SendMsgHelper.sendMsgPrepare(null, (String)channels, (DynamicObject)collTpl, (DynamicObject)recordObj, (String)"customer", (DynamicObject)actionObj);
        return true;
    }

    public void sendMsgToInnerUser(DynamicObject recordObj, List<PreFillRowDao> preFillRowDaoList) {
        for (PreFillRowDao pre : preFillRowDaoList) {
            List innerList = pre.getInner();
            String channels = pre.getCollMethod().getString("collectionmethod");
            DynamicObject tpl = pre.getCollTpl();
            List inners = innerList.stream().map(t -> t.getDynamicObject("specperson").getLong("id")).collect(Collectors.toList());
            SendMsgHelper.sendMsgPrepare(inners, (String)channels, (DynamicObject)tpl, (DynamicObject)recordObj, (String)"inner", null);
        }
    }
}

