/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.task;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.dcm.business.task.impl.BillToRecordServiceImpl;
import kd.fi.dcm.business.task.impl.RecordCloseServiceImpl;
import kd.fi.dcm.business.task.impl.RecordToActionServiceImpl;
import kd.fi.dcm.business.task.impl.RecordUnCloseServiceImpl;
import kd.fi.dcm.business.task.impl.RecordUpdateServiceImpl;
import kd.fi.dcm.common.dev.BeanFactory;
import kd.fi.dcm.common.enums.TaskTypeEnum;
import kd.fi.dcm.common.task.AbstractTaskService;
import kd.fi.dcm.common.task.TaskContext;
import kd.fi.dcm.common.task.TaskResult;
import kd.fi.dcm.common.util.DateUtils;
import kd.fi.dcm.common.util.IntegerUtils;
import kd.fi.dcm.common.util.StringUtils;

public class DcmTaskFactory {
    public static AbstractTaskService getTaskService(TaskContext taskContext, TaskResult taskResult) {
        DcmTaskFactory.initTaskContext(taskContext, taskResult);
        switch (TaskTypeEnum.getByValue((String)taskContext.getTaskType())) {
            case PUSHRECORD: {
                return (AbstractTaskService)BeanFactory.getBean(BillToRecordServiceImpl.class, (Object[])new Object[]{taskContext, taskResult});
            }
            case CLOSE: {
                return (AbstractTaskService)BeanFactory.getBean(RecordCloseServiceImpl.class, (Object[])new Object[]{taskContext, taskResult});
            }
            case UPDATE: {
                return (AbstractTaskService)BeanFactory.getBean(RecordUpdateServiceImpl.class, (Object[])new Object[]{taskContext, taskResult});
            }
            case PUSHACTION: {
                return (AbstractTaskService)BeanFactory.getBean(RecordToActionServiceImpl.class, (Object[])new Object[]{taskContext, taskResult});
            }
            case UNCLOSE: {
                return (AbstractTaskService)BeanFactory.getBean(RecordUnCloseServiceImpl.class, (Object[])new Object[]{taskContext, taskResult});
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4efb\u52a1\u7c7b\u578b[%s]", (String)"DcmTaskFactory_0", (String)"fi-dcm-business", (Object[])new Object[0]), taskContext.getTaskType()));
    }

    private static void initTaskContext(TaskContext taskContext, TaskResult taskResult) {
        String startDate;
        if (taskContext.getMap() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u81ea\u5b9a\u4e49\u53c2\u6570,\u8bf7\u68c0\u67e5", (String)"DcmTaskFactory_1", (String)"fi-dcm-business", (Object[])new Object[0]));
        }
        String type = StringUtils.toSafeString(taskContext.getMap().get("type"));
        if (StringUtils.isBlank((String)type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u4efb\u52a1\u7c7b\u578b,\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u914d\u7f6e[type]\u952e\u503c", (String)"DcmTaskFactory_2", (String)"fi-dcm-business", (Object[])new Object[0]));
        }
        taskContext.setTaskType(type);
        int seleteNum = IntegerUtils.toSafeInteger(taskContext.getMap().get("selectNum"));
        if (seleteNum != 0) {
            taskContext.setSelectNum(seleteNum);
        }
        if (StringUtils.isNotBlank((String)(startDate = StringUtils.toSafeString(taskContext.getMap().get("startDate"))))) {
            Date startDateVal = DateUtils.parseDate((String)StringUtils.toSafeString(taskContext.getMap().get("startDate")), (String)"yyyy-MM-dd");
            taskContext.setStartDate(startDateVal);
        }
    }
}

