/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.task.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.dcm.business.botp.convert.ConvertEngine;
import kd.fi.dcm.common.task.AbstractTaskService;
import kd.fi.dcm.common.task.TaskContext;
import kd.fi.dcm.common.task.TaskResult;
import kd.fi.dcm.common.task.model.PushRecordDO;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.ConditionUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StrategyFilterUtils;
import kd.fi.dcm.common.util.StringUtils;

public abstract class AbstractBillToRecordService
extends AbstractTaskService {
    protected PushRecordDO pushRecordDO = new PushRecordDO();

    public AbstractBillToRecordService(TaskContext taskContext, TaskResult taskResult) {
        super(taskContext, taskResult);
    }

    public void initializeTaskArgs() {
        this.getRecordStrategys(Boolean.TRUE);
        this.getSrcBillEntity();
        this.initRecordStrategy();
    }

    protected void initRecordStrategy() {
        if (StringUtils.isBlank((String)this.taskContext.getSrcBillEntity())) {
            return;
        }
        Map strategyFilterMap = this.pushRecordDO.getStrategyFilterMap();
        for (DynamicObject recordStrategy : this.taskContext.getRecordStrategys()) {
            List<QFilter> f;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            DynamicObject BOTPRule = recordStrategy.getDynamicObject("ruleid");
            QFilter ruleFilterPolicy = this.getRuleFilter(BOTPRule);
            if (EmptyUtils.isNotEmpty((Object)ruleFilterPolicy)) {
                filters.add(ruleFilterPolicy);
            }
            if (EmptyUtils.isNotEmpty(f = this.buildQFilter(recordStrategy))) {
                filters.addAll(f);
            }
            strategyFilterMap.put((Long)recordStrategy.getPkValue(), filters);
        }
    }

    public void batchPushRecords() {
        if (EmptyUtils.isEmpty((Object)this.taskContext.getRecordStrategys())) {
            return;
        }
        for (DynamicObject recordStrategy : this.taskContext.getRecordStrategys()) {
            this.pushRecordDO.setRecordStrategy(recordStrategy);
            this.getSrcBills();
            if (CollectionUtils.isEmpty((Collection)this.pushRecordDO.getSrcEnrtyBills())) continue;
            this.batchPushSrcBills();
        }
    }

    protected void batchPushSrcBills() {
        this.batchPush();
        if (CollectionUtils.isEmpty((Collection)this.pushRecordDO.getTargetBills())) {
            this.taskResult.setAllSuccess(false);
        }
    }

    protected void batchPush() {
        this.pushRecordDO.setTargetBills(null);
        ConvertOperationResult result = this.push();
        if (result == null) {
            return;
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"dcm_collrecord");
        List targetBills = result.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (CollectionUtils.isEmpty((Collection)targetBills)) {
            return;
        }
        this.pushRecordDO.setTargetBills(targetBills);
        this.saveRecords();
    }

    protected ConvertOperationResult push() {
        ConvertOperationResult result = null;
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(1);
        DynamicObjectCollection bills = this.pushRecordDO.getSrcEnrtyBills();
        for (DynamicObject bill : bills) {
            ListSelectedRow row = new ListSelectedRow((Object)bill.getLong("id"));
            String srcEntryName = this.pushRecordDO.getSrcEntryName();
            if (EmptyUtils.isNotEmpty((Object)srcEntryName)) {
                row.setEntryEntityKey(srcEntryName);
                row.setEntryPrimaryKeyValue((Object)bill.getLong((String)srcEntryName + ".id"));
            }
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(this.taskContext.getSrcBillEntity());
        args.setTargetEntityNumber("dcm_collrecord");
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        args.setRuleId(this.pushRecordDO.getRecordStrategy().getDynamicObject("ruleid").getString("number"));
        ConvertEngine convertEngine = new ConvertEngine();
        result = convertEngine.push(args, this.pushRecordDO);
        if (result.isSuccess()) {
            return result;
        }
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(result.getMessage());
        for (SourceBillReport billReport : result.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            errMessage.append('\n').append(billMessage);
        }
        String msg = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8[\u5931\u8d25],\u5931\u8d25\u539f\u56e0[%s],\u6e90\u5355\u7f16\u53f7[%s]", (String)"BillToRecordHelper_0", (String)"fi-dcm-business", (Object[])new Object[0]), errMessage.toString(), bills.stream().map(dynamicObject -> dynamicObject.get("billno")).collect(Collectors.toList()));
        this.printErrorLog(msg);
        return null;
    }

    private void saveRecords() {
        try (TXHandle h = TX.requiresNew();){
            try {
                OperationResult saveRes = OperationServiceHelper.executeOperate((String)"save", (String)"dcm_collrecord", (DynamicObject[])this.pushRecordDO.getTargetBills().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (saveRes.isSuccess()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6863\u6848\u62bd\u53d6\u89c4\u5219[%s],\u4e0b\u63a8\u6e90\u5355\u5206\u5f55\u6570\u91cf[%s],\u4e0b\u63a8\u6210\u529f[%s],\u76ee\u6807\u5355ID[%s]", (String)"BillToRecordHelper_1", (String)"fi-dcm-business", (Object[])new Object[0]), this.pushRecordDO.getRecordStrategy().get("number"), this.pushRecordDO.getSrcEnrtyBills().size(), saveRes.getSuccessPkIds().size(), StringUtils.toSafeString((Object)saveRes.getSuccessPkIds()));
                    this.printInfoLog(msg);
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u6863\u6848\u62bd\u53d6\u89c4\u5219[%s],\u4fdd\u5b58[%s]\u6761\u50ac\u6536\u6863\u6848\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a[%s]", (String)"BillToRecordHelper_2", (String)"fi-dcm-business", (Object[])new Object[0]), this.pushRecordDO.getRecordStrategy().get("number"), this.pushRecordDO.getTargetBills().size(), saveRes.getMessage());
                    this.printErrorLog(msg);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    protected void getSrcBills() {
        DynamicObject recordStrategy = this.pushRecordDO.getRecordStrategy();
        List filters = (List)this.pushRecordDO.getStrategyFilterMap().get(recordStrategy.getPkValue());
        String writeBackField = recordStrategy.getString("writebackfield");
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("id");
        list.add("billno");
        if (writeBackField.contains(".")) {
            String[] str = writeBackField.replaceAll(" ", "").split("\\.");
            list.add(str[0] + ".id");
            this.pushRecordDO.setSrcEntryName(str[0]);
        } else {
            this.pushRecordDO.setSrcEntryName(null);
        }
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("kd.fi.dcm.business.helper.BillToRecordHelper", this.taskContext.getSrcBillEntity(), String.join((CharSequence)",", list), filters.toArray(new QFilter[0]));
        DynamicObjectCollection srcEntryBills = orm.toPlainDynamicObjectCollection(ds);
        if (CollectionUtils.isEmpty((Collection)srcEntryBills)) {
            String msg = String.format(ResManager.loadKDString((String)"\u6863\u6848\u62bd\u53d6\u89c4\u5219[%s]\u672a\u8fc7\u6ee4\u5230\u6e90\u5355[%s]\u6570\u636e,\u4f7f\u7528\u6761\u4ef6[%s]", (String)"BillToRecordHelper_3", (String)"fi-dcm-business", (Object[])new Object[0]), this.pushRecordDO.getRecordStrategy().get("number"), this.taskContext.getSrcBillEntity(), filters.toString());
            this.printErrorLog(msg);
        }
        this.pushRecordDO.setSrcEnrtyBills(srcEntryBills);
    }

    private List<QFilter> buildQFilter(DynamicObject recordStrategy) {
        if (recordStrategy.getDynamicObject("billentity") == null || StringUtils.isBlank((String)StringUtils.toSafeString((Object)recordStrategy.getDynamicObject("billentity").getPkValue()))) {
            return null;
        }
        ArrayList<QFilter> result = new ArrayList<QFilter>(3);
        List billFilters = StrategyFilterUtils.buildStrategyFilters((DynamicObject)recordStrategy);
        if (EmptyUtils.isNotEmpty((Object)billFilters)) {
            result.addAll(billFilters);
        }
        if (EmptyUtils.isNotEmpty((Object)this.taskContext.getStartDate())) {
            result.add(new QFilter("createtime", ">=", (Object)this.taskContext.getStartDate()));
        }
        if (StringUtils.isNotBlank((String)recordStrategy.getString("writebackfield"))) {
            result.add(new QFilter(recordStrategy.getString("writebackfield"), "=", (Object)Boolean.FALSE));
        }
        return result;
    }

    private QFilter getRuleFilter(DynamicObject rule) {
        if (rule == null) {
            return null;
        }
        String ruleId = rule.getString("number");
        if (StringUtils.isBlank((String)ruleId)) {
            return null;
        }
        Map ruleQfilterMap = this.pushRecordDO.getRuleQfilterMap();
        if (ruleQfilterMap.containsKey(rule.getString("number"))) {
            QFilter qFilter = (QFilter)ruleQfilterMap.get(rule.get("number"));
            return qFilter;
        }
        ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)ruleId);
        this.getRuleMergeField(convertRuleElement);
        ConditionUtils conditionUtils = new ConditionUtils();
        CRCondition condition = convertRuleElement.getFilterPolicy().getCondition();
        String sourceEntityNumber = convertRuleElement.getSourceEntityNumber();
        QFilter qFilter = conditionUtils.buildQFilter(SerializationUtils.toJsonString((Object)condition), sourceEntityNumber);
        if (convertRuleElement.getRunCondition() != null) {
            QFilter runQFilter = conditionUtils.buildQFilter(SerializationUtils.toJsonString((Object)convertRuleElement.getRunCondition()), sourceEntityNumber);
            if (qFilter == null) {
                qFilter = runQFilter;
            } else {
                qFilter.and(runQFilter);
            }
        }
        ruleQfilterMap.put(ruleId, qFilter);
        this.pushRecordDO.setRuleQfilterMap(ruleQfilterMap);
        return qFilter;
    }

    private void getRuleMergeField(ConvertRuleElement convertRuleElement) {
        GroupByPolicy groupByPolicy = convertRuleElement.getGroupByPolicy();
        if (groupByPolicy.getGroupByMode().getValue() != GroupByMode.GroupByField.getValue()) {
            return;
        }
        String[] fields = groupByPolicy.getGroupByField().split(",");
        if (EmptyUtils.isNotEmpty((Object)fields)) {
            this.pushRecordDO.getRuleMergeFields().addAll(new ArrayList<String>(Arrays.asList(fields)));
        }
    }

    public PushRecordDO getPushRecordDO() {
        return this.pushRecordDO;
    }
}

