/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.task.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.dcm.business.task.impl.RecordUpdateServiceImpl;
import kd.fi.dcm.common.dev.BeanFactory;
import kd.fi.dcm.common.task.AbstractTaskService;
import kd.fi.dcm.common.task.TaskContext;
import kd.fi.dcm.common.task.TaskResult;
import kd.fi.dcm.common.task.model.RecordIsCloseDO;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.ConditionUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StringUtils;

public abstract class AbstractRecordIsCloseService
extends AbstractTaskService {
    protected RecordIsCloseDO recordIsCloseDO = new RecordIsCloseDO();
    protected Long recordStrategyId = 0L;

    public AbstractRecordIsCloseService(TaskContext taskContext, TaskResult taskResult) {
        super(taskContext, taskResult);
    }

    public void initializeTaskArgs() {
        this.getSrcBillEntity();
        this.getRecordStrategys(Boolean.FALSE);
        this.initRecordStgyCloseFilter();
        this.initCollRecordData();
    }

    protected void matchSrcData() {
        if (EmptyUtils.isEmpty((Object)this.recordIsCloseDO.getGroupRecordBills())) {
            return;
        }
        for (Map.Entry entry : this.recordIsCloseDO.getGroupRecordBills().entrySet()) {
            String msg;
            this.recordStrategyId = (Long)entry.getKey();
            List recordBills = (List)entry.getValue();
            List<QFilter> qFilters = this.buildQFilter(recordBills);
            if (CollectionUtils.isEmpty(qFilters)) {
                msg = String.format(ResManager.loadKDString((String)"\u6863\u6848\u62bd\u53d6\u89c4\u5219[%s]\u672a\u8bbe\u7f6e\u53cd\u6761\u4ef6,\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01", (String)"RecordUnColseServiceImpl_0", (String)"fi-dcm-business", (Object[])new Object[0]), this.recordStrategyId);
                this.printErrorLog(msg);
                this.taskResult.setAllSuccess(false);
                continue;
            }
            if (StringUtils.isBlank((String)this.taskContext.getSrcBillEntity())) {
                msg = String.format(ResManager.loadKDString((String)"\u6863\u6848\u62bd\u53d6\u89c4\u5219[%s]\u4e0b\u6240\u6709\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6.\u4e1a\u52a1\u5355\u636e\u672a\u6307\u5b9a,\u8bf7\u68c0\u67e5BOTP\u914d\u7f6e\uff01", (String)"RecordUnColseServiceImpl_1", (String)"fi-dcm-business", (Object[])new Object[0]), this.recordStrategyId);
                this.printErrorLog(msg);
                this.taskResult.setAllSuccess(false);
                continue;
            }
            this.getSrcBill(qFilters);
            this.matchSrcBill();
        }
    }

    public abstract void matchSrcBill();

    protected void updateCollRecords() {
        if (CollectionUtils.isEmpty((Collection)this.recordIsCloseDO.getUpdateRecordBills())) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.updateDBDate();
                this.invokeRecordSave(this.recordIsCloseDO.getRecordIds());
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public void initCollRecordData() {
        this.getCollRecordBills();
        if (CollectionUtils.isEmpty((Collection)this.recordIsCloseDO.getRecordBills())) {
            return;
        }
        HashMap<String, DynamicObject> recordBillMap = new HashMap<String, DynamicObject>(1);
        HashMap<Long, ArrayList<DynamicObject>> grouprecordBills = new HashMap<Long, ArrayList<DynamicObject>>(1);
        for (DynamicObject recordBill : this.recordIsCloseDO.getRecordBills()) {
            String entryId = "0";
            if (StringUtils.isNotBlank((String)recordBill.getString("srcEntryId"))) {
                entryId = recordBill.getString("srcEntryId");
            }
            String key = recordBill.getString("srcBillId") + "_" + entryId;
            recordBillMap.put(key, recordBill);
            ArrayList<DynamicObject> recordBills = (ArrayList<DynamicObject>)grouprecordBills.get(recordBill.getLong("recordStrategyId"));
            if (CollectionUtils.isEmpty((Collection)recordBills)) {
                recordBills = new ArrayList<DynamicObject>(1);
            }
            recordBills.add(recordBill);
            grouprecordBills.put(recordBill.getLong("recordStrategyId"), recordBills);
        }
        this.recordIsCloseDO.setRecordBillMap(recordBillMap);
        this.recordIsCloseDO.setGroupRecordBills(grouprecordBills);
    }

    public abstract void getCollRecordBills();

    public void updateIsCloseRecordDate() {
        if (EmptyUtils.isEmpty((Object)this.recordIsCloseDO.getUpdateRecordBills())) {
            return;
        }
        HashSet<Long> recordEntryIds = new HashSet<Long>(this.recordIsCloseDO.getUpdateRecordBills().size());
        for (DynamicObject record : this.recordIsCloseDO.getUpdateRecordBills()) {
            recordEntryIds.add(record.getLong("srcentry.id"));
        }
        RecordUpdateServiceImpl updateService = (RecordUpdateServiceImpl)((Object)BeanFactory.getBean(RecordUpdateServiceImpl.class, (Object[])new Object[]{this.taskContext, this.taskResult}));
        updateService.getRecordUpdateDo().setByManual(Boolean.TRUE);
        updateService.getRecordUpdateDo().setUpdateEntryIds(recordEntryIds);
        updateService.executeByManual();
    }

    protected void initRecordStgyCloseFilter() {
        ConditionUtils conditionUtils = new ConditionUtils();
        HashMap<Long, QFilter> recordStgyCloseFilter = new HashMap<Long, QFilter>(1);
        for (DynamicObject recordStrategyBill : this.taskContext.getRecordStrategys()) {
            if (StringUtils.isBlank((String)recordStrategyBill.getString("billentity.number")) || StringUtils.isBlank((String)recordStrategyBill.getString("closerecordfilterval_tag"))) continue;
            QFilter qFilter = conditionUtils.buildQFilter(recordStrategyBill.getString("closerecordfilterval_tag"), recordStrategyBill.getString("billentity.number"));
            recordStgyCloseFilter.put(recordStrategyBill.getLong("id"), qFilter);
        }
        this.recordIsCloseDO.setRecordStgyCloseFilter(recordStgyCloseFilter);
    }

    protected List<QFilter> buildQFilter(List<DynamicObject> recordBills) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter qFilter = (QFilter)this.recordIsCloseDO.getRecordStgyCloseFilter().get(this.recordStrategyId);
        if (qFilter == null) {
            return qFilters;
        }
        String srcEntryEntity = "";
        String srcBillEntity = "";
        ArrayList<Long> qFilterIdsTmp = new ArrayList<Long>(1);
        ArrayList<Long> qFilterEntryIdsTmp = new ArrayList<Long>(1);
        for (DynamicObject record : recordBills) {
            if (StringUtils.isBlank((String)srcEntryEntity)) {
                srcEntryEntity = record.getString("srcEntryEntity");
            }
            if (StringUtils.isNotBlank((String)record.getString("srcEntryEntity"))) {
                qFilterEntryIdsTmp.add(record.getLong("srcEntryId"));
            }
            if (StringUtils.isBlank((String)srcBillEntity)) {
                srcBillEntity = record.getString("billEntity");
            }
            qFilterIdsTmp.add(record.getLong("srcBillId"));
        }
        qFilters.add(qFilter);
        if (StringUtils.isNotBlank((String)srcEntryEntity) && CollectionUtils.isNotEmpty(qFilterEntryIdsTmp)) {
            qFilters.add(new QFilter(srcEntryEntity + ".id", "in", qFilterEntryIdsTmp));
        }
        if (CollectionUtils.isNotEmpty(qFilterIdsTmp)) {
            qFilters.add(new QFilter("id", "in", qFilterIdsTmp));
        }
        this.recordIsCloseDO.setSrcEntryEntity(srcEntryEntity);
        this.taskContext.setSrcBillEntity(srcBillEntity);
        return qFilters;
    }

    private void getSrcBill(List<QFilter> qFilters) {
        ArrayList<String> selectField = new ArrayList<String>(1);
        selectField.add("id");
        if (StringUtils.isNotBlank((String)this.recordIsCloseDO.getSrcEntryEntity())) {
            selectField.add(this.recordIsCloseDO.getSrcEntryEntity() + ".id entryId");
        } else {
            selectField.add("0 entryId");
        }
        DynamicObjectCollection srcBills = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), this.taskContext.getSrcBillEntity(), StringUtils.join(selectField), qFilters.toArray(new QFilter[0]));){
            srcBills = orm.toPlainDynamicObjectCollection(ds);
        }
        this.recordIsCloseDO.setSrcBills(srcBills);
    }

    protected void updateDBDate() {
        String msg;
        String updateSql = "UPDATE t_dcm_collrecordsrcentry SET fisclose = " + (this.recordIsCloseDO.isClose() ? 1 : 0) + " WHERE fentryid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        HashSet<Long> recordIds = new HashSet<Long>(1);
        for (DynamicObject bill : this.recordIsCloseDO.getUpdateRecordBills()) {
            Long entryId = bill.getLong("entryId");
            if (entryId == null) continue;
            Object[] param = new Object[]{entryId};
            params.add(param);
            recordIds.add(bill.getLong("id"));
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        DBRoute dcm = DBRoute.of((String)"fi");
        int[] res = DB.executeBatch((DBRoute)dcm, (String)updateSql, params);
        if (res == null) {
            msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6\u53cd\u5173\u95ed[\u4fee\u6539\u53cd\u5173\u95ed\u72b6\u6001\u5931\u8d25],\u5355\u636eID[%s]", (String)"RecordUnColseServiceImpl_2", (String)"fi-dcm-business", (Object[])new Object[0]), params);
            this.printErrorLog(msg);
        } else {
            msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6\u53cd\u5173\u95ed[\u4fee\u6539\u53cd\u5173\u95ed\u72b6\u6001\u6210\u529f],\u6210\u529f\u5904\u7406[%s]\u5f20\u5355\u636e", (String)"RecordUnColseServiceImpl_3", (String)"fi-dcm-business", (Object[])new Object[0]), res[0]);
            this.printInfoLog(msg);
        }
        this.recordIsCloseDO.setRecordIds(recordIds);
    }

    public RecordIsCloseDO getRecordIsCloseDO() {
        return this.recordIsCloseDO;
    }
}

