/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.task.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dcm.business.message.AbstractMessageHandle;
import kd.fi.dcm.business.message.MessageHandleByRecordImpl;
import kd.fi.dcm.business.message.MessageHandleImpl;
import kd.fi.dcm.common.task.AbstractTaskService;
import kd.fi.dcm.common.task.TaskContext;
import kd.fi.dcm.common.task.TaskResult;
import kd.fi.dcm.common.task.model.PreFillRowDao;
import kd.fi.dcm.common.task.model.PushActionDO;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.EmptyUtils;
import kd.fi.dcm.common.util.StrategyFilterUtils;
import kd.fi.dcm.common.util.StringUtils;

public abstract class AbstractRecordToActionService
extends AbstractTaskService {
    protected PushActionDO pushActionDO = new PushActionDO();

    public AbstractRecordToActionService(TaskContext taskContext, TaskResult taskResult) {
        super(taskContext, taskResult);
    }

    public void initializeTaskArgs() {
        this.getActionStrategys(Boolean.TRUE);
        if (CollectionUtils.isEmpty((Object[])this.taskContext.getActionStrategys())) {
            return;
        }
        this.getSrcBillEntity();
    }

    public void beginCircularPolicy() {
        for (DynamicObject actionStrategy : this.taskContext.getActionStrategys()) {
            this.initPushActionDO(actionStrategy);
            this.pushRecordEvent();
            this.pushActionDO.clear();
        }
    }

    private void initPushActionDO(DynamicObject actionStrategy) {
        this.pushActionDO.setActionStrategy(actionStrategy);
        this.buildQFilter();
        this.getRecords();
    }

    private void pushRecordEvent() {
        if (EmptyUtils.isEmpty((Object)this.pushActionDO.getRecords())) {
            String msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u653f\u7b56[%s]\u672a\u8fc7\u6ee4\u5230\u6e90\u5355[%s]\u6570\u636e,\u4f7f\u7528\u6761\u4ef6[%s]", (String)"RecordToActionServiceImpl_0", (String)"fi-dcm-business", (Object[])new Object[0]), this.pushActionDO.getActionStrategy().get("number"), this.taskContext.getSrcBillEntity(), this.pushActionDO.getqFilters().toString());
            this.printErrorLog(msg);
            return;
        }
        this.beforePushRecord();
        this.executePushRecord();
        this.afterPushRecord();
        if (this.pushActionDO.getRecords().length == this.taskContext.getSelectNum()) {
            this.pushRecordEvent();
        }
    }

    public void beforePushRecord() {
        this.sendMsgToManger();
        this.pushActionDO.setPush(this.isAllowPush());
        if (this.pushActionDO.isPush()) {
            this.fillRecordEntry();
        }
    }

    public void executePushRecord() {
        if (this.pushActionDO.isPush()) {
            this.pushRecord();
        }
    }

    public void afterPushRecord() {
        this.sendMsgToCustomer();
    }

    public boolean isAllowPush() {
        DynamicObject strategy = this.pushActionDO.getActionStrategy();
        DynamicObjectCollection collection = strategy.getDynamicObjectCollection("actionentry");
        return !CollectionUtils.isEmpty((Collection)collection);
    }

    private void pushRecord() {
        HashSet<Long> oldActionIds = new HashSet<Long>(128);
        for (DynamicObject record : this.pushActionDO.getRecords()) {
            DynamicObjectCollection actionDetailEntry = record.getDynamicObjectCollection("actiondetailentry");
            for (DynamicObject row : actionDetailEntry) {
                oldActionIds.add(row.getLong("ac_actiontbillid"));
            }
        }
        OperationResult pushAndSaveResult = this.saveNewActions();
        if (pushAndSaveResult != null) {
            if (!pushAndSaveResult.isSuccess()) {
                this.printErrorLog("PushCollectionActionsHelper pushandsave record failure , msg is " + pushAndSaveResult.getMessage());
                this.printErrorLog("PushCollectionActionsHelper pushandsave record failure , validator is " + pushAndSaveResult.getAllErrorOrValidateInfo());
            } else {
                this.printInfoLog("PushCollectionActionsHelper pushandsave succeed ! ");
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"dcm_collrecord", (Long[])((Long[])Arrays.stream(this.pushActionDO.getRecords()).map(bill -> (Long)bill.getPkValue()).toArray(Long[]::new)));
                HashSet allActionIds = (HashSet)targetBills.get("dcm_collaction");
                if (EmptyUtils.isEmpty(oldActionIds) && EmptyUtils.isNotEmpty((Object)allActionIds)) {
                    this.pushActionDO.setNewActionIds(new ArrayList(allActionIds));
                } else {
                    this.pushActionDO.setNewActionIds(allActionIds.stream().filter(pk -> !oldActionIds.contains(pk)).collect(Collectors.toList()));
                }
            }
        }
    }

    public void sendMsgToCustomer() {
        if (EmptyUtils.isNotEmpty((Object)this.pushActionDO.getNewActionIds())) {
            MessageHandleImpl sendMessage = new MessageHandleImpl();
            ((AbstractMessageHandle)sendMessage).sendMsg(this.pushActionDO.getNewActionIds(), null);
        }
    }

    private OperationResult saveNewActions() {
        OperationResult pushAndSaveResult = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])this.pushActionDO.getRecords());
                this.printErrorLog("PushCollectionActionsHelper save record succeed !");
                pushAndSaveResult = OperationServiceHelper.executeOperate((String)"pushandsave", (String)"dcm_collrecord", (DynamicObject[])this.pushActionDO.getRecords(), (OperateOption)OperateOption.create());
            }
            catch (Exception e) {
                this.printErrorLog("PushCollectionActionsHelper pushandsave failure ! Error : " + e.getMessage());
                txHandle.markRollback();
                throw e;
            }
            finally {
                if (pushAndSaveResult == null || !pushAndSaveResult.isSuccess()) {
                    this.printErrorLog("PushCollectionActionsHelper pushandsave failure ! Need to rollback actionDetailEntry");
                    txHandle.markRollback();
                }
            }
        }
        return pushAndSaveResult;
    }

    public void fillRecordEntry() {
        DynamicObject strategy = this.pushActionDO.getActionStrategy();
        DynamicObjectCollection collection = strategy.getDynamicObjectCollection("actionentry");
        Map<Long, PreFillRowDao> actionMap = this.buildRowMap(collection);
        for (DynamicObject record : this.pushActionDO.getRecords()) {
            DynamicObjectType entryType = (DynamicObjectType)record.getDataEntityType();
            DynamicObjectType entryType1 = ((EntryProp)entryType.getProperty("actiondetailentry")).getDynamicCollectionItemPropertyType();
            int seq = this.getLargeSeq(record);
            for (Map.Entry<Long, PreFillRowDao> action : actionMap.entrySet()) {
                Long rowId = action.getKey();
                PreFillRowDao rowDao = action.getValue();
                List inners = rowDao.getInner();
                for (DynamicObject inner : inners) {
                    DynamicObject row = new DynamicObject(entryType1);
                    row.set("seq", (Object)(++seq));
                    row.set("ac_strategyid", (Object)strategy);
                    row.set("ac_strategyentryid", (Object)rowId);
                    row.set("ac_inneruser", (Object)inner);
                    row.set("ac_innerposition", (Object)rowDao.getPositionId());
                    row.set("ac_collectiontpl", (Object)rowDao.getCollTpl());
                    row.set("ac_isautoexecute", (Object)rowDao.getAutoColl());
                    record.getDynamicObjectCollection("actiondetailentry").add((Object)row);
                }
            }
        }
    }

    protected Map<Long, PreFillRowDao> buildRowMap(DynamicObjectCollection collection) {
        DynamicObject strategy = this.pushActionDO.getActionStrategy();
        Long orgId = strategy.getLong("createorg.id");
        Set posionSet = collection.stream().map(t -> t.getLong("ac_collinnerposition.id")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("position.id", "in", posionSet).and("createorg.id", "=", (Object)orgId)};
        Map collUsers = BusinessDataServiceHelper.loadFromCache((String)"dcm_colluser", (String)"position,createorg,specperson", (QFilter[])filters);
        HashMap<Long, PreFillRowDao> actionMap = new HashMap<Long, PreFillRowDao>(8);
        for (int i = 0; i < collection.size(); ++i) {
            PreFillRowDao rowDao = new PreFillRowDao();
            ArrayList<DynamicObject> userList = new ArrayList<DynamicObject>(10);
            DynamicObject innerPosition = ((DynamicObject)collection.get(i)).getDynamicObject("ac_collinnerposition");
            DynamicObject tpl = ((DynamicObject)collection.get(i)).getDynamicObject("ac_collectiontpl");
            Long rowId = ((DynamicObject)collection.get(i)).getLong("id");
            for (DynamicObject user : collUsers.values()) {
                Long posionId = user.getDynamicObject("position").getLong("id");
                if (innerPosition.getLong("id") != posionId.longValue()) continue;
                userList.add(user.getDynamicObject("specperson"));
            }
            if (userList.size() > 1) {
                rowDao.setAutoColl(Boolean.valueOf(((DynamicObject)collection.get(i)).getBoolean("ac_isautoexecute")));
            } else {
                rowDao.setAutoColl(Boolean.TRUE);
            }
            rowDao.setCollTpl(tpl);
            rowDao.setInner(userList);
            rowDao.setPositionId(Long.valueOf(innerPosition.getLong("id")));
            actionMap.put(rowId, rowDao);
        }
        return actionMap;
    }

    private int getLargeSeq(DynamicObject bill) {
        int seq = 0;
        DynamicObjectCollection actionDetailEntry = bill.getDynamicObjectCollection("actiondetailentry");
        for (DynamicObject row : actionDetailEntry) {
            seq = Math.max(seq, row.getInt("seq"));
        }
        return seq;
    }

    public void sendMsgToManger() {
        MessageHandleByRecordImpl sendMessage = new MessageHandleByRecordImpl();
        if (CollectionUtils.isNotEmpty((Object[])this.pushActionDO.getRecords())) {
            DynamicObject[] records = this.pushActionDO.getRecords();
            List<Long> recordIds = Arrays.stream(records).map(t -> t.getLong("id")).collect(Collectors.toList());
            ((AbstractMessageHandle)sendMessage).sendMsg(recordIds, this.pushActionDO.getActionStrategy().getLong("id"));
        }
    }

    protected void getRecords() {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"dcm_collrecord", (String)String.join((CharSequence)",", this.getRecordSelector()), (QFilter[])this.pushActionDO.getqFilters().toArray(new QFilter[0]), (String)"createtime asc", (int)this.taskContext.getSelectNum());
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(records.length);
        for (DynamicObject record : records) {
            DynamicObject latestStrategy = this.getLatestStrategy(record.getDynamicObjectCollection("actiondetailentry"));
            DynamicObject strategy = this.pushActionDO.getActionStrategy();
            if (latestStrategy != null && strategy.getLong("id") == latestStrategy.getLong("id")) continue;
            recordList.add(record);
        }
        if (EmptyUtils.isNotEmpty(recordList)) {
            this.pushActionDO.setRecords(recordList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject getLatestStrategy(DynamicObjectCollection entry) {
        if (EmptyUtils.isEmpty((Object)entry)) {
            return null;
        }
        DynamicObject latestRow = null;
        for (DynamicObject row : entry) {
            if (latestRow != null && (row.getDate("ac_actioncreatedate") == null || row.getDate("ac_actioncreatedate").compareTo(latestRow.getDate("ac_actioncreatedate")) <= 0)) continue;
            latestRow = row;
        }
        return latestRow != null ? latestRow.getDynamicObject("ac_strategyid") : null;
    }

    protected void buildQFilter() {
        if (this.pushActionDO.getActionStrategy().getDynamicObject("billentity") == null || StringUtils.isBlank((String)StringUtils.toSafeString((Object)this.pushActionDO.getActionStrategy().getDynamicObject("billentity").getPkValue()))) {
            return;
        }
        List buildFilters = StrategyFilterUtils.buildStrategyFilters((DynamicObject)this.pushActionDO.getActionStrategy());
        buildFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        buildFilters.add(new QFilter("collectiostatus", "=", (Object)"A"));
        this.pushActionDO.setqFilters(buildFilters);
    }

    protected void getSrcBillEntity() {
        String billEntityNumber = StringUtils.toSafeString((Object)this.taskContext.getActionStrategys()[0].getDynamicObject("billentity").getPkValue());
        if (StringUtils.isBlank((String)billEntityNumber)) {
            String msg = ResManager.loadKDString((String)"\u50ac\u6536\u653f\u7b56[%s]\u672a\u914d\u7f6e[\u5355\u636e\u7c7b\u578b],\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"RecordToActionServiceImpl_1", (String)"fi-dcm-business", (Object[])new Object[]{this.pushActionDO.getActionStrategy().get("number")});
            throw new KDBizException(msg);
        }
        this.taskContext.setSrcBillEntity(billEntityNumber);
    }

    public PushActionDO getPushActionDO() {
        return this.pushActionDO;
    }

    public List<String> getRecordSelector() {
        ArrayList<String> selector = new ArrayList<String>(24);
        selector.add("customergroup");
        selector.add("billstatus");
        selector.add("overdueamt");
        selector.add("currency");
        selector.add("billno");
        selector.add("earlistdate");
        selector.add("lastestdate");
        selector.add("overdueday");
        selector.add("actiondetailentry.ac_actionbillno");
        selector.add("actiondetailentry.ac_collectiondate");
        selector.add("actiondetailentry.ac_collectionmethod");
        selector.add("actiondetailentry.ac_collectionbackamt");
        selector.add("actiondetailentry.ac_currency");
        selector.add("actiondetailentry.ac_innerposition");
        selector.add("actiondetailentry.ac_inneruser");
        selector.add("actiondetailentry.ac_guestposition");
        selector.add("actiondetailentry.ac_guestuser");
        selector.add("actiondetailentry.ac_directions");
        selector.add("actiondetailentry.ac_actiontbillid");
        selector.add("actiondetailentry.ac_actioncreatedate");
        selector.add("actiondetailentry.ac_strategyid");
        selector.add("actiondetailentry.ac_ispush");
        selector.add("actiondetailentry.ac_strategyentryid");
        selector.add("actiondetailentry.ac_overdueamt");
        selector.add("actiondetailentry.seq");
        selector.add("actiondetailentry.ac_collectiontpl");
        selector.add("ac_isautoexecute");
        return selector;
    }
}

