/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dcm.business.task.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.fi.dcm.common.task.AbstractTaskService;
import kd.fi.dcm.common.task.TaskContext;
import kd.fi.dcm.common.task.TaskResult;
import kd.fi.dcm.common.task.model.RecordUpdateDo;
import kd.fi.dcm.common.util.CollectionUtils;
import kd.fi.dcm.common.util.StringUtils;

public abstract class AbstractRecordUpdateService
extends AbstractTaskService {
    protected RecordUpdateDo recordUpdateDo = new RecordUpdateDo();

    public AbstractRecordUpdateService(TaskContext taskContext, TaskResult taskResult) {
        super(taskContext, taskResult);
    }

    public void executeByManual() {
        this.initializeTaskArgs();
        this.matchSrcData();
        this.updateCollRecords();
    }

    public void initializeTaskArgs() {
        this.getSrcBillEntity();
        this.initCollRecordData();
        this.initBotpRuleData();
    }

    protected void updateCollRecords() {
        if (CollectionUtils.isEmpty((Collection)this.recordUpdateDo.getUpdateRecordBills())) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.updateDBDate();
                this.invokeRecordSave(this.recordUpdateDo.getRecordIds());
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private void updateDBDate() {
        String msg;
        String upadateSql = "UPDATE t_dcm_collrecordsrcentry SET fsrcamount=?,fsrcoveramount=?  WHERE fentryid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        HashSet<Long> recordIds = new HashSet<Long>(1);
        for (DynamicObject bill : this.recordUpdateDo.getUpdateRecordBills()) {
            Long entryId = bill.getLong("entryId");
            if (entryId == null) continue;
            Object[] param = new Object[]{bill.getBigDecimal("srcAmount"), bill.getBigDecimal("srcOverAmount"), entryId};
            params.add(param);
            recordIds.add(bill.getLong("id"));
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        DBRoute dcm = DBRoute.of((String)"fi");
        int[] res = DB.executeBatch((DBRoute)dcm, (String)upadateSql, params);
        if (res == null) {
            msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6\u66f4\u65b0[\u5931\u8d25],\u5355\u636eID[%s]", (String)"RecordUpdateHelper_0", (String)"fi-dcm-common", (Object[])new Object[0]), params);
            this.printInfoLog(msg);
        } else {
            msg = String.format(ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6\u66f4\u65b0[\u6210\u529f],\u6210\u529f\u5904\u7406[%s]\u5f20\u5355\u636e", (String)"RecordUpdateHelper_1", (String)"fi-dcm-common", (Object[])new Object[0]), res[0]);
            this.printErrorLog(msg);
        }
        this.recordUpdateDo.setRecordIds(recordIds);
    }

    protected void matchSrcData() {
        if (this.recordUpdateDo.getRuleRecordsMap().isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.recordUpdateDo.getRuleRecordsMap().entrySet()) {
            String ruleId = (String)entry.getKey();
            List recordBills = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)recordBills)) continue;
            List<QFilter> qFilters = this.buildQFilter(recordBills);
            if (StringUtils.isBlank((String)this.taskContext.getSrcBillEntity())) {
                String msg = ResManager.loadKDString((String)"\u50ac\u6536\u7ba1\u7406\uff1a\u8f6c\u6362\u8def\u7ebf[%s]\u50ac\u6536\u6863\u6848.\u6e90\u5355\u660e\u7ec6.\u4e1a\u52a1\u5355\u636e\u672a\u6307\u5b9a,\u8bf7\u68c0\u67e5BOTP\u914d\u7f6e\uff01", (String)"RecordUpdateHelper_4", (String)"fi-dcm-common", (Object[])new Object[]{ruleId});
                throw new KDBizException(msg);
            }
            this.getSrcBill(qFilters, ruleId);
            if (CollectionUtils.isEmpty((Collection)this.recordUpdateDo.getSrcBills())) continue;
            this.match(ruleId);
        }
    }

    private void match(String ruleId) {
        List srcAmtFields = (List)this.recordUpdateDo.getRuleFieldMapping().get(ruleId);
        if (CollectionUtils.isEmpty((Collection)srcAmtFields)) {
            return;
        }
        List updateRecordBills = this.recordUpdateDo.getUpdateRecordBills();
        for (DynamicObject srcBill : this.recordUpdateDo.getSrcBills()) {
            String key = srcBill.getString("id") + "_" + srcBill.getString("entryId");
            DynamicObject recordBill = (DynamicObject)this.recordUpdateDo.getRecordBillMap().get(key);
            if (recordBill == null) continue;
            if (recordBill.getBigDecimal("srcAmount").compareTo(srcBill.getBigDecimal("f0")) != 0) {
                recordBill.set("srcAmount", (Object)srcBill.getBigDecimal("f0"));
            }
            if (recordBill.getBigDecimal("srcOverAmount").compareTo(srcBill.getBigDecimal("f1")) != 0) {
                recordBill.set("srcOverAmount", (Object)srcBill.getBigDecimal("f1"));
            }
            updateRecordBills.add(recordBill);
        }
        this.recordUpdateDo.setUpdateRecordBills(updateRecordBills);
    }

    private void getSrcBill(List<QFilter> qFilters, String ruleId) {
        ArrayList<String> selectField = new ArrayList<String>(1);
        List srcAmtFields = (List)this.recordUpdateDo.getRuleFieldMapping().get(ruleId);
        selectField.addAll(srcAmtFields);
        selectField.add("id");
        if (StringUtils.isNotBlank((String)this.recordUpdateDo.getSrcEntryEntity())) {
            selectField.add(this.recordUpdateDo.getSrcEntryEntity() + ".id entryId");
        } else {
            selectField.add("0 entryId");
        }
        DynamicObjectCollection srcBills = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), this.taskContext.getSrcBillEntity(), StringUtils.join(selectField), qFilters.toArray(new QFilter[0]));){
            srcBills = orm.toPlainDynamicObjectCollection(ds);
        }
        this.recordUpdateDo.setSrcBills(srcBills);
    }

    private List<QFilter> buildQFilter(List<DynamicObject> recordStrategys) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        String srcEntryEntity = "";
        ArrayList<Long> qFilterIdsTmp = new ArrayList<Long>(1);
        ArrayList<Long> qFilterEntryIdsTmp = new ArrayList<Long>(1);
        for (DynamicObject recordStrate : recordStrategys) {
            if (StringUtils.isBlank((String)srcEntryEntity)) {
                srcEntryEntity = recordStrate.getString("srcEntryEntity");
            }
            if (StringUtils.isNotBlank((String)recordStrate.getString("srcEntryEntity"))) {
                qFilterEntryIdsTmp.add(recordStrate.getLong("srcEntryId"));
            }
            qFilterIdsTmp.add(recordStrate.getLong("srcBillId"));
        }
        if (StringUtils.isNotBlank((String)srcEntryEntity) && CollectionUtils.isNotEmpty(qFilterEntryIdsTmp)) {
            qFilters.add(new QFilter(srcEntryEntity + ".id", "in", qFilterEntryIdsTmp));
        }
        if (CollectionUtils.isNotEmpty(qFilterIdsTmp)) {
            qFilters.add(new QFilter("id", "in", qFilterIdsTmp));
        }
        this.recordUpdateDo.setSrcEntryEntity(srcEntryEntity);
        return qFilters;
    }

    private void initCollRecordData() {
        this.getNeedUpdateRecord();
        if (this.recordUpdateDo.getRecordBills() == null) {
            return;
        }
        ArrayList<String> srcEntityNames = new ArrayList<String>(128);
        HashMap<String, ArrayList<DynamicObject>> ruleRecordsMap = new HashMap<String, ArrayList<DynamicObject>>(1);
        HashMap<String, DynamicObject> recordBillMap = new HashMap<String, DynamicObject>(1);
        for (DynamicObject recordBill : this.recordUpdateDo.getRecordBills()) {
            ArrayList<DynamicObject> recordBills;
            if (!srcEntityNames.contains(recordBill.getString("billEntity"))) {
                srcEntityNames.add(recordBill.getString("billEntity"));
            }
            if (CollectionUtils.isEmpty((Collection)(recordBills = (ArrayList<DynamicObject>)ruleRecordsMap.get(recordBill.getString("botpRuleId"))))) {
                recordBills = new ArrayList<DynamicObject>(1);
            }
            recordBills.add(recordBill);
            ruleRecordsMap.put(recordBill.getString("botpRuleId"), recordBills);
            String entryId = "0";
            if (StringUtils.isNotBlank((String)recordBill.getString("srcEntryId"))) {
                entryId = recordBill.getString("srcEntryId");
            }
            String key = recordBill.getString("srcBillId") + "_" + entryId;
            recordBillMap.put(key, recordBill);
        }
        this.recordUpdateDo.setRecordBillMap(recordBillMap);
        this.recordUpdateDo.setRuleRecordsMap(ruleRecordsMap);
        this.recordUpdateDo.setSrcEntityNames(srcEntityNames);
    }

    public void getNeedUpdateRecord() {
        DynamicObjectCollection recordBills = null;
        if (Boolean.TRUE.equals(this.recordUpdateDo.getByManual())) {
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "dcm_collrecord", StringUtils.join((Collection)this.getCollRecordSeleteField()), new QFilter[]{new QFilter("srcentry.id", "in", (Object)this.recordUpdateDo.getUpdateEntryIds())});){
                recordBills = orm.toPlainDynamicObjectCollection(ds);
            }
        } else {
            recordBills = this.getCollRecordBills(2, Boolean.FALSE);
        }
        this.recordUpdateDo.setRecordBills(recordBills);
    }

    private void initBotpRuleData() {
        for (String string : this.recordUpdateDo.getSrcEntityNames()) {
            Map ruleElementsMap = this.recordUpdateDo.getRuleElementsMap();
            if (CollectionUtils.isNotEmpty((Collection)((Collection)ruleElementsMap.get(string)))) continue;
            List convertRuleMetadata = ConvertMetaServiceHelper.loadRules((String)string, (String)"dcm_collrecord");
            ruleElementsMap.put(string, convertRuleMetadata);
            this.recordUpdateDo.setRuleElementsMap(ruleElementsMap);
        }
        for (Map.Entry entry : this.recordUpdateDo.getRuleElementsMap().entrySet()) {
            String srcEntityNumber = (String)entry.getKey();
            List ruleElements = (List)entry.getValue();
            for (ConvertRuleElement ruleElement : ruleElements) {
                this.setRuleFieldMappingData(srcEntityNumber, ruleElement);
            }
        }
    }

    protected void setRuleFieldMappingData(String srcEntityNumber, ConvertRuleElement ruleElement) {
        Map ruleFieldMapping = this.recordUpdateDo.getRuleFieldMapping();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)ruleFieldMapping.get(ruleElement.getId())))) {
            return;
        }
        ArrayList<String> tarFields = new ArrayList<String>(1);
        tarFields.add("e_srcamount");
        tarFields.add("e_srcoveramount");
        FieldMapPolicy fieldMapPolicy = ruleElement.getFieldMapPolicy();
        ArrayList<String> fieldMapping = new ArrayList<String>(1);
        for (int i = 0; i < tarFields.size(); ++i) {
            for (FieldMapItem fieldMap : fieldMapPolicy.getFieldMaps()) {
                if (!((String)tarFields.get(i)).equals(fieldMap.getTargetFieldKey())) continue;
                String srcEntryNumber = this.getSrcFieldEntityNumber(srcEntityNumber, fieldMap.getSourceFieldKey());
                if (StringUtils.isBlank((String)srcEntryNumber)) {
                    fieldMapping.add("NULL f" + i);
                }
                fieldMapping.add(srcEntryNumber + "." + fieldMap.getSourceFieldKey() + " f" + i);
                break;
            }
            if (CollectionUtils.isEmpty(fieldMapping) && fieldMapping.size() == tarFields.size()) break;
        }
        ruleFieldMapping.put(ruleElement.getId(), fieldMapping);
        this.recordUpdateDo.setRuleFieldMapping(ruleFieldMapping);
    }

    private String getSrcFieldEntityNumber(String srcEntityNumber, String srcFieldKey) {
        Map srcMainEntityType = this.recordUpdateDo.getSrcMainEntityType();
        MainEntityType mainEntityType = (MainEntityType)srcMainEntityType.get(srcEntityNumber);
        if (mainEntityType == null) {
            mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityNumber);
            srcMainEntityType.put(srcEntityNumber, mainEntityType);
            this.recordUpdateDo.setSrcMainEntityType(srcMainEntityType);
        }
        for (Map.Entry entries : mainEntityType.getAllEntities().entrySet()) {
            for (Map.Entry fieldEntityNumber : ((EntityType)entries.getValue()).getFields().entrySet()) {
                if (!((String)fieldEntityNumber.getKey()).equals(srcFieldKey)) continue;
                return (String)entries.getKey();
            }
        }
        return null;
    }

    public RecordUpdateDo getRecordUpdateDo() {
        return this.recordUpdateDo;
    }
}

