/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.enums.ExceptionTypeEnum;
import kd.fi.dhc.factory.ExceptionRerunFactory;
import kd.fi.dhc.opplugin.ExceptionRecordRerunValidator;
import kd.fi.dhc.service.ExceptionService;

public class ExceptionRecordRerunPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ExceptionRecordRerunPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("canretry");
        fieldKeys.add("exctype");
        fieldKeys.add("billtype");
        fieldKeys.add("billid");
        fieldKeys.add("billnumber");
        fieldKeys.add("state");
        fieldKeys.add("retrytime");
        fieldKeys.add("billid");
        fieldKeys.add("excargument_tag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExceptionRecordRerunValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successDataList = new ArrayList<DynamicObject>();
        for (DynamicObject data : dataEntities) {
            String excType = data.getString("exctype");
            ExceptionTypeEnum exceptionType = ExceptionTypeEnum.getExceptionType((String)excType);
            if (exceptionType == null) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u7c7b\u578b\u6ca1\u6709\u5b9e\u73b0\u201d\u91cd\u65b0\u6267\u884c\u201c\u670d\u52a1", (String)"ExceptionRecordRerunPlugin_0", (String)"fi-dhc-opplugin", (Object[])new Object[0]);
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(data.getPkValue(), msg));
                continue;
            }
            ExceptionService service = ExceptionRerunFactory.getService((ExceptionTypeEnum)exceptionType);
            try {
                service.reRun(data);
                data.set("state", (Object)"1");
                successDataList.add(data);
            }
            catch (Exception ex) {
                log.error("dhc handle exception record error -- ", (Throwable)ex);
                data.set("state", (Object)"0");
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(data.getPkValue(), ex.getMessage()));
            }
            catch (NoClassDefFoundError error) {
                log.error("dhc handle exception record error -- not config sdk-fi", (Throwable)error);
                data.set("state", (Object)"0");
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u914d\u7f6essc\u5bb9\u5668\u8282\u70b9\u7684sdk-fi\u4f9d\u8d56\u3002", (String)"ExceptionRecordRerunPlugin_1", (String)"fi-dhc-opplugin", (Object[])new Object[0]);
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(data.getPkValue(), errorMsg));
            }
            data.set("retrytime", (Object)new Date());
        }
        e.setDataEntities(successDataList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private ValidationErrorInfo buildErrMessage(Object pkValue, String msg) {
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        return new ValidationErrorInfo("", pkValue, dataIndex, rowIndex, "errorcode_001", "", msg, errorLevel);
    }
}

