/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.webapi.inquirybill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.SelectsModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.mircoservice.result.ServiceResult;
import kd.fi.dhc.mircoservice.helper.InquiryBillServiceHelper;

public class QueryQuestionSubTypesApiPlugin
extends AbstractBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(QueryQuestionSubTypesApiPlugin.class);

    public void doAICommand(AICommandEvent e) {
        this.logInfo("QueryQuestionSubTypesApiPlugin doAICommand accept a request");
        ApiResult apiResult = null;
        try {
            ServiceResult serviceResult = this.invokeService();
            apiResult = serviceResult.toApiResultWithoutData();
            if (apiResult.getSuccess()) {
                this.setApiResultData(apiResult, (ServiceResult<List<JSONObject>>)serviceResult);
            }
        }
        catch (Exception ex) {
            apiResult = ApiResult.ex((Throwable)ex);
            this.logError("QueryQuestionSubTypesApiPlugin doAICommand occur exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        this.logInfo("QueryQuestionSubTypesApiPlugin doAICommand response result:" + JSON.toJSONString((Object)apiResult));
        apiResult.setSuccess(true);
        e.setResult(apiResult);
    }

    private ServiceResult invokeService() {
        String jsonResult = InquiryBillServiceHelper.queryQuestionSubTypes();
        return (ServiceResult)JSON.parseObject((String)jsonResult, ServiceResult.class);
    }

    private void setApiResultData(ApiResult apiResult, ServiceResult<List<JSONObject>> serviceResult) {
        List assistantDataList = (List)serviceResult.getData();
        if (!CollectionUtils.isEmpty((Collection)assistantDataList)) {
            SelectsModel selectsModel = this.createSelectsModel(assistantDataList);
            ResponseModel responseModel = ResponseModel.createSelectsResponse((SelectsModel)selectsModel);
            apiResult.setData((Object)responseModel);
        }
    }

    private SelectsModel createSelectsModel(List<JSONObject> assistantDataList) {
        ArrayList<SelectsModel.SelectItem> selects = new ArrayList<SelectsModel.SelectItem>(assistantDataList.size());
        for (JSONObject obj : assistantDataList) {
            SelectsModel.SelectItem item = new SelectsModel.SelectItem(obj.getString("id"), obj.getString("name"));
            selects.add(item);
        }
        return new SelectsModel(ResManager.loadKDString((String)"\u95ee\u9898\u7ec6\u7c7b", (String)"QueryQuestionSubTypesApiPlugin_0", (String)"fi-dhc-webapi", (Object[])new Object[0]), selects);
    }

    private void logInfo(String infoLog) {
        if (logger.isInfoEnabled()) {
            logger.info(infoLog);
        }
    }

    private void logError(String errorLog) {
        if (logger.isErrorEnabled()) {
            logger.error(errorLog);
        }
    }
}

