/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.executor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.bizext.CallExtPluginResponseHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.DataSynErrorCodeEnum;
import kd.fi.dhc.enums.DataSynTypeEnum;
import kd.fi.dhc.enums.RequestBillTypeEnum;
import kd.fi.dhc.service.impl.FieldMapServiceImpl;
import kd.fi.dhc.util.BillClassificationUtil;
import kd.fi.dhc.util.DataSynchronizationUtil;
import kd.fi.dhc.util.DynamicObjectUtils;

public class DataSynchronizationExecutor {
    private static final Log log = LogFactory.getLog(DataSynchronizationExecutor.class);
    private static final String LOG_PREFIX = "-- dhc DataSynchronizationExecutor --";
    public static final HashSet<String> MUST_MAPPING_FIELDS = new HashSet(5);
    private DataSynTypeEnum synDataType;
    private String srcEntityNumber;
    private String srcEntityId;
    private long billKindId;
    private BillStatusProp srcBillStatusProp;
    private DynamicObject[] srcDataEntities;
    private Map<String, String> srcDataImageStatusMap;
    private Set<Object> notExistingSrcDataPkValues;
    private Map<String, String> mappingFiledKeysMap;
    private Map<String, String> extMappingFields;
    private Map<String, String> statusMap;
    DynamicObjectCollection billSubjectRule;
    public static final Map<String, String> THEME_MAP;

    public DataSynchronizationExecutor(DynamicObject[] srcDataEntities, DataSynTypeEnum synDataType) {
        if (srcDataEntities != null && srcDataEntities.length > 0) {
            this.synDataType = synDataType;
            this.srcEntityNumber = srcDataEntities[0].getDynamicObjectType().getName();
            this.srcDataEntities = srcDataEntities;
            this.prepareData(null);
        }
    }

    public DataSynchronizationExecutor(String srcEntityNumber, HashSet<Object> srcDataPkValues, DataSynTypeEnum synDataType) {
        if (srcDataPkValues != null && srcDataPkValues.size() > 0) {
            this.synDataType = synDataType;
            this.srcEntityNumber = srcEntityNumber;
            this.prepareData(srcDataPkValues);
        }
    }

    public void execute() {
        QFilter[] filters;
        if (this.srcDataEntities != null && this.srcDataEntities.length > 0) {
            filters = new QFilter[]{new QFilter("accessedbillnew", "=", (Object)this.srcEntityNumber)};
            Map myBillAccessedDataMap = BusinessDataServiceHelper.loadFromCache((String)"dhc_billaccessed", (String)"masterid", (QFilter[])filters);
            if (myBillAccessedDataMap != null && myBillAccessedDataMap.size() == 0) {
                return;
            }
            Map<Object, DynamicObject> myBillListExistData = this.selectMyBillListData();
            ArrayList<DynamicObject> addNewData = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>();
            HashSet<Object> synStatusErrorDada = new HashSet<Object>();
            for (DynamicObject srcData : this.srcDataEntities) {
                DynamicObject myBillData;
                Object srcDataPkValue = srcData.getPkValue();
                String srcBillStatus = srcData.getString(this.mappingFiledKeysMap.get("billstatus"));
                DynamicObject correspondingData = myBillListExistData.get(srcDataPkValue);
                if (correspondingData != null) {
                    String oldBIllStatus;
                    myBillData = correspondingData;
                    if (DataSynTypeEnum.SYN_STATUS == this.synDataType && (oldBIllStatus = myBillData.getString("billstatus")).equals(srcBillStatus)) continue;
                    updateData.add(myBillData);
                } else if (DataSynTypeEnum.SYN_DATA == this.synDataType) {
                    myBillData = BusinessDataServiceHelper.newDynamicObject((String)"dhc_mybilllist");
                    addNewData.add(myBillData);
                } else {
                    if (DataSynTypeEnum.SYN_STATUS == this.synDataType) {
                        synStatusErrorDada.add(srcDataPkValue);
                        continue;
                    }
                    return;
                }
                myBillData.set("billstatus", (Object)srcBillStatus);
                String billStatusValue = this.srcBillStatusProp.getStatusItem(srcBillStatus) == null ? "" : this.srcBillStatusProp.getStatusItem(srcBillStatus).getStatusName().getLocaleValue();
                myBillData.set("billstatusext", (Object)billStatusValue);
                myBillData.set("reimbursestatus", (Object)this.statusMap.get(srcBillStatus));
                String imgStatus = "0";
                String oldImageStatus = this.srcDataImageStatusMap.get(srcDataPkValue.toString());
                if (oldImageStatus != null && !"1".equals(oldImageStatus)) {
                    imgStatus = oldImageStatus;
                }
                myBillData.set("imagestatus", (Object)imgStatus);
                myBillData.set("imageupdatetime", (Object)new Date());
                if (DataSynTypeEnum.SYN_DATA != this.synDataType) continue;
                myBillData.set("billid", srcDataPkValue);
                myBillData.set("billkind", (Object)this.billKindId);
                String srcEntityId = MetadataDao.getIdByNumber((String)this.srcEntityNumber, (MetaCategory)MetaCategory.Form);
                myBillData.set("bill", (Object)srcEntityId);
                myBillData.set("billnew", (Object)this.srcEntityNumber);
                myBillData.set("billsubject", (Object)this.getBillSubject(srcData));
                HashMap<String, Map<String, String>> entryFieldMap = new HashMap<String, Map<String, String>>(2);
                for (Map.Entry<String, String> en : this.mappingFiledKeysMap.entrySet()) {
                    String dhcFieldKey = en.getKey();
                    String srcFieldKey = en.getValue();
                    if (dhcFieldKey.contains(".")) {
                        String[] dhcEntryField = dhcFieldKey.split("\\.");
                        String[] srcEntryField = srcFieldKey.split("\\.");
                        if (dhcEntryField.length <= 1 || srcEntryField.length <= 1) continue;
                        entryFieldMap.computeIfAbsent(dhcEntryField[0] + "-" + srcEntryField[0], k -> new HashMap(4)).put(dhcEntryField[1], srcEntryField[1]);
                        continue;
                    }
                    Object srcFiledValue = srcData.get(srcFieldKey);
                    if (srcFiledValue == null && ("creator".equals(srcFieldKey) || "applicant".equals(srcFieldKey) || "company".equals(srcFieldKey))) {
                        srcFiledValue = srcData.get(srcFieldKey + "_id");
                    }
                    myBillData.set(dhcFieldKey, srcFiledValue);
                }
                this.synEntryData(myBillData, srcData, entryFieldMap);
            }
            if (addNewData.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])addNewData.toArray(new DynamicObject[0]));
            }
            if (updateData.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
            }
            if (synStatusErrorDada.size() > 0) {
                log.info(LOG_PREFIX + String.format("\u540c\u6b65\u6211\u7684\u62a5\u8d26\u6570\u636e\u72b6\u6001\u65f6\uff0c\u5b9e\u4f53%s\u8981\u540c\u6b65\u72b6\u6001\u7684\u6570\u636e%s\u5728\u6211\u7684\u62a5\u8d26\u4e0d\u5b58\u5728\u6570\u636e", this.srcEntityNumber, synStatusErrorDada));
            }
        }
        if (this.notExistingSrcDataPkValues != null && this.notExistingSrcDataPkValues.size() > 0) {
            filters = new QFilter[]{new QFilter("billnew", "=", (Object)this.srcEntityNumber), new QFilter("billid", "in", this.notExistingSrcDataPkValues)};
            DeleteServiceHelper.delete((String)"dhc_mybilllist", (QFilter[])filters);
        }
    }

    private void prepareData(HashSet<Object> srcDataPkValues) {
        this.prepareMappingFiledKeysMap();
        if (DataSynTypeEnum.SYN_DATA == this.synDataType) {
            this.billKindId = BillClassificationUtil.getBillClassificationFromBillNumber(this.srcEntityNumber);
            this.prepareBillSubjectRule();
        }
        this.prepareSrcBillStatus();
        if (srcDataPkValues != null) {
            this.prepareSrcData(srcDataPkValues);
        }
        this.prepareSrcDataImageStatus();
    }

    private void prepareMappingFiledKeysMap() {
        Map<String, String> filedMappingMap = DataSynchronizationUtil.getFiledMappingMap(this.srcEntityNumber);
        if (filedMappingMap == null) {
            ErrorCode code = new ErrorCode(DataSynErrorCodeEnum.LACK_BILL_MAPPING_CONFIG.getCode(), String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u4e0d\u5b58\u5728\u62a5\u8d26\u5355\u636e\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSynchronizationExecutor_0", (String)"fi-dhc-common", (Object[])new Object[0]), this.srcEntityNumber));
            throw new KDException(code, new Object[0]);
        }
        for (String fieldKey : MUST_MAPPING_FIELDS) {
            if (!StringUtils.isEmpty((String)filedMappingMap.get(fieldKey))) continue;
            ErrorCode code = new ErrorCode(DataSynErrorCodeEnum.LACK_MUST_CONFIG_FIELD.getCode(), String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u7684\u62a5\u8d26\u5355\u636e\u914d\u7f6e\u7f3a\u5c11\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSynchronizationExecutor_1", (String)"fi-dhc-common", (Object[])new Object[0]), this.srcEntityNumber));
            throw new KDException(code, new Object[0]);
        }
        if (StringUtils.isEmpty((String)filedMappingMap.get("amount"))) {
            filedMappingMap.remove("amount");
        }
        this.mappingFiledKeysMap = filedMappingMap;
        Map<String, String> extMappingFields = CallExtPluginResponseHelper.getExtMappingFields(this.srcEntityNumber);
        if (extMappingFields != null && extMappingFields.size() > 0) {
            this.extMappingFields = extMappingFields;
            this.mappingFiledKeysMap.putAll(extMappingFields);
        }
    }

    private void prepareBillSubjectRule() {
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        String billSubjectIdTmp = service.getBillSubjectPkId(this.srcEntityNumber);
        if (StringUtils.isEmpty((String)billSubjectIdTmp)) {
            return;
        }
        long billSubjectId = Long.parseLong(billSubjectIdTmp);
        DynamicObject billSubject = BusinessDataServiceHelper.loadSingle((Object)billSubjectId, (String)"dhc_billsubject");
        if (billSubject != null) {
            this.billSubjectRule = billSubject.getDynamicObjectCollection("entryentity");
            if (this.billSubjectRule != null && this.billSubjectRule.size() > 0) {
                this.billSubjectRule.sort((o1, o2) -> {
                    int s1 = (Integer)o1.get("seq");
                    int s2 = (Integer)o2.get("seq");
                    return s1 - s2;
                });
            }
        }
    }

    private void prepareSrcBillStatus() {
        String srcBillStatusField = this.mappingFiledKeysMap.get("billstatus");
        this.srcBillStatusProp = (BillStatusProp)EntityMetadataCache.getDataEntityType((String)this.srcEntityNumber).getProperty(srcBillStatusField);
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        Map<String, String> statusMap = service.getStatusMap(this.srcEntityNumber);
        if (statusMap == null) {
            ErrorCode code = new ErrorCode(DataSynErrorCodeEnum.LACK_STATUS_MAPPING_CONFIG.getCode(), String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u7684\u62a5\u8d26\u5355\u636e\u914d\u7f6e\u7f3a\u5c11\u201c\u62a5\u8d26\u72b6\u6001\u201d\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSynchronizationExecutor_2", (String)"fi-dhc-common", (Object[])new Object[0]), this.srcEntityNumber));
            throw new KDException(code, new Object[0]);
        }
        this.statusMap = statusMap;
    }

    private void prepareSrcData(HashSet<Object> srcDataPkValues) {
        HashSet<String> srcSelectedFields = this.getSrcSelectedFields();
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)this.srcEntityNumber, srcSelectedFields);
        DynamicObject[] existingData = BusinessDataServiceHelper.load((Object[])srcDataPkValues.toArray(), (DynamicObjectType)subDataEntityType);
        this.srcDataEntities = existingData;
        Set existingPkValues = Arrays.stream(existingData).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        srcDataPkValues.removeAll(existingPkValues);
        this.notExistingSrcDataPkValues = srcDataPkValues;
    }

    private void prepareSrcDataImageStatus() {
        Set pkValues = Arrays.stream(this.srcDataEntities).map(v -> v.getPkValue().toString()).collect(Collectors.toSet());
        QFilter billIdFilter = new QFilter("billid", "in", pkValues);
        DynamicObjectCollection srcDataImageState = QueryServiceHelper.query((String)"task_billimagemap", (String)"billid,imagestate", (QFilter[])billIdFilter.toArray());
        if (srcDataImageState != null) {
            this.srcDataImageStatusMap = srcDataImageState.stream().collect(Collectors.toMap(im -> im.getString("billid"), im -> im.getString("imagestate"), (im1, im2) -> im2));
        }
    }

    private HashSet<String> getSrcSelectedFields() {
        HashSet<String> selectFields = new HashSet<String>(8);
        if (DataSynTypeEnum.SYN_DATA == this.synDataType) {
            selectFields.addAll(this.mappingFiledKeysMap.values());
            selectFields.addAll(this.getSubjectConfiguredFields());
        } else if (DataSynTypeEnum.SYN_STATUS == this.synDataType) {
            selectFields.add(this.mappingFiledKeysMap.get("billstatus"));
        }
        HashSet<String> notContainsFields = DynamicObjectUtils.entityNotContainsFields(this.srcEntityNumber, selectFields);
        if (notContainsFields != null && notContainsFields.size() > 0) {
            ErrorCode code = new ErrorCode(DataSynErrorCodeEnum.ERROR_BILL_MAPPING_CONFIG.getCode(), String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%1$s\u7684\u201c\u62a5\u8d26\u5355\u636e\u914d\u7f6e\u201d\u5305\u542b\u672a\u77e5\u5c5e\u6027\uff1a%2$s\u3002", (String)"DataSynchronizationExecutor_3", (String)"fi-dhc-common", (Object[])new Object[0]), this.srcEntityNumber, String.join((CharSequence)",", notContainsFields)));
            throw new KDException(code, new Object[0]);
        }
        return selectFields;
    }

    private HashSet<String> getSubjectConfiguredFields() {
        HashSet<String> fields = new HashSet<String>();
        if (this.billSubjectRule != null) {
            for (DynamicObject dyn : this.billSubjectRule) {
                String subField = dyn.getString("mark");
                if (!StringUtils.isNotEmpty((String)subField)) continue;
                int splitIndex = subField.indexOf(".");
                if (splitIndex > 0) {
                    fields.add(subField.substring(0, splitIndex));
                    continue;
                }
                fields.add(subField);
            }
        }
        return fields;
    }

    private Map<Object, DynamicObject> selectMyBillListData() {
        Map myBillListDataMap;
        Map<Object, DynamicObject> re = new HashMap<Object, DynamicObject>();
        Set pkValues = Arrays.stream(this.srcDataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("billid", "in", pkValues), new QFilter("billnew", "=", (Object)this.srcEntityNumber)};
        String selectFields = this.getMyBillListSelectFields();
        if (selectFields != null && (myBillListDataMap = BusinessDataServiceHelper.loadFromCache((String)"dhc_mybilllist", (String)selectFields, (QFilter[])filters)) != null && myBillListDataMap.size() > 0) {
            re = myBillListDataMap.values().stream().collect(Collectors.toMap(m -> m.getLong("billid"), m -> m, (m1, m2) -> m1));
        }
        return re;
    }

    private String getMyBillListSelectFields() {
        if (DataSynTypeEnum.SYN_DATA == this.synDataType) {
            String selectFields = EntityField.buildSelectField("id", "billno", "billid", "billkind", "bill", "billnew", "reimbursestatus", "businessstatus", "billsubject", "amount", "billstatus", "billstatusext", "imagestatus", "applicant", "creator", "createtime", "currency", "company", "imageupdatetime");
            if (this.extMappingFields != null) {
                selectFields = selectFields + "," + String.join((CharSequence)",", this.extMappingFields.keySet());
            }
            return selectFields;
        }
        if (DataSynTypeEnum.SYN_STATUS == this.synDataType) {
            return EntityField.buildSelectField("id", "billid", "reimbursestatus", "businessstatus", "billstatus", "billstatusext", "imagestatus", "imageupdatetime");
        }
        return null;
    }

    private String getBillSubject(DynamicObject billData) {
        if (billData == null) {
            return "";
        }
        StringBuilder billSubject = new StringBuilder();
        if (this.billSubjectRule == null) {
            return billSubject.toString();
        }
        String srcBillStatus = billData.getString(this.mappingFiledKeysMap.get("billstatus"));
        String billStatusValue = this.srcBillStatusProp.getStatusItem(srcBillStatus) == null ? "" : this.srcBillStatusProp.getStatusItem(srcBillStatus).getStatusName().getLocaleValue();
        for (DynamicObject entry : this.billSubjectRule) {
            String postText;
            String element;
            String preText;
            if (billSubject.length() != 0) {
                billSubject.append('_');
            }
            if (StringUtils.isNotEmpty((String)(preText = entry.getString("pretext")))) {
                billSubject.append(preText);
            }
            if (StringUtils.isNotEmpty((String)(element = entry.getString("mark")))) {
                DynamicObject dyn = billData;
                if (element.contains(".")) {
                    String[] elements = element.split("\\.");
                    element = elements[elements.length - 1];
                    String[] elementsTemp = new String[elements.length - 1];
                    System.arraycopy(elements, 0, elementsTemp, 0, elementsTemp.length);
                    for (String ele : elementsTemp) {
                        Object obj = dyn.get(ele);
                        if (obj == null) {
                            dyn = null;
                            break;
                        }
                        if (obj instanceof DynamicObjectCollection) {
                            if (((DynamicObjectCollection)obj).size() > 0) {
                                dyn = (DynamicObject)((DynamicObjectCollection)obj).get(0);
                                continue;
                            }
                            dyn = null;
                            break;
                        }
                        if (!(obj instanceof DynamicObject)) continue;
                        dyn = (DynamicObject)obj;
                    }
                }
                if (dyn != null) {
                    Object ele;
                    String fieldAmount = this.mappingFiledKeysMap.get("amount");
                    String fieldCurrency = this.mappingFiledKeysMap.get("currency");
                    if (StringUtils.isNotEmpty((String)fieldAmount) && StringUtils.isNotEmpty((String)fieldCurrency) && fieldAmount.equalsIgnoreCase(element)) {
                        DynamicObject currency = billData.getDynamicObject(fieldCurrency);
                        String sign = "";
                        if (currency != null) {
                            sign = currency.getString("sign");
                        }
                        billSubject.append(sign);
                    }
                    if ((ele = dyn.get(element)) instanceof BigDecimal) {
                        BigDecimal elementValue = (BigDecimal)ele;
                        ele = elementValue.setScale(2, RoundingMode.UP);
                    }
                    if (ele != null) {
                        if (element.equals("requestbilltype")) {
                            Set collect = Arrays.stream(RequestBillTypeEnum.values()).map(RequestBillTypeEnum::getBillType).collect(Collectors.toSet());
                            if (collect.contains(dyn.getDynamicObjectType().getName())) {
                                ele = RequestBillTypeEnum.getTypeByValAndBillType((String)ele, dyn.getDynamicObjectType().getName()).getName();
                            }
                        } else if (element.equals("billstatus")) {
                            ele = billStatusValue;
                        }
                        billSubject.append(ele);
                    }
                }
            }
            if (!StringUtils.isNotEmpty((String)(postText = entry.getString("posttext")))) continue;
            billSubject.append(postText);
        }
        if (billSubject.length() > 250) {
            return billSubject.substring(0, 250);
        }
        return billSubject.toString();
    }

    private void synEntryData(DynamicObject dhcData, DynamicObject srcData, Map<String, Map<String, String>> entryFieldMapping) {
        if (entryFieldMapping == null || entryFieldMapping.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> entry : entryFieldMapping.entrySet()) {
            String[] entryKey = entry.getKey().split("-");
            String dhcEntryKey = entryKey[0];
            String srcEntryKey = entryKey[1];
            DynamicObjectCollection srcEntryDataCol = srcData.getDynamicObjectCollection(srcEntryKey);
            if (srcEntryDataCol == null || srcEntryDataCol.isEmpty()) continue;
            Map<String, String> fieldMapping = entry.getValue();
            DynamicObjectCollection dhcEntryDataCol = dhcData.getDynamicObjectCollection(dhcEntryKey);
            dhcEntryDataCol.clear();
            for (DynamicObject srcEntryData : srcEntryDataCol) {
                DynamicObject dhcEntryData = dhcEntryDataCol.addNew();
                for (Map.Entry<String, String> ele : fieldMapping.entrySet()) {
                    String dhcEntryFieldKey = ele.getKey();
                    String srcEntryFieldKey = ele.getValue();
                    dhcEntryData.set(dhcEntryFieldKey, srcEntryData.get(srcEntryFieldKey));
                }
            }
        }
    }

    static {
        MUST_MAPPING_FIELDS.add("billno");
        MUST_MAPPING_FIELDS.add("billstatus");
        MUST_MAPPING_FIELDS.add("createtime");
        MUST_MAPPING_FIELDS.add("company");
        MUST_MAPPING_FIELDS.add("applicant");
        THEME_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                this.put("ssc_tallyapplybill", ResManager.loadKDString((String)"\u6807\u51c6\u8bb0\u8d26\u7533\u8bf7\u5355", (String)"MyBillListPlugin_14", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                this.put("fr_glreim_paybill", ResManager.loadKDString((String)"\u6807\u51c6\u603b\u8d26\u4ed8\u6b3e\u7533\u8bf7\u5355", (String)"MyBillListPlugin_15", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                this.put("fr_glreim_recbill", ResManager.loadKDString((String)"\u6807\u51c6\u603b\u8d26\u6536\u6b3e\u7533\u8bf7\u5355", (String)"MyBillListPlugin_16", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
        });
    }
}

