/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.AppTemplate;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.metadata.devportal.DifferenceOperationParseUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AppMetaServiceHelperExt {
    private static final String BOS_DEV_PORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String RESULT_SUCCESS = "success";
    private static final String RESULT_TRUE = "true";

    public static Map<String, Object> save(AppMetadata metadata) {
        AppWriter appWrite;
        Map result = null;
        if (metadata != null && RESULT_TRUE.equalsIgnoreCase((result = (appWrite = new AppWriter()).save(metadata)).get(RESULT_SUCCESS).toString())) {
            PermissionServiceHelper.clearAllUserAppCache();
        }
        return result;
    }

    public static void deleteMenuById(String menuId, String bizAppId) {
        AppMetadata metadata = AppMetaServiceHelperExt.loadAppMetadataById(bizAppId, false);
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuId.equalsIgnoreCase(menu.getId())) continue;
                metadata.getAppMenus().remove(menu);
                AppMetaServiceHelperExt.save(metadata);
                break;
            }
        }
    }

    private static AppMetadata loadAppMetadataById(String bizAppId, boolean runtime) {
        if (!QueryServiceHelper.exists((String)BOS_DEV_PORTAL_BIZ_APP, (Object)bizAppId)) {
            return null;
        }
        AppMetadata metadata = AppReader.loadMeta((String)bizAppId, (boolean)runtime);
        String parentAppId = metadata.getParentId();
        if (!runtime && StringUtils.isNotBlank((CharSequence)parentAppId)) {
            AppMetadata baseMetadata = AppReader.loadMeta((String)parentAppId, (boolean)false);
            String diffXml = AppMetaServiceHelperExt.buildAppMetadataDiffXml(metadata, baseMetadata, false);
            AppMetaServiceHelperExt.compareAppElement(metadata, diffXml);
        }
        return metadata;
    }

    private static String buildAppMetadataDiffXml(AppMetadata metadata, AppMetadata baseMetadata, boolean onlyLocaleValue) {
        AppTemplate template = new AppTemplate();
        String diffXml = template.buildDiffXml(metadata, baseMetadata, onlyLocaleValue);
        return diffXml;
    }

    private static void compareAppElement(AppMetadata metadata, String diffXml) {
        Map<String, Object> operationMap = AppMetaServiceHelperExt.parseDiffOperations(diffXml);
        for (AppMenuElement menu : metadata.getAppMenus()) {
            String operation = (String)operationMap.get(menu.getId());
            if (operation == null) {
                menu.setDevType("1");
                continue;
            }
            if ("addNew".equalsIgnoreCase(operation)) {
                menu.setDevType("3");
                continue;
            }
            if ("edit".equalsIgnoreCase(operation)) {
                menu.setDevType("2");
                continue;
            }
            if (!"remove".equalsIgnoreCase(operation)) continue;
            menu.setDevType("2");
        }
        QFilter bizappFilter = new QFilter("bizapp", "=", (Object)metadata.getId());
        QFilter[] bizappFilters = new QFilter[]{bizappFilter};
        DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet((String)"compareAppElement.bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)"bizunit,form", (QFilter[])bizappFilters, (String)"id asc");
        QFilter bizappFilter1 = new QFilter("bizappid", "=", (Object)metadata.getId());
        QFilter[] bizappFilter1s = new QFilter[]{bizappFilter1};
        DataSet formDataSet = QueryServiceHelper.queryDataSet((String)"compareAppElement.bos_formmeta", (String)"bos_formmeta", (String)"id,number,name", (QFilter[])bizappFilter1s, (String)"number asc");
        DataSet result = unitRelFormDataSet.join(formDataSet, JoinType.INNER).on("form", "id").select(new String[]{"bizunit"}).finish();
        HashMap<String, Boolean> funcContainRes = new HashMap<String, Boolean>();
        for (Row row : result) {
            String funcId = row.getString("bizunit");
            if (funcContainRes.get(funcId) != null && ((Boolean)funcContainRes.get(funcId)).booleanValue()) continue;
            funcContainRes.put(funcId, Boolean.TRUE);
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"bizunitid", (QFilter[])bizappFilter1s);
        if (objs != null) {
            for (DynamicObject obj : objs) {
                String funcId = obj.getString("bizunitid");
                if (funcContainRes.get(funcId) != null && ((Boolean)funcContainRes.get(funcId)).booleanValue()) continue;
                funcContainRes.put(funcId, Boolean.TRUE);
            }
        }
        block3: for (AppFunctionPacketElement func : metadata.getAppFunctionPackets()) {
            String operation = (String)operationMap.get(func.getId());
            if (operation == null) {
                boolean isExist = false;
                if (funcContainRes.get(func.getId()) != null && ((Boolean)funcContainRes.get(func.getId())).booleanValue()) {
                    isExist = true;
                }
                if (isExist) {
                    func.setType("2");
                    if (!StringUtils.isNotBlank((CharSequence)func.getParentId())) continue;
                    for (AppFunctionPacketElement parentFunc : metadata.getAppFunctionPackets()) {
                        if (!func.getParentId().equals(parentFunc.getId())) continue;
                        parentFunc.setType("2");
                        continue block3;
                    }
                    continue;
                }
                func.setType("1");
                continue;
            }
            if ("addNew".equalsIgnoreCase(operation)) {
                func.setType("3");
                continue;
            }
            if ("edit".equalsIgnoreCase(operation)) {
                func.setType("2");
                continue;
            }
            if (!"remove".equalsIgnoreCase(operation)) continue;
            func.setType("2");
        }
    }

    private static Map<String, Object> parseDiffOperations(String diffXml) {
        DifferenceOperationParseUtil util = new DifferenceOperationParseUtil();
        return util.getDiffOperationsFromString(diffXml);
    }
}

