/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class BeforeBusItemF7SelectListener
implements BeforeF7SelectListener {
    private static final String businessItemKey = "businessitem";
    public static final String DAILY_REIMBURSE_SSC = "er_dailyreimbursebil_ssc";
    public static final String DAILY_REIMBURSE_SSC_ = "er_dailyreimbursebill_ssc";
    private static final String SQL_QUERY_NORELATION_ITEM = "SELECT fid FROM t_bd_businessitem A WHERE NOT EXISTS (SELECT 1 FROM t_bd_businessitemreldept B WHERE A.fid = B.fbusinesstypeid)";
    private IFormView view;
    private String billType;
    private String accountancyOrg;
    private String administrativeOrg;

    public BeforeBusItemF7SelectListener(IFormView view, String billType, String accountancyOrg, String administrativeOrg) {
        this.view = view;
        this.billType = billType;
        this.accountancyOrg = accountancyOrg;
        this.administrativeOrg = administrativeOrg;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object accountancyOrgO = this.view.getModel().getValue(this.accountancyOrg);
        Object administrativeOrgO = this.view.getModel().getValue(this.administrativeOrg);
        if (accountancyOrgO == null || administrativeOrgO == null) {
            return;
        }
        Long accountancyOrgId = Long.parseLong(((DynamicObject)accountancyOrgO).getPkValue().toString());
        Long administrativeOrgId = Long.parseLong(((DynamicObject)administrativeOrgO).getPkValue().toString());
        QFilter treeFilter = this.getBusItemTreeFilter(administrativeOrgId);
        ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
        cardF7Param.getListFilterParameter().getQFilters().add(treeFilter);
        cardF7Param.getListFilterParameter().getQFilters().add(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE}));
        cardF7Param.setCustomParam("treeFilter", (Object)treeFilter.toSerializedString());
        cardF7Param.setCustomParam("useOrgId", (Object)accountancyOrgId);
    }

    public QFilter getBusItemTreeFilter(Long administrativeOrgId) {
        Set<Long> relatedBusItemPks = this.getRelatedBusItemsByBillType();
        QFilter treeFilter = new QFilter("id", "in", relatedBusItemPks);
        treeFilter.and(new QFilter("id", "in", BeforeBusItemF7SelectListener.getRelatedBusItemsByDept(administrativeOrgId)).or(new QFilter("id", "in", BeforeBusItemF7SelectListener.getNoRelatedBusItemsByDept())));
        treeFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return treeFilter;
    }

    public Set<Long> getRelatedBusItemsByBillType() {
        QFilter typeFilter;
        DynamicObject[] relatedBusItems;
        Set<Long> relatedBusItemPks = new HashSet<Long>();
        if (this.billType != null && this.billType.indexOf("ssc") != -1) {
            this.billType = DAILY_REIMBURSE_SSC.equals(this.billType) ? DAILY_REIMBURSE_SSC_ : this.billType.replace("_ssc", "");
        }
        QFilter filter = new QFilter("number", "=", (Object)this.billType);
        DynamicObject[] billTypes = BusinessDataServiceHelper.load((String)"er_billtype", (String)"id,number", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> billTypeId = new ArrayList<Long>(10);
        for (DynamicObject billType : billTypes) {
            billTypeId.add(Long.parseLong(billType.getPkValue() + ""));
        }
        if (billTypeId.size() > 0 && (relatedBusItems = BusinessDataServiceHelper.load((String)"bd_businessitembill", (String)businessItemKey, (QFilter[])new QFilter[]{typeFilter = new QFilter("billtype", "=", billTypeId.get(0))})) != null && relatedBusItems.length > 0) {
            relatedBusItemPks = Stream.of(relatedBusItems).map(v -> Long.parseLong(v.getDynamicObject(businessItemKey).getPkValue().toString())).collect(Collectors.toSet());
        }
        return relatedBusItemPks;
    }

    private static List<Long> getRelatedBusItemsByDept(Long orgId) {
        DynamicObject[] reldepts;
        ArrayList<Long> relBusItemPks = new ArrayList<Long>(10);
        List allOrgs = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        allOrgs.add(orgId);
        for (DynamicObject item : reldepts = BusinessDataServiceHelper.load((String)"bd_busitemreldept", (String)"businessitem, relorg", (QFilter[])new QFilter[]{new QFilter("relorg", "in", (Object)allOrgs)})) {
            DynamicObject busItem = (DynamicObject)item.get(businessItemKey);
            relBusItemPks.add(Long.parseLong(busItem.getPkValue() + ""));
        }
        return relBusItemPks;
    }

    private static List<Object> getNoRelatedBusItemsByDept() {
        ArrayList<Object> ids = new ArrayList<Object>(16);
        DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)SQL_QUERY_NORELATION_ITEM, rs -> {
            while (rs.next()) {
                ids.add(rs.getLong("fid"));
            }
            return ids;
        });
        return ids;
    }
}

