/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.dhc.domain.RecordExceptionDO;
import kd.fi.dhc.enums.ExceptionTypeEnum;
import kd.fi.dhc.util.DynamicObjectUtils;
import kd.fi.dhc.util.RecordExceptionUtil;

public abstract class ExceptionService {
    protected ExceptionTypeEnum exceptionType;

    public ExceptionService() {
    }

    public ExceptionService(ExceptionTypeEnum exceptionType) {
        this.exceptionType = exceptionType;
    }

    public abstract void reRun(DynamicObject var1);

    public void saveException(String entityNumber, String classpath, String methodName, Throwable exception, String exceptionMsg, String arguments, boolean canRetry) {
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        RecordExceptionDO recordExceptionDO = RecordExceptionDO.builder().excType(this.exceptionType.getValue()).billType(entityId).classname(classpath).methodName(methodName).traceId(RequestContext.get().getTraceId()).excReason(exceptionMsg).excReason_tag(RecordExceptionUtil.getStackTrace(exception)).excArgument_tag(arguments).canRetry(canRetry).state("0").build();
        RecordExceptionUtil.saveRecordExcept(recordExceptionDO);
    }

    public void saveException(String entityNumber, String classpath, String methodName, Throwable exception, String exceptionMsg, String arguments, boolean canRetry, List<Long> billIds) {
        if (billIds == null || billIds.size() < 1) {
            return;
        }
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        String numberProperty = DynamicObjectUtils.getNumberProperty(entityNumber);
        String traceId = RequestContext.get().getTraceId();
        String stackTrace = RecordExceptionUtil.getStackTrace(exception);
        String sameErrorMark = "same with " + this.getBillNo(billIds.get(0), entityNumber, numberProperty);
        ArrayList<RecordExceptionDO> exceptionDOs = new ArrayList<RecordExceptionDO>(billIds.size());
        for (int i = 0; i < billIds.size(); ++i) {
            Long billId = billIds.get(i);
            RecordExceptionDO recordExceptionDO = RecordExceptionDO.builder().excType(this.exceptionType.getValue()).billType(entityId).billId(billId).billNumber(this.getBillNo(billId, entityNumber, numberProperty)).classname(classpath).methodName(methodName).traceId(traceId).excReason(exceptionMsg).excReason_tag(stackTrace).excArgument_tag(arguments).canRetry(canRetry).state("0").build();
            if (i > 0) {
                recordExceptionDO.setExcReason(sameErrorMark);
                recordExceptionDO.setExcArgument_tag(null);
                recordExceptionDO.setExcReason_tag(null);
            }
            exceptionDOs.add(recordExceptionDO);
        }
        RecordExceptionUtil.saveBatchRecordExcept(exceptionDOs);
    }

    private String getBillNo(Long billId, String entityNumber, String numberFieldKey) {
        if (entityNumber == null || numberFieldKey == null) {
            return "";
        }
        DynamicObject billData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber, (String)numberFieldKey);
        return billData.getString(numberFieldKey);
    }
}

