/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.dhc.enums.DataSynTypeEnum;
import kd.fi.dhc.enums.ExceptionTypeEnum;
import kd.fi.dhc.executor.DataSynchronizationExecutor;
import kd.fi.dhc.service.ExceptionService;
import org.apache.commons.lang3.time.DateUtils;

public class InitDataExceptionService
extends ExceptionService {
    private static final String ALGO_KEY = "fi.dhc.InitDataExceptionService";

    public InitDataExceptionService() {
        super(ExceptionTypeEnum.INIT_DATA_ERROR);
    }

    @Override
    public void reRun(DynamicObject exceptionRecordDyn) {
        Date errorDate;
        String entityNumber = exceptionRecordDyn.getString("billtype.number");
        String argument = exceptionRecordDyn.getString("excargument_tag");
        HashMap argMap = (HashMap)SerializationUtils.fromJsonString((String)argument, Map.class);
        String errorDateStr = (String)argMap.get("errorDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            errorDate = sdf.parse(errorDateStr);
        }
        catch (Exception ex) {
            ErrorCode errorCode = new ErrorCode(ALGO_KEY, ResManager.loadKDString((String)"\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u6539\u5f02\u5e38\u6570\u636e\u53c2\u6570\u4e2d\u7684errorDate\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"InitDataExceptionService_0", (String)"fi-dhc-common", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        Date finishDate = DateUtils.addDays((Date)errorDate, (int)1);
        QFilter[] filters = new QFilter[3];
        filters[0] = new QFilter("createtime", ">=", (Object)errorDate);
        filters[1] = new QFilter("createtime", "<", (Object)finishDate);
        if ("fa_dispatch_in".equals(entityNumber)) {
            String[] billStatus = new String[]{"C", "D"};
            filters[2] = new QFilter("billstatus", "in", (Object)billStatus);
        }
        HashSet<Object> idSet = new HashSet<Object>();
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, entityNumber, "id", filters);){
            ds.forEach(row -> idSet.add(row.get(0)));
        }
        DataSynchronizationExecutor executor = new DataSynchronizationExecutor(entityNumber, idSet, DataSynTypeEnum.SYN_DATA);
        executor.execute();
    }
}

