/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.util;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.dhc.service.impl.FieldMapServiceImpl;

public class BillSubjectUtil {
    private static final String DELIMITER = "_";

    public static String getBillSubject(String formMetaNumber, DynamicObject billData) {
        StringBuilder billSubject = new StringBuilder();
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        String billSubjectIdTmp = service.getBillSubjectPkId(formMetaNumber);
        if (StringUtils.isBlank((CharSequence)billSubjectIdTmp)) {
            return "";
        }
        long billSubjectId = Long.parseLong(billSubjectIdTmp);
        DynamicObject billSubjectRule = BusinessDataServiceHelper.loadSingle((Object)billSubjectId, (String)"dhc_billsubject");
        if (billSubjectRule != null) {
            DynamicObjectCollection entryEntity = billSubjectRule.getDynamicObjectCollection("entryentity");
            entryEntity.sort((o1, o2) -> {
                int s1 = (Integer)o1.get("seq");
                int s2 = (Integer)o2.get("seq");
                return s1 - s2;
            });
            for (DynamicObject entry : entryEntity) {
                String postText;
                String element;
                String preText;
                if (billSubject.length() != 0) {
                    billSubject.append('_');
                }
                if (StringUtils.isNotBlank((CharSequence)(preText = entry.getString("pretext")))) {
                    billSubject.append(preText);
                }
                if (StringUtils.isNotBlank((CharSequence)(element = entry.getString("mark")))) {
                    DynamicObject dyn = billData;
                    if (element.contains(".")) {
                        String[] elements = element.split("\\.");
                        element = elements[elements.length - 1];
                        String[] elementsTemp = new String[elements.length - 1];
                        System.arraycopy(elements, 0, elementsTemp, 0, elementsTemp.length);
                        for (String ele : elementsTemp) {
                            Object obj = dyn.get(ele);
                            if (obj == null) {
                                dyn = null;
                                break;
                            }
                            if (obj instanceof DynamicObjectCollection) {
                                if (((DynamicObjectCollection)obj).size() > 0) {
                                    dyn = (DynamicObject)((DynamicObjectCollection)obj).get(0);
                                    continue;
                                }
                                dyn = null;
                                break;
                            }
                            if (!(obj instanceof DynamicObject)) continue;
                            dyn = (DynamicObject)obj;
                        }
                    }
                    if (dyn != null) {
                        Object ele;
                        String fieldAmount = service.getBillAmountField(formMetaNumber);
                        String fieldCurrency = service.getCurrency(formMetaNumber);
                        if (StringUtils.isNotBlank((CharSequence)fieldAmount) && StringUtils.isNotBlank((CharSequence)fieldCurrency) && fieldAmount.equalsIgnoreCase(element)) {
                            DynamicObject currency = billData.getDynamicObject(fieldCurrency);
                            String sign = "";
                            if (currency != null) {
                                sign = currency.getString("sign");
                            }
                            billSubject.append(sign);
                        }
                        if ((ele = dyn.get(element)) instanceof BigDecimal) {
                            BigDecimal elementValue = (BigDecimal)ele;
                            ele = elementValue.setScale(2, 0);
                        }
                        if (ele != null) {
                            billSubject.append(ele);
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)(postText = entry.getString("posttext")))) continue;
                billSubject.append(postText);
            }
            if (billSubject.length() > 0) {
                return billSubject.toString();
            }
        }
        return billSubject.toString();
    }
}

