/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.hdc.cache;

import java.util.Arrays;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.CacheKeyUtil;

public class DhcLocalCache {
    private static final String KEY_PREFIX = "fi_dhc_";
    private static final CacheConfigInfo cacheConfig = new CacheConfigInfo();

    private static LocalMemoryCache getLocalMemoryCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "dhc", cacheConfig);
    }

    public static void put(String key, Object content) {
        if (content != null) {
            DhcLocalCache.getLocalMemoryCache().put(KEY_PREFIX + key, content);
        }
    }

    public static Object get(String key) {
        return DhcLocalCache.getLocalMemoryCache().get(KEY_PREFIX + key);
    }

    public static void remove(String ... keys) {
        if (keys != null) {
            String[] keys_ = (String[])Arrays.stream(keys).map(p -> KEY_PREFIX + p).toArray(String[]::new);
            DhcLocalCache.getLocalMemoryCache().remove(keys_);
        }
    }

    static {
        cacheConfig.setTimeout(3600);
        cacheConfig.setMaxItemSize(10000);
    }
}

