/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.consumer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.dto.BillDataInitMessage;
import kd.fi.dhc.enums.DataSynTypeEnum;
import kd.fi.dhc.enums.InitExeStatusEnum;
import kd.fi.dhc.executor.DataSynchronizationExecutor;
import kd.fi.dhc.service.InitDataExceptionService;
import kd.fi.hdc.cache.DhcDistributeCache;
import org.apache.commons.lang3.time.DateUtils;

public class BillDataInitConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(BillDataInitConsumer.class);
    private static final String ALGO_KEY = "fi.dhc.BillDataInitConsumer";
    private String cacheKey;

    public void onMessage(Object msg, String msgId, boolean isResend, MessageAcker messageAcker) {
        log.debug("\u6210\u529f\u8fdb\u5165\u62a5\u8d26\u6570\u636e\u521d\u59cb\u5316\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u6d88\u606f: " + msg + ", msgId: " + msgId + ", is resend: " + isResend);
        if (StringUtils.isEmpty((String)msg.toString())) {
            log.debug("\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(msgId);
            return;
        }
        if (!(msg instanceof BillDataInitMessage)) {
            log.error("\u6d88\u606f\u961f\u5217\u4e2d message \u7c7b\u578b\u4e0d\u5339\u914d: " + BillDataInitMessage.class.getName());
            messageAcker.ack(msgId);
            return;
        }
        BillDataInitMessage message = (BillDataInitMessage)msg;
        String billMetaNumber = message.getBillMetaNumber();
        Date initDate = message.getInitDate();
        String initDateStr = this.getSdf().format(initDate);
        this.cacheKey = billMetaNumber + "_" + initDateStr;
        DhcDistributeCache.remove((String)"cache_init_bill_and_date");
        String cacheJson = DhcDistributeCache.get((String)"cache_init_bill_and_date");
        if (cacheJson == null) {
            log.debug("\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u7801\u548c\u521d\u59cb\u5316\u65e5\u671f\u6784\u6210\u7684\u96c6\u5408\uff0c\u521b\u5efa\u65b0\u6570\u636e\uff1a[" + this.cacheKey + "]");
            HashSet<String> cacheSet = new HashSet<String>(16);
            cacheSet.add(this.cacheKey);
            cacheJson = SerializationUtils.toJsonString(cacheSet);
            DhcDistributeCache.put((String)"cache_init_bill_and_date", (Object)cacheJson);
        } else {
            Set cacheSet = (Set)SerializationUtils.fromJsonString((String)cacheJson, Set.class);
            if (cacheSet.contains(this.cacheKey)) {
                log.debug("\u7f13\u5b58\u4e2d\u5b58\u5728\u6570\u636e\uff1a[" + this.cacheKey + "]\uff0c\u4e0d\u518d\u5904\u7406");
                messageAcker.ack(msgId);
                return;
            }
            log.debug("\u7f13\u5b58\u4e2d\u5b58\u5728\u5355\u636e\u7f16\u7801\u548c\u521d\u59cb\u5316\u65e5\u671f\u6784\u6210\u7684\u96c6\u5408\uff0c\u4f46\u662f\u4e0d\u5b58\u5728\u8be5cacheKey[" + this.cacheKey + "]\uff0c\u66f4\u65b0\u6570\u636e");
            cacheSet.add(this.cacheKey);
            DhcDistributeCache.remove((String)"cache_init_bill_and_date");
            cacheJson = SerializationUtils.toJsonString((Object)cacheSet);
            DhcDistributeCache.put((String)"cache_init_bill_and_date", (Object)cacheJson);
        }
        this.initBillData(billMetaNumber, initDate);
        messageAcker.ack(msgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBillData(String billMetaNumber, Date initDate) {
        Date nextDay = DateUtils.addDays((Date)initDate, (int)1);
        QFilter[] filters = new QFilter[3];
        filters[0] = new QFilter("createtime", ">=", (Object)initDate);
        filters[1] = new QFilter("createtime", "<", (Object)nextDay);
        if ("fa_dispatch_in".equals(billMetaNumber)) {
            String[] billStatus = new String[]{"C", "D"};
            filters[2] = new QFilter("billstatus", "in", (Object)billStatus);
        }
        HashSet idSet = new HashSet();
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, billMetaNumber, "id", filters);){
            ds.forEach(row -> idSet.add(row.get(0)));
        }
        int initDataSize = idSet.size();
        try {
            if (initDataSize < 1) {
                return;
            }
            DataSynchronizationExecutor executor = new DataSynchronizationExecutor(billMetaNumber, idSet, DataSynTypeEnum.SYN_DATA);
            executor.execute();
            this.updateTableAfterInit(billMetaNumber, initDataSize, true, initDate);
        }
        catch (Throwable th) {
            this.updateTableAfterInit(billMetaNumber, initDataSize, false, initDate);
            this.recordErrorException(billMetaNumber, initDate, th);
            log.error(billMetaNumber + "->" + this.getSdf().format(initDate) + initDataSize + "\uff0c\u4fdd\u5b58\u6211\u7684\u62a5\u8d26\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u521d\u59cb\u5316\u5c06\u7ee7\u7eed\u8fdb\u884c", th);
        }
        finally {
            this.clearCache();
        }
    }

    private void updateTableAfterInit(String billMetaNumber, int billAmount, boolean isSuccess, Date initDate) {
        boolean isInitFinish;
        String failureTimeTag;
        QFilter billNumberFilter = new QFilter("bill.number", "=", (Object)billMetaNumber);
        DynamicObject[] recordArr = BusinessDataServiceHelper.load((String)"dhc_datainitrecord", (String)EntityField.buildSelectField((String[])new String[]{"exestatus", "finishtime", "billtotal", "initamount", "saveamount", "failuretime_tag", "createtime"}), (QFilter[])new QFilter[]{billNumberFilter}, (String)"createtime desc");
        if (recordArr.length == 0) {
            log.error("\u66f4\u65b0[dhc_datainitrecord]\u53d1\u751f\u5f02\u5e38\uff1a\u672a\u67e5\u5230\u5355\u636e\u5143\u6570\u636e\u7f16\u7801\u4e3a\u3010" + billMetaNumber + "\u3011\u7684\u8bb0\u5f55\uff01");
            return;
        }
        DynamicObject record = recordArr[0];
        int billTotal = record.getInt("billtotal");
        int initAmount = record.getInt("initamount");
        int successAmount = record.getInt("saveamount");
        record.set("initamount", (Object)(initAmount + billAmount));
        if (isSuccess) {
            record.set("saveamount", (Object)(successAmount + billAmount));
        } else {
            String initDateStr = this.getSdf().format(initDate);
            failureTimeTag = record.getString("failuretime_tag");
            failureTimeTag = failureTimeTag.length() > 0 ? failureTimeTag + ", " + initDateStr : initDateStr;
            record.set("failuretime_tag", (Object)failureTimeTag);
        }
        boolean bl = isInitFinish = billTotal <= initAmount + billAmount;
        if (isInitFinish) {
            failureTimeTag = record.getString("failuretime_tag");
            if (failureTimeTag.length() > 0) {
                record.set("exestatus", (Object)InitExeStatusEnum.EXE_FAILURE.getValue());
            } else {
                record.set("exestatus", (Object)InitExeStatusEnum.EXE_SUCCESS.getValue());
            }
            record.set("finishtime", (Object)new Date());
            record.set("billtotal", (Object)(initAmount + billAmount));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        if (isInitFinish) {
            Date beginTime = record.getDate("createtime");
            Date finishTime = record.getDate("finishtime");
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"dhc_billdatainit", (QFilter[])new QFilter[]{billNumberFilter});
            dyn.set("initbegintime", (Object)beginTime);
            dyn.set("initfinishtime", (Object)finishTime);
            String failureTimeTag2 = record.getString("failuretime_tag");
            successAmount = record.getInt("saveamount");
            if (failureTimeTag2.isEmpty()) {
                dyn.set("initstatus", (Object)"D");
            } else if (successAmount > 0) {
                dyn.set("initstatus", (Object)"C");
            } else {
                dyn.set("initstatus", (Object)"E");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
    }

    private void clearCache() {
        String cacheJson = DhcDistributeCache.get((String)"cache_init_bill_and_date");
        if (cacheJson == null) {
            return;
        }
        Set cacheSet = (Set)SerializationUtils.fromJsonString((String)cacheJson, Set.class);
        if (!cacheSet.contains(this.cacheKey)) {
            return;
        }
        cacheSet.remove(this.cacheKey);
        cacheJson = SerializationUtils.toJsonString((Object)cacheSet);
        DhcDistributeCache.remove((String)"cache_init_bill_and_date");
        DhcDistributeCache.put((String)"cache_init_bill_and_date", (Object)cacheJson);
    }

    private void recordErrorException(String entityNumber, Date errorDate, Throwable th) {
        String errorDateStr = this.getSdf().format(errorDate);
        String errorMsg = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u521b\u5efa\u65f6\u95f4\u4e3a%2s\u7684%1s\u5355\uff0c\u540c\u6b65\u6570\u636e\u5f02\u5e38\u3002", (String)"BillDataInitConsumer_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]), entityNumber, errorDateStr);
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put("errorDate", errorDateStr);
        String argsString = SerializationUtils.toJsonString(args);
        InitDataExceptionService exService = new InitDataExceptionService();
        exService.saveException(entityNumber, "BillDataInitConsumer", "onMessage", th, errorMsg, argsString, true);
    }

    private SimpleDateFormat getSdf() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }
}

