/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.config.BillMappingConfig;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.MappingTypeEnum;
import kd.fi.dhc.formplugin.util.AppMenuUtil;
import kd.fi.dhc.formplugin.util.MappingCfgUtil;
import kd.fi.dhc.util.DynamicObjectSerializeUtil;

public class BillMappingMenuTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String APP_NUMBER = "dhc";
    private static final String BOS_DEV_PORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String MENU_TREE = "menutreeview";
    private static final String MENU_ENTRY = "entryentity";
    private static final String TOOL_BAR = "toolbarap";
    private static final String SEARCH_AP = "searchap";
    private static final String FIELD_CHECKBOX = "checkboxfield";
    private static final String CACHE_SEARCH_NODES = "searchNodes";
    private static final String BTN_CONFIG = "btnconfig";
    private static final String BTN_REFRESH = "btnrefresh";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CLEAR = "btnclear";
    private static final String BTN_CLOSE = "btnclose";
    private static final String BTN_SYN = "btnsyn";
    private static final String CUSTOMIZED_MENU_FLAG = "#customized";
    private static final String CACHE_APP_ID = "appId";
    private static final String CACHE_APP_NAME = "appName";
    private static final String CACHE_ROOT = "root";
    private static final String CACHE_NODE_LEVEL = "nodeLevel";
    private static final String CACHE_CUST_NODEIDS = "customizedNodeIds";
    private static final String CACHE_CHECKED_FORM_NUMBER = "checkedFormNumber";
    private static final String CACHE_CHECKED_FORM_NAME = "checkedFormName";
    private static final String CALL_BACK_PAGE_PROPTREE = "callBackPageProptree";
    private static final String CALL_BACK_PAGE_MAPPING_CONFIG = "callBackPageMappingConfig";
    private static final String CALL_BACK_PAGE_BILL_SUBJECT = "callBackPageBillSubject";
    private static final String CALL_BACK_TREENODE_CLICK = "callBackTreeNodeClick";
    private static final String CALL_BACK_PAGE_REIM_STATUS = "callBackPageReimburseStatus";
    private static final String CACHE_FORM_NAME_MAP_FORM_NUMBER = "formNameToFormNumber";
    private static final String HEADER_TAG_Y = "1";
    private static final String T_DHC_BILLMAPPING = "t_dhc_billmapping";
    private static final String DHC_BILL_MAPPING_SAVE_TX = "fi/BillMappingMenuTreePlugin/saveMappingConfiguration";
    private static final String CACHE_NODE_ID = "cacheNodeId";
    private static final String CACHE_NODE_NAME = "cacheNodeName";
    private static final String CACHE_TO_NODE_ID = "cacheToNodeId";
    private static final String CACHE_TO_NODE_NAME = "cacheToNodeName";
    private static final String CACHE_SUBJECT_DATA = "cacheSubjectData";
    private static final String ATTRIBUTE_CUS = "C";
    private static final String CACHE_SEARCH_TEXT = "lastSearchText";
    private Log log = LogFactory.getLog(BillMappingMenuTreePlugin.class);

    public void initialize() {
        this.setColEditorProp();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TextEdit billmapping = (TextEdit)this.getView().getControl("mappingname");
        billmapping.addButtonClickListener((ClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String appId = this.getCurrentAppId();
        if (appId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"BillMappingMenuTreePlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            this.log.error(" kd.fi.dhc.formplugin.BillMappingMenuTreePlugin.afterCreateNewData: \u6839\u636e\u5e94\u7528\u7f16\u7801 [dhc] \u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u672a\u67e5\u51fa\u6570\u636e\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728\u6216\u5e94\u7528\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01");
            return;
        }
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        String firstL5Node = this.renderMenuTree(metadata);
        this.showMenuListSub(firstL5Node, metadata);
    }

    public void search(SearchEnterEvent evt) {
        List<TreeNode> nodes;
        String searchText = evt.getText();
        String cacheSearchNodes = this.getPageCache().get(CACHE_SEARCH_NODES);
        String cacheSearchText = this.getPageCache().get(CACHE_SEARCH_TEXT);
        if (searchText.equals(cacheSearchText)) {
            nodes = StringUtils.isNotBlank((CharSequence)cacheSearchNodes) ? SerializationUtils.fromJsonStringToList((String)cacheSearchNodes, TreeNode.class) : this.getSearchNodes(searchText);
        } else {
            nodes = this.getSearchNodes(searchText);
            this.getPageCache().put(CACHE_SEARCH_TEXT, searchText);
        }
        if (nodes != null && nodes.size() > 0) {
            TreeNode node = nodes.remove(0);
            String parentId = node.getParentid();
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            tree.focusNode(node);
            tree.showNode(parentId);
            tree.treeNodeClick(parentId, node.getId());
            this.getPageCache().put(CACHE_SEARCH_NODES, SerializationUtils.toJsonString(nodes));
            if (nodes.size() == 0) {
                this.getPageCache().put(CACHE_SEARCH_NODES, "");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\u3002", (String)"BillMappingMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId;
        String cacheNodeId = this.getPageCache().get(CACHE_NODE_ID);
        if (!StringUtils.equals((CharSequence)cacheNodeId, (CharSequence)(nodeId = evt.getNodeId().toString()))) {
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            Map map = tree.getTreeState().getFocusNode();
            String nodeName = (String)map.get("text");
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.getPageCache().put(CACHE_TO_NODE_ID, nodeId);
                this.getPageCache().put(CACHE_TO_NODE_NAME, nodeName);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u6620\u5c04\u914d\u7f6e\u6570\u636e\u5df2\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BillMappingMenuTreePlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]), this.getPageCache().get(CACHE_NODE_NAME)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_TREENODE_CLICK));
                evt.setCancel(true);
                return;
            }
            String appId = this.getCurrentAppId();
            if (!StringUtils.equals((CharSequence)appId, (CharSequence)((String)evt.getParentNodeId()))) {
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
                this.showMenuListSub(nodeId, appMeta);
            } else {
                this.getModel().deleteEntryData(MENU_ENTRY);
            }
            this.getPageCache().put(CACHE_NODE_ID, nodeId);
            this.getPageCache().put(CACHE_NODE_NAME, nodeName);
            this.getModel().setDataChanged(false);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"mappingname", (CharSequence)key)) {
            int index = this.getModel().getEntryCurrentRowIndex(MENU_ENTRY);
            DynamicObject rowData = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
            String mappingType = rowData.getString("mappingtype");
            if (StringUtils.equals((CharSequence)mappingType, (CharSequence)MappingTypeEnum.MAPPING.getValue())) {
                this.getMappingField(this.getPageCache().get(CACHE_CHECKED_FORM_NAME), this.getPageCache().get(CACHE_CHECKED_FORM_NUMBER));
            } else if (StringUtils.equals((CharSequence)mappingType, (CharSequence)MappingTypeEnum.BILL_SUBJECT.getValue())) {
                this.getTaskSubject(this.getPageCache().get(CACHE_CHECKED_FORM_NAME), this.getPageCache().get(CACHE_CHECKED_FORM_NUMBER), rowData);
            } else if (StringUtils.equals((CharSequence)mappingType, (CharSequence)MappingTypeEnum.MAPPINGAVALUE.getValue())) {
                String formNumber = this.getPageCache().get(CACHE_CHECKED_FORM_NUMBER);
                List collect = this.getModel().getEntryEntity(MENU_ENTRY).stream().filter(s -> s.getString("number").equals("billstatus")).collect(Collectors.toList());
                if (collect.size() > 0) {
                    String mappingNumber = ((DynamicObject)collect.get(0)).getString("mappingnumber");
                    if (StringUtils.isBlank((CharSequence)mappingNumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u8bbe\u7f6e\u62a5\u8d26\u72b6\u6001\u4e4b\u524d\uff0c\u8bf7\u5148\u914d\u7f6e\u5355\u636e\u72b6\u6001\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"BillMappingMenuTreePlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getReimburseStatus(formNumber, mappingNumber, rowData);
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_CLEAR)) {
            AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
            int[] selectRows = grid.getEntryState().getSelectedRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u53f3\u8868\u4e2d\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"BillMappingMenuTreePlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject rowData = this.getModel().getEntryRowEntity(MENU_ENTRY, selectRows[0]);
            String mappingNumber = rowData.getString("mappingnumber");
            if (StringUtils.isBlank((CharSequence)mappingNumber)) {
                evt.setCancel(true);
                return;
            }
            rowData.set("mappingname", (Object)" ");
            rowData.set("mappingnumber", (Object)" ");
            this.getView().updateView(MENU_ENTRY);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_CLOSE)) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(MENU_ENTRY);
            for (DynamicObject dyo : dynamicObjects) {
                String subjectStr;
                DynamicObject subjectDyo;
                String number = dyo.getString("number");
                if (!StringUtils.equals((CharSequence)number, (CharSequence)"billsubject")) continue;
                String billNumber = this.getPageCache().get(CACHE_CHECKED_FORM_NUMBER);
                QFilter[] qFilters = new QFilter[]{new QFilter("billnumber", "=", (Object)billNumber), new QFilter("number", "=", (Object)"billsubject")};
                DynamicObject mappingDyo = QueryServiceHelper.queryOne((String)"dhc_billmapping", (String)"mappingname", (QFilter[])qFilters);
                String mappingName = mappingDyo.getString("mappingname");
                Long mappingNumber = 0L;
                String mappingNumberStr = dyo.getString("mappingnumber");
                if (StringUtils.isNotBlank((CharSequence)mappingNumberStr)) {
                    mappingNumber = Long.parseLong(mappingNumberStr);
                }
                if ((subjectDyo = QueryServiceHelper.queryOne((String)"dhc_billsubject", (String)"remark", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mappingNumber)})) == null || StringUtils.equals((CharSequence)mappingName, (CharSequence)subjectDyo.getString("remark")) || (subjectStr = this.getPageCache().get(CACHE_SUBJECT_DATA)) == null) continue;
                this.rollbackSubject(subjectStr);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)BTN_CONFIG, (CharSequence)key)) {
            this.showHeaderConfigForm();
        } else if (StringUtils.equals((CharSequence)BTN_REFRESH, (CharSequence)key)) {
            this.refreshCurrPage(this.getModel().getDataChanged());
        } else if (StringUtils.equals((CharSequence)BTN_SAVE, (CharSequence)key)) {
            TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
            Map nodeInfo = treeView.getTreeState().getFocusNode();
            String menuId = "";
            menuId = nodeInfo == null ? this.getPageCache().get(CACHE_NODE_ID) : (String)nodeInfo.get("id");
            Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_FORM_NAME_MAP_FORM_NUMBER), Map.class);
            String billNumber = (String)map.get(menuId);
            DynamicObjectCollection collection = this.getModel().getEntryEntity(MENU_ENTRY);
            this.buildMappingConfiguration(collection, billNumber);
            this.getModel().setDataChanged(false);
        } else if (StringUtils.equals((CharSequence)BTN_SYN, (CharSequence)key)) {
            this.synCDNConfig();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(MENU_ENTRY);
        if (CALL_BACK_PAGE_PROPTREE.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            Map ret = (Map)e.getReturnData();
            model.setValue("mappingname", ret.get("alias"), index);
            model.setValue("mappingnumber", ret.get("mark"), index);
        } else if (CALL_BACK_PAGE_MAPPING_CONFIG.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            this.getModel().setDataChanged(true);
            this.refreshCurrPage(this.getModel().getDataChanged());
        } else if (CALL_BACK_PAGE_BILL_SUBJECT.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            Map ret = (Map)e.getReturnData();
            model.setValue("mappingname", ret.get("number"));
            model.setValue("mappingnumber", ret.get("id"));
        } else if (CALL_BACK_PAGE_REIM_STATUS.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            Map ret = (Map)e.getReturnData();
            String json = (String)ret.get("mappingNumber");
            String name = this.parsingReimStatusJson(json);
            model.setValue("mappingname", (Object)name);
            model.setValue("mappingnumber", (Object)json);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int reimburseStatusIndex;
        DynamicObject entryRowEntity;
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (fieldKey.equals("mappingnumber") && (entryRowEntity = model.getEntryRowEntity(MENU_ENTRY, rowIndex)).getString("number").equals("billstatus") && (reimburseStatusIndex = this.getReimburseStatusIndex()) != -1) {
            model.setValue("mappingname", (Object)"", reimburseStatusIndex);
            model.setValue("mappingnumber", (Object)"", reimburseStatusIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        boolean succeed = true;
        if (CALL_BACK_TREENODE_CLICK.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(MENU_ENTRY);
            String billNumber = this.getPageCache().get(CACHE_CHECKED_FORM_NUMBER);
            try {
                succeed = this.buildMappingConfiguration(entryCollection, billNumber);
            }
            catch (Exception e) {
                succeed = false;
            }
        } else {
            String subjectStr = this.getPageCache().get(CACHE_SUBJECT_DATA);
            if (subjectStr != null) {
                this.rollbackSubject(subjectStr);
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
        TreeNode treeNode = new TreeNode();
        if (succeed) {
            treeNode.setId(this.getPageCache().get(CACHE_TO_NODE_ID));
            treeView.focusNode(treeNode);
            String appId = this.getCurrentAppId();
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
            this.showMenuListSub(this.getPageCache().get(CACHE_TO_NODE_ID), metadata);
            this.getPageCache().put(CACHE_NODE_ID, this.getPageCache().get(CACHE_TO_NODE_ID));
            this.getPageCache().put(CACHE_NODE_NAME, this.getPageCache().get(CACHE_TO_NODE_NAME));
            this.getModel().setDataChanged(false);
        } else {
            treeNode.setId(this.getPageCache().get(CACHE_NODE_ID));
            treeView.focusNode(treeNode);
        }
    }

    private String getCurrentAppId() {
        String appNumber = AppMetaServiceHelper.loadAppMetadataById((String)APP_NUMBER, (boolean)true).getAppElement().getNumber();
        QFilter numberFilter = new QFilter("number", "=", (Object)appNumber);
        DynamicObject app = QueryServiceHelper.queryOne((String)BOS_DEV_PORTAL_BIZ_APP, (String)"id, name", (QFilter[])new QFilter[]{numberFilter});
        String appId = app == null ? null : app.getString("id");
        this.getPageCache().put(CACHE_APP_ID, appId);
        String appName = app == null ? null : app.getString("name");
        this.getPageCache().put(CACHE_APP_NAME, appName);
        return appId;
    }

    private String renderMenuTree(AppMetadata metadata) {
        String appId = metadata.getId();
        String appName = metadata.getName().getLocaleValue();
        TreeNode root = new TreeNode("", appId, appName);
        List<TreeNode> nodeList = this.getBillNodeList(metadata);
        root.addChildren(nodeList);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addNode(root);
        tree.showNode(appId);
        TreeNode firstL5OfL4 = root;
        if (nodeList != null && nodeList.size() > 0) {
            TreeNode firstL4Node = nodeList.get(0);
            List L5ListOfL4 = firstL4Node.getChildren();
            if (L5ListOfL4 != null && L5ListOfL4.size() > 0) {
                firstL5OfL4 = (TreeNode)L5ListOfL4.get(0);
                tree.showNode(firstL4Node.getId());
                tree.focusNode(firstL5OfL4);
            }
        } else {
            tree.focusNode(root);
        }
        this.getPageCache().put(CACHE_NODE_ID, firstL5OfL4.getId());
        this.getPageCache().put(CACHE_NODE_NAME, firstL5OfL4.getText());
        return firstL5OfL4.getId();
    }

    private List<TreeNode> getBillNodeList(AppMetadata appMeta) {
        String appId = this.getCurrentAppId();
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> firMenuListId = new ArrayList<String>(8);
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>(8);
        for (AppMenuElement menuElement : menuElements) {
            String menuNumber;
            String parentMenuId = menuElement.getParentId();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) || (menuNumber = menuElement.getNumber()) == null || !menuNumber.endsWith(CUSTOMIZED_MENU_FLAG) || CUSTOMIZED_MENU_FLAG.equalsIgnoreCase(menuNumber)) continue;
            String menuId = menuElement.getId();
            firMenuListId.add(menuId);
            String menuName = (String)menuElement.getName().getDefaultItem();
            TreeNode treeNode = new TreeNode(appId, menuId, menuName);
            firMenuList.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>(16);
        this.getMenuTreeNode(menuElements, firMenuList, nodeLevel);
        this.getPageCache().put(CACHE_CUST_NODEIDS, SerializationUtils.toJsonString(firMenuListId));
        this.getPageCache().put(CACHE_NODE_LEVEL, SerializationUtils.toJsonString(nodeLevel));
        return firMenuList;
    }

    private void showMenuListSub(String selectNodeId, AppMetadata appMeta) {
        Map<String, Object> selectedNodeInfos = this.getSelectedNodeInfos(selectNodeId, appMeta);
        if (!ObjectUtils.isEmpty(selectedNodeInfos)) {
            String formNumber = (String)selectedNodeInfos.get("formNumber");
            String formName = (String)selectedNodeInfos.get("formName");
            this.getModel().deleteEntryData(MENU_ENTRY);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"dhc_billmapping", (String)EntityField.buildSelectField((String[])new String[]{"name", "number", "mappingtype", "mappingname", "mappingnumber"}), (QFilter[])new QFilter[]{new QFilter("billnumber", "=", (Object)formNumber)}, (String)"sequence");
            int csize = collection.size();
            if (csize == 0) {
                return;
            }
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(MENU_ENTRY, csize);
            int i = 0;
            for (DynamicObject dyo : collection) {
                String name = dyo.getString("name");
                String number = dyo.getString("number");
                String mappingType = dyo.getString("mappingtype");
                String mappingName = dyo.getString("mappingname");
                String mappingNumber = dyo.getString("mappingnumber");
                model.setValue("name", (Object)name, i);
                model.setValue("number", (Object)number, i);
                model.setValue("mappingtype", (Object)mappingType, i);
                model.setValue("mappingname", (Object)mappingName, i);
                model.setValue("mappingnumber", (Object)mappingNumber, i);
                ++i;
            }
            if (!formNumber.isEmpty()) {
                this.getPageCache().put(CACHE_CHECKED_FORM_NUMBER, formNumber);
                this.getPageCache().put(CACHE_CHECKED_FORM_NAME, formName);
            }
        } else {
            this.getModel().deleteEntryData(MENU_ENTRY);
        }
    }

    private void getMenuTreeNode(List<AppMenuElement> menuElements, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            for (TreeNode parentNode : parentMenuList) {
                String parentNodeId = parentNode.getId();
                if (!parentNodeId.equals(parentMenuId) || menuElement.getVisible().equals("false")) continue;
                String menuId = menuElement.getId();
                String menuName = (String)menuElement.getName().getDefaultItem();
                String menuNumber = menuElement.getFormNumber();
                if ("dhc_menubill".equals(menuNumber)) {
                    Map param = (Map)SerializationUtils.fromJsonString((String)menuElement.getParameter(), Map.class);
                    menuNumber = param.getOrDefault("form", "");
                }
                TreeNode childNode = new TreeNode(parentMenuId, menuId, menuName, false);
                map.put(menuId, menuNumber);
                this.buildNode(parentNode, childNode);
                nodeLevel.put(menuId, 2);
            }
        }
        this.getPageCache().put(CACHE_FORM_NAME_MAP_FORM_NUMBER, SerializationUtils.toJsonString(map));
        for (TreeNode node : parentMenuList) {
            nodeLevel.put(node.getId(), 1);
        }
    }

    private void buildNode(TreeNode parentNode, TreeNode childNode) {
        int seq = 0;
        if (parentNode.getChildren() != null) {
            seq = parentNode.getChildren().size();
        }
        parentNode.addChild(seq, childNode);
    }

    private List<TreeNode> getSearchNodes(String searchText) {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOT), TreeNode.class);
        List firstNode = root.getChildren();
        for (TreeNode firNode : firstNode) {
            List secondNode;
            String firText = firNode.getText();
            if (StringUtils.isNotEmpty((CharSequence)firText) && firText.contains(searchText)) {
                res.add(firNode);
            }
            if ((secondNode = firNode.getChildren()) == null) continue;
            for (TreeNode secNode : secondNode) {
                String secText = secNode.getText();
                if (!StringUtils.isNotEmpty((CharSequence)secText) || !secText.contains(searchText)) continue;
                res.add(secNode);
            }
        }
        return res;
    }

    private Map<String, Object> getSelectedNodeInfos(String selectNodeId, AppMetadata appMeta) {
        List menuElements = appMeta.getAppMenus();
        HashMap<String, Object> nodeInfo = new HashMap<String, Object>(8);
        AppMenuElement menuElement = menuElements.stream().filter(v -> selectNodeId.equals(v.getId())).findAny().orElse(null);
        if (menuElement != null) {
            String formNumber = menuElement.getFormNumber();
            String formName = menuElement.getFormName();
            if ("dhc_menubill".equals(formNumber)) {
                Map param = (Map)SerializationUtils.fromJsonString((String)menuElement.getParameter(), Map.class);
                formNumber = param.getOrDefault("form", "");
                DynamicObject billAccessed = QueryServiceHelper.queryOne((String)"dhc_billaccessed", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formNumber)});
                formName = billAccessed.getString("name");
            }
            nodeInfo.put("formName", formName);
            nodeInfo.put("formNumber", formNumber);
        }
        return nodeInfo;
    }

    private void refreshCurrPage(boolean dataChanged) {
        String appId = this.getCurrentAppId();
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = treeView.getTreeState().getFocusNode();
        if (nodeInfo == null) {
            return;
        }
        String nodeId = (String)nodeInfo.get("id");
        Boolean isParent = (Boolean)nodeInfo.get("isParent");
        if (StringUtils.isNotBlank((CharSequence)nodeId) && !isParent.booleanValue() && dataChanged) {
            this.showMenuListSub(nodeId, metadata);
            this.getModel().setDataChanged(false);
        }
    }

    private boolean buildMappingConfiguration(DynamicObjectCollection collection, String billNumber) {
        this.log.info("buildMappingConfiguration\u9a8c\u8bc1\u6570\u636e\uff1a" + collection.toString());
        for (Object dyo : collection) {
            String number = dyo.getString("number");
            String name = dyo.getString("name");
            String mappingName = dyo.getString("mappingname");
            String showTipsAppend = "[" + name + "]";
            if (StringUtils.equals((CharSequence)number, (CharSequence)"company") && StringUtils.isBlank((CharSequence)mappingName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
                return false;
            }
            if (StringUtils.equals((CharSequence)number, (CharSequence)"billno") && StringUtils.isBlank((CharSequence)mappingName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
                return false;
            }
            if (StringUtils.equals((CharSequence)number, (CharSequence)"billsubject") && StringUtils.isBlank((CharSequence)mappingName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
                return false;
            }
            if (StringUtils.equals((CharSequence)number, (CharSequence)"reimbursestatus") && StringUtils.isBlank((CharSequence)mappingName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
                return false;
            }
            if (StringUtils.equals((CharSequence)number, (CharSequence)"billstatus") && StringUtils.isBlank((CharSequence)mappingName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
                return false;
            }
            if (StringUtils.equals((CharSequence)number, (CharSequence)"applicant") && StringUtils.isBlank((CharSequence)mappingName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
                return false;
            }
            if (!StringUtils.equals((CharSequence)number, (CharSequence)"createtime") || !StringUtils.isBlank((CharSequence)mappingName)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u5355\u636e\u5b57\u6bb5\u53ca\u5b57\u6bb5\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillMappingMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
            return false;
        }
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(16);
        for (DynamicObject dyn : collection) {
            String number = dyn.getString("number");
            String name = dyn.getString("name");
            String mappingName = dyn.getString("mappingname");
            String mappingNumber = dyn.getString("mappingnumber");
            QFilter qFilter1 = new QFilter("number", "=", (Object)number);
            QFilter qFilter2 = new QFilter("billnumber", "=", (Object)billNumber);
            DynamicObject modifyData = BusinessDataServiceHelper.loadSingle((String)"dhc_billmapping", (String)EntityField.buildSelectField((String[])new String[]{"id", "mappingname", "mappingnumber"}), (QFilter[])new QFilter[]{qFilter1, qFilter2});
            if (modifyData != null) {
                modifyData.set("mappingname", (Object)mappingName.trim());
                modifyData.set("mappingnumber", (Object)mappingNumber.trim());
                saveData.add(modifyData);
                continue;
            }
            String showTipsAppend = name;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u5b57\u6bb5\u8bbe\u7f6e\uff0c\u6216\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BillMappingMenuTreePlugin_11", (String)"fi-dhc-formplugin", (Object[])new Object[0]), showTipsAppend));
            return false;
        }
        try {
            this.saveMappingConfiguration(saveData);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String parsingReimStatusJson(String json) {
        Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        StringBuilder mappingName = new StringBuilder();
        Iterator it = map.entrySet().iterator();
        mappingName.append('\uff08');
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            mappingName.append(BillMappingConfig.getReimburseStatusMap((String)key));
            mappingName.append('\uff1a');
            String value = (String)entry.getValue();
            String[] valueSubs = value.split(",");
            for (int i = 0; i < valueSubs.length; ++i) {
                String valueSub = valueSubs[i];
                String str1 = valueSub.substring(0, valueSub.indexOf(95));
                String str2 = valueSub.substring(str1.length() + 1);
                mappingName.append(str2);
                if (i == valueSubs.length - 1) continue;
                mappingName.append('\uff0c');
            }
            mappingName.append('\uff1b');
        }
        mappingName.append('\uff09');
        return mappingName.toString();
    }

    private void showHeaderConfigForm() {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "dhc_headerconfig");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_PAGE_MAPPING_CONFIG);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void getMappingField(String entryName, String entryNumber) {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "dhc_proptree");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("entityKey", (Object)entryNumber);
        String id = MetadataDao.getIdByNumber((String)entryNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String localeValue = formMeta.getName().getLocaleValue();
        showParameter.setCustomParam("entityName", (Object)localeValue);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_PAGE_PROPTREE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void getTaskSubject(String entryName, String entryNumber, DynamicObject rowData) {
        Long billSubjectId;
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("dhc_billsubject");
        if (StringUtils.isNotBlank((Object)rowData.get("mappingnumber")) && (billSubjectId = Long.valueOf(rowData.getLong("mappingnumber"))) != 0L) {
            showParameter.setPkId((Object)billSubjectId);
            showParameter.setStatus(OperationStatus.EDIT);
            DynamicObject subject = BusinessDataServiceHelper.loadSingle((Object)billSubjectId, (String)"dhc_billsubject");
            this.getPageCache().put(CACHE_SUBJECT_DATA, DynamicObjectSerializeUtil.serialize((DynamicObject)subject, (DynamicObjectType)subject.getDynamicObjectType()));
        }
        showParameter.setCustomParam("entryName", (Object)entryName);
        showParameter.setCustomParam("entryNumber", (Object)entryNumber);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_PAGE_BILL_SUBJECT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void getReimburseStatus(String entryNumber, String billStatusMappingNumber, DynamicObject rowData) {
        String mappingNumber = rowData.getString("mappingnumber");
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "dhc_reimbursestatumapping");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("paramNumber", (Object)billStatusMappingNumber);
        showParameter.setCustomParam("entryNumber", (Object)entryNumber);
        showParameter.setCustomParam("mappingNumber", (Object)mappingNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_PAGE_REIM_STATUS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void saveMappingConfiguration(List<DynamicObject> saveData) {
        DBRoute fi = DBRoute.of((String)"fi");
        boolean hasBillMapping = DB.exitsTable((DBRoute)fi, (String)T_DHC_BILLMAPPING);
        try (TXHandle tx = TX.requiresNew((String)DHC_BILL_MAPPING_SAVE_TX);){
            try {
                if (hasBillMapping && saveData.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])saveData.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
        catch (Throwable ex) {
            this.log.error("\u4fdd\u5b58\u6620\u5c04\u914d\u7f6e\u5f02\u5e38\u3002", ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6620\u5c04\u914d\u7f6e\u5f02\u5e38\u3002", (String)"BillMappingMenuTreePlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            if (ex instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utException = (UndeclaredThrowableException)ex;
                if (utException.getUndeclaredThrowable() instanceof InvocationTargetException) {
                    InvocationTargetException _exception = (InvocationTargetException)utException.getUndeclaredThrowable();
                    throw new KDBizException(_exception.getTargetException().getMessage());
                }
                throw new KDBizException(utException.getUndeclaredThrowable().getMessage());
            }
            throw ex;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6620\u5c04\u914d\u7f6e\u6210\u529f\u3002", (String)"BillMappingMenuTreePlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
    }

    private void rollbackSubject(String subjectStr) {
        DynamicObject subject = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billsubject");
        subject = DynamicObjectSerializeUtil.deserialize((String)subjectStr, (DynamicObjectType)subject.getDynamicObjectType());
        DynamicObject newSubject = BusinessDataServiceHelper.loadSingle((Object)subject.getPkValue(), (String)"dhc_billsubject");
        DataEntityPropertyCollection properties = subject.getDataEntityType().getProperties();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (IDataEntityProperty prop : properties) {
            propertyNames.add(prop.getName());
        }
        propertyNames.remove(MENU_ENTRY);
        for (String propertyName : propertyNames) {
            newSubject.set(propertyName, subject.get(propertyName));
        }
        DynamicObjectCollection newSubjectEntry = newSubject.getDynamicObjectCollection(MENU_ENTRY);
        newSubjectEntry.clear();
        DynamicObjectCollection subjectEntry = subject.getDynamicObjectCollection(MENU_ENTRY);
        DataEntityPropertyCollection entryProperties = ((DynamicObject)subjectEntry.get(0)).getDataEntityType().getProperties();
        ArrayList<String> entryPropertyNames = new ArrayList<String>();
        for (IDataEntityProperty prop : entryProperties) {
            entryPropertyNames.add(prop.getName());
        }
        for (DynamicObject dyo : subjectEntry) {
            DynamicObject newEntry = newSubjectEntry.addNew();
            for (String entryPropertyName : entryPropertyNames) {
                newEntry.set(entryPropertyName, dyo.get(entryPropertyName));
                newEntry.setParent(dyo.getParent());
            }
        }
        newSubject.set(MENU_ENTRY, (Object)newSubjectEntry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newSubject});
        this.getPageCache().remove(CACHE_SUBJECT_DATA);
    }

    private void synCDNConfig() {
        int unHeaderCusSize;
        int billAccessedSize;
        DynamicObjectCollection headerCusCollection = MappingCfgUtil.getHeaderCusData();
        DynamicObjectCollection unHeaderCusCollection = MappingCfgUtil.getUnHeaderCusData();
        DynamicObject[] billAccessed = BusinessDataServiceHelper.load((String)"dhc_billaccessed", (String)"id\uff0cnumber", null);
        if (CollectionUtils.isEmpty((Collection)headerCusCollection) || CollectionUtils.isEmpty((Collection)unHeaderCusCollection) || headerCusCollection == null) {
            return;
        }
        int headerCusSize = headerCusCollection.size();
        if (headerCusSize * (billAccessedSize = billAccessed.length) == (unHeaderCusSize = unHeaderCusCollection.size())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u6570\u636e\u4e00\u81f4\uff0c\u65e0\u9700\u540c\u6b65\u3002", (String)"BillMappingMenuTreePlugin_8", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> newDatas = new ArrayList<DynamicObject>(16);
        List headerCusNums = headerCusCollection.stream().map(v -> v.getString("number")).collect(Collectors.toList());
        for (DynamicObject dyo : billAccessed) {
            String number = dyo.getString("number");
            List unHeaderCusDyos = unHeaderCusCollection.stream().filter(v -> v.getString("billnumber").equals(number.trim())).collect(Collectors.toList());
            List unHeaderCusNums = unHeaderCusDyos.stream().map(v -> v.getString("number")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(unHeaderCusDyos) && unHeaderCusDyos.size() >= headerCusSize) continue;
            List headerCusNumsClone = (List)((ArrayList)headerCusNums).clone();
            Iterator iterator = headerCusNumsClone.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                if (!unHeaderCusNums.contains(next)) continue;
                iterator.remove();
            }
            for (String cusNum : headerCusNumsClone) {
                DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billmapping");
                Optional<DynamicObject> optional = headerCusCollection.stream().filter(v -> v.getString("number").equals(cusNum)).findFirst();
                DynamicObject cusData = optional.get();
                newData.set("name", (Object)cusData.getString("name"));
                newData.set("number", (Object)cusNum);
                newData.set("mappingtype", (Object)MappingTypeEnum.MAPPING.getValue());
                newData.set("cusattribute", (Object)ATTRIBUTE_CUS);
                newData.set("tag", (Object)"0");
                newData.set("bill", dyo.getPkValue());
                newData.set("billname", (Object)dyo.getString("name"));
                newData.set("billnumber", (Object)dyo.getString("number"));
                newData.set("createtime", (Object)new Date());
                newData.set("status", (Object)"A");
                newData.set("enable", (Object)HEADER_TAG_Y);
                newData.set("sequence", (Object)cusData.getInt("sequence"));
                newDatas.add(newData);
            }
        }
        if (!CollectionUtils.isEmpty(newDatas)) {
            SaveServiceHelper.save((DynamicObject[])newDatas.toArray(new DynamicObject[0]));
        }
        this.refreshCurrPage(true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u540c\u6b65\u6210\u529f\u3002", (String)"BillMappingMenuTreePlugin_9", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
    }

    private void setColEditorProp() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(MENU_ENTRY, "setColEditorProp", new Object[]{"mappingname", "sx", Boolean.FALSE});
    }

    private int getReimburseStatusIndex() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(MENU_ENTRY);
        int index = -1;
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!((DynamicObject)entryEntity.get(i)).getString("number").equals("reimbursestatus")) continue;
            index = i;
            break;
        }
        return index;
    }
}

