/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.OperationRuleEnum;

public class BillOperationListPlugin
extends AbstractFormPlugin {
    private static final String CACHE_DELETE_DATA = "deleteData";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Delete) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow row : rows) {
                long id = (Long)row.getPrimaryKeyValue();
                ids.add(id);
            }
            QFilter idFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection entityNumberList = QueryServiceHelper.query((String)"dhc_operation", (String)"bindbill.number", (QFilter[])new QFilter[]{idFilter});
            StringBuilder entityNumber = new StringBuilder(((DynamicObject)entityNumberList.get(0)).getString("bindbill.number"));
            for (int i = 1; i < entityNumberList.size(); ++i) {
                entityNumber.append(',');
                entityNumber.append(((DynamicObject)entityNumberList.get(i)).getString("bindbill.number"));
            }
            this.getPageCache().put(CACHE_DELETE_DATA, entityNumber.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Delete && args.getOperationResult().isSuccess()) {
            this.deleteOpBizRule();
            this.deleteDataInitRecord();
        }
    }

    private void deleteOpBizRule() {
        String entityNumber = this.getPageCache().get(CACHE_DELETE_DATA);
        List<String> entityNumberList = this.transformStringToList(entityNumber);
        for (String number : entityNumberList) {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)number, (String)OperationRuleEnum.Data_Synchronization.getValue());
        }
        OpBizRuleSetServiceHelper.clearCache();
    }

    private void deleteDataInitRecord() {
        String entityNumber = this.getPageCache().get(CACHE_DELETE_DATA);
        QFilter numberFilter = new QFilter("bill.number", "=", (Object)entityNumber);
        QFilter initFilter = new QFilter("initstatus", "=", (Object)EntityField.buildSelectField((String[])new String[]{"bill.number", "initstatus"}));
        DeleteServiceHelper.delete((String)"dhc_billdatainit", (QFilter[])new QFilter[]{numberFilter, initFilter});
    }

    private List<String> transformStringToList(String str) {
        String[] split = str.split(",");
        ArrayList<String> res = new ArrayList<String>(16);
        for (String s : split) {
            res.add(s.trim());
        }
        return res;
    }
}

