/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;

public class MyBillFilterEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_FFILTERGRID = "filtergridap";
    private static final String FORMID = "formId";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        super.initialize();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams)) {
            return;
        }
        Object entityNumber = customParams.get(FORMID);
        if (StringUtils.isNotBlank(entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber.toString());
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FFILTERGRID);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber.toString());
        }
        Object name = customParams.get("name");
        this.getModel().setValue("name", name);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FFILTERGRID);
        FilterCondition filterCondition = this.loadFilter();
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
            Object formid = this.getView().getFormShowParameter().getCustomParams().get(FORMID);
            if (!ObjectUtils.isEmpty(formid)) {
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)((String)formid));
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), false);
                filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
                filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
                try {
                    filterBuilder.buildFilter(false);
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
                this.getModel().setValue("description", (Object)filterBuilder.getFilterString());
                this.getView().updateView("description");
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.getDefault())) {
            case "btnok": {
                FilterCondition filterCondition = this.getFilter();
                Object formid = this.getView().getFormShowParameter().getCustomParams().get(FORMID);
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)((String)formid));
                FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
                try {
                    filterBuilder.buildFilter(false);
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                    return;
                }
                String filter = "";
                if (filterCondition != null) {
                    filter = SerializationUtils.toJsonString((Object)filterCondition);
                }
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("name", this.getModel().getValue("name"));
                para.put("condition", filter);
                this.getView().returnDataToParent(para);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FFILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return filterGridState.getFilterCondition();
    }

    private FilterCondition loadFilter() {
        Object condition = this.getView().getFormShowParameter().getCustomParams().get("condition");
        if (StringUtils.isBlank(condition)) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)condition.toString(), FilterCondition.class);
    }
}

