/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.helper.BillPrintServiceHelper;
import kd.fi.dhc.util.FormValidationUtil;
import kd.fi.hdc.cache.DhcDistributeCache;

public class MyBillListReformRptPrintPlugin
extends AbstractReportFormPlugin {
    public Integer resetDataCount() {
        Integer count = 0;
        String countStr = DhcDistributeCache.get((String)"cache_my_list_query_count");
        if (StringUtils.isNotBlank((CharSequence)countStr)) {
            count = Integer.valueOf(countStr);
        }
        return count;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IReportView view = this.getView();
        if ("print".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            List<DynamicObject> selectedRows = this.getSelectRows();
            int size = selectedRows.size();
            if (FormValidationUtil.isSelectRowsInvalid((IFormView)view, size, true)) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(size);
            ArrayList<Long> idList = new ArrayList<Long>(size);
            for (DynamicObject dyo : selectedRows) {
                String billIdTmp = dyo.getString("billid");
                if (StringUtils.isNotBlank((CharSequence)billIdTmp)) {
                    Long billId = Long.valueOf(billIdTmp);
                    ids.add(billId);
                }
                idList.add(dyo.getLong("id"));
            }
            QFilter qFilter = new QFilter("billid", "in", ids);
            String selectProperties = EntityField.buildSelectField((String[])new String[]{"id", "billno", "billid", "bill.number", "billnew.id"});
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"dhc_mybilllist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects == null || dynamicObjects.length <= 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"MyBillListPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ids.size() > 100) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6253\u5370\u6570\u91cf\u4e0d\u8d85\u8fc7100\u6761\u3002", (String)"MyBillListPrintPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (dynamicObjects.length) {
                case 1: {
                    BillPrintServiceHelper.onlyOnePrint((DynamicObject[])dynamicObjects, (IFormView)view);
                    break;
                }
                default: {
                    BillPrintServiceHelper.showPrinting((Object[])idList.toArray(), (IFormView)view);
                }
            }
        }
    }

    private List<DynamicObject> getSelectRows() {
        ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>(1);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        Map state = reportList.getEntryState().getState();
        Object rowIndex = state.get("selRows");
        if (rowIndex instanceof List) {
            List rowIndexList = (List)rowIndex;
            IReportListModel reportModel = reportList.getReportModel();
            for (Object indexTmp : rowIndexList) {
                if (!(indexTmp instanceof Integer)) continue;
                Integer index = (Integer)indexTmp;
                DynamicObject selectedRow = reportModel.getRowData(index.intValue());
                selectedRows.add(selectedRow);
            }
        }
        return selectedRows;
    }
}

